/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkStructLike;
import org.apache.iceberg.spark.SparkValueConverter;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;

public class SparkDataFile
implements DataFile {
    private final int filePathPosition;
    private final int fileFormatPosition;
    private final int partitionPosition;
    private final int recordCountPosition;
    private final int fileSizeInBytesPosition;
    private final int columnSizesPosition;
    private final int valueCountsPosition;
    private final int nullValueCountsPosition;
    private final int nanValueCountsPosition;
    private final int lowerBoundsPosition;
    private final int upperBoundsPosition;
    private final int keyMetadataPosition;
    private final int splitOffsetsPosition;
    private final int sortOrderIdPosition;
    private final Type lowerBoundsType;
    private final Type upperBoundsType;
    private final Type keyMetadataType;
    private final SparkStructLike wrappedPartition;
    private final StructLike partitionProjection;
    private Row wrapped;

    public SparkDataFile(Types.StructType type, StructType sparkType) {
        this(type, null, sparkType);
    }

    public SparkDataFile(Types.StructType type, Types.StructType projectedType, StructType sparkType) {
        this.lowerBoundsType = type.fieldType("lower_bounds");
        this.upperBoundsType = type.fieldType("upper_bounds");
        this.keyMetadataType = type.fieldType("key_metadata");
        Types.StructType partitionType = type.fieldType("partition").asStructType();
        this.wrappedPartition = new SparkStructLike(partitionType);
        if (projectedType != null) {
            Types.StructType projectedPartitionType = projectedType.fieldType("partition").asStructType();
            this.partitionProjection = StructProjection.create((Types.StructType)partitionType, (Types.StructType)projectedPartitionType).wrap((StructLike)this.wrappedPartition);
        } else {
            this.partitionProjection = this.wrappedPartition;
        }
        HashMap positions = Maps.newHashMap();
        type.fields().forEach(field -> {
            String fieldName = field.name();
            positions.put(fieldName, this.fieldPosition(fieldName, sparkType));
        });
        this.filePathPosition = (Integer)positions.get("file_path");
        this.fileFormatPosition = (Integer)positions.get("file_format");
        this.partitionPosition = (Integer)positions.get("partition");
        this.recordCountPosition = (Integer)positions.get("record_count");
        this.fileSizeInBytesPosition = (Integer)positions.get("file_size_in_bytes");
        this.columnSizesPosition = (Integer)positions.get("column_sizes");
        this.valueCountsPosition = (Integer)positions.get("value_counts");
        this.nullValueCountsPosition = (Integer)positions.get("null_value_counts");
        this.nanValueCountsPosition = (Integer)positions.get("nan_value_counts");
        this.lowerBoundsPosition = (Integer)positions.get("lower_bounds");
        this.upperBoundsPosition = (Integer)positions.get("upper_bounds");
        this.keyMetadataPosition = (Integer)positions.get("key_metadata");
        this.splitOffsetsPosition = (Integer)positions.get("split_offsets");
        this.sortOrderIdPosition = (Integer)positions.get("sort_order_id");
    }

    public SparkDataFile wrap(Row row) {
        this.wrapped = row;
        if (this.wrappedPartition.size() > 0) {
            this.wrappedPartition.wrap((Row)row.getAs(this.partitionPosition));
        }
        return this;
    }

    public Long pos() {
        return null;
    }

    public int specId() {
        return -1;
    }

    public CharSequence path() {
        return (CharSequence)this.wrapped.getAs(this.filePathPosition);
    }

    public FileFormat format() {
        String formatAsString = this.wrapped.getString(this.fileFormatPosition).toUpperCase(Locale.ROOT);
        return FileFormat.valueOf((String)formatAsString);
    }

    public StructLike partition() {
        return this.partitionProjection;
    }

    public long recordCount() {
        return (Long)this.wrapped.getAs(this.recordCountPosition);
    }

    public long fileSizeInBytes() {
        return (Long)this.wrapped.getAs(this.fileSizeInBytesPosition);
    }

    public Map<Integer, Long> columnSizes() {
        return this.wrapped.isNullAt(this.columnSizesPosition) ? null : this.wrapped.getJavaMap(this.columnSizesPosition);
    }

    public Map<Integer, Long> valueCounts() {
        return this.wrapped.isNullAt(this.valueCountsPosition) ? null : this.wrapped.getJavaMap(this.valueCountsPosition);
    }

    public Map<Integer, Long> nullValueCounts() {
        return this.wrapped.isNullAt(this.nullValueCountsPosition) ? null : this.wrapped.getJavaMap(this.nullValueCountsPosition);
    }

    public Map<Integer, Long> nanValueCounts() {
        return this.wrapped.isNullAt(this.nanValueCountsPosition) ? null : this.wrapped.getJavaMap(this.nanValueCountsPosition);
    }

    public Map<Integer, ByteBuffer> lowerBounds() {
        Map lowerBounds = this.wrapped.isNullAt(this.lowerBoundsPosition) ? null : this.wrapped.getJavaMap(this.lowerBoundsPosition);
        return (Map)this.convert(this.lowerBoundsType, lowerBounds);
    }

    public Map<Integer, ByteBuffer> upperBounds() {
        Map upperBounds = this.wrapped.isNullAt(this.upperBoundsPosition) ? null : this.wrapped.getJavaMap(this.upperBoundsPosition);
        return (Map)this.convert(this.upperBoundsType, upperBounds);
    }

    public ByteBuffer keyMetadata() {
        return (ByteBuffer)this.convert(this.keyMetadataType, this.wrapped.get(this.keyMetadataPosition));
    }

    public DataFile copy() {
        throw new UnsupportedOperationException("Not implemented: copy");
    }

    public DataFile copyWithoutStats() {
        throw new UnsupportedOperationException("Not implemented: copyWithoutStats");
    }

    public List<Long> splitOffsets() {
        return this.wrapped.isNullAt(this.splitOffsetsPosition) ? null : this.wrapped.getList(this.splitOffsetsPosition);
    }

    public Integer sortOrderId() {
        return (Integer)this.wrapped.getAs(this.sortOrderIdPosition);
    }

    private int fieldPosition(String name, StructType sparkType) {
        try {
            return sparkType.fieldIndex(name);
        }
        catch (IllegalArgumentException e) {
            if (name.equals("partition") && this.wrappedPartition.size() == 0) {
                return -1;
            }
            throw e;
        }
    }

    private <T> T convert(Type valueType, Object value) {
        return (T)SparkValueConverter.convert(valueType, value);
    }
}

