/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.NaNUtil;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.sources.AlwaysFalse;
import org.apache.spark.sql.sources.AlwaysFalse$;
import org.apache.spark.sql.sources.AlwaysTrue;
import org.apache.spark.sql.sources.AlwaysTrue$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringStartsWith;

public class SparkFilters {
    private static final Pattern BACKTICKS_PATTERN = Pattern.compile("([`])(.|$)");
    private static final Map<Class<? extends Filter>, Expression.Operation> FILTERS = ImmutableMap.builder().put(AlwaysTrue.class, (Object)Expression.Operation.TRUE).put(AlwaysTrue$.class, (Object)Expression.Operation.TRUE).put(AlwaysFalse$.class, (Object)Expression.Operation.FALSE).put(AlwaysFalse.class, (Object)Expression.Operation.FALSE).put(EqualTo.class, (Object)Expression.Operation.EQ).put(EqualNullSafe.class, (Object)Expression.Operation.EQ).put(GreaterThan.class, (Object)Expression.Operation.GT).put(GreaterThanOrEqual.class, (Object)Expression.Operation.GT_EQ).put(LessThan.class, (Object)Expression.Operation.LT).put(LessThanOrEqual.class, (Object)Expression.Operation.LT_EQ).put(In.class, (Object)Expression.Operation.IN).put(IsNull.class, (Object)Expression.Operation.IS_NULL).put(IsNotNull.class, (Object)Expression.Operation.NOT_NULL).put(And.class, (Object)Expression.Operation.AND).put(Or.class, (Object)Expression.Operation.OR).put(Not.class, (Object)Expression.Operation.NOT).put(StringStartsWith.class, (Object)Expression.Operation.STARTS_WITH).build();

    private SparkFilters() {
    }

    public static Expression convert(Filter[] filters) {
        True expression = Expressions.alwaysTrue();
        for (Filter filter : filters) {
            Expression converted = SparkFilters.convert(filter);
            Preconditions.checkArgument((converted != null ? 1 : 0) != 0, (String)"Cannot convert filter to Iceberg: %s", (Object)filter);
            expression = Expressions.and((Expression)expression, (Expression)converted);
        }
        return expression;
    }

    public static Expression convert(Filter filter) {
        Expression.Operation op = FILTERS.get(filter.getClass());
        if (op != null) {
            switch (op) {
                case TRUE: {
                    return Expressions.alwaysTrue();
                }
                case FALSE: {
                    return Expressions.alwaysFalse();
                }
                case IS_NULL: {
                    IsNull isNullFilter = (IsNull)filter;
                    return Expressions.isNull((String)SparkFilters.unquote(isNullFilter.attribute()));
                }
                case NOT_NULL: {
                    IsNotNull notNullFilter = (IsNotNull)filter;
                    return Expressions.notNull((String)SparkFilters.unquote(notNullFilter.attribute()));
                }
                case LT: {
                    LessThan lt = (LessThan)filter;
                    return Expressions.lessThan((String)SparkFilters.unquote(lt.attribute()), (Object)SparkFilters.convertLiteral(lt.value()));
                }
                case LT_EQ: {
                    LessThanOrEqual ltEq = (LessThanOrEqual)filter;
                    return Expressions.lessThanOrEqual((String)SparkFilters.unquote(ltEq.attribute()), (Object)SparkFilters.convertLiteral(ltEq.value()));
                }
                case GT: {
                    GreaterThan gt = (GreaterThan)filter;
                    return Expressions.greaterThan((String)SparkFilters.unquote(gt.attribute()), (Object)SparkFilters.convertLiteral(gt.value()));
                }
                case GT_EQ: {
                    GreaterThanOrEqual gtEq = (GreaterThanOrEqual)filter;
                    return Expressions.greaterThanOrEqual((String)SparkFilters.unquote(gtEq.attribute()), (Object)SparkFilters.convertLiteral(gtEq.value()));
                }
                case EQ: {
                    if (filter instanceof EqualTo) {
                        EqualTo eq = (EqualTo)filter;
                        Preconditions.checkNotNull((Object)eq.value(), (String)"Expression is always false (eq is not null-safe): %s", (Object)filter);
                        return SparkFilters.handleEqual(SparkFilters.unquote(eq.attribute()), eq.value());
                    }
                    EqualNullSafe eq = (EqualNullSafe)filter;
                    if (eq.value() == null) {
                        return Expressions.isNull((String)SparkFilters.unquote(eq.attribute()));
                    }
                    return SparkFilters.handleEqual(SparkFilters.unquote(eq.attribute()), eq.value());
                }
                case IN: {
                    In inFilter = (In)filter;
                    return Expressions.in((String)SparkFilters.unquote(inFilter.attribute()), (Iterable)Stream.of(inFilter.values()).filter(Objects::nonNull).map(SparkFilters::convertLiteral).collect(Collectors.toList()));
                }
                case NOT: {
                    Expression child;
                    Not notFilter = (Not)filter;
                    Filter childFilter = notFilter.child();
                    Expression.Operation childOp = FILTERS.get(childFilter.getClass());
                    if (childOp == Expression.Operation.IN) {
                        In childInFilter = (In)childFilter;
                        UnboundPredicate notIn = Expressions.notIn((String)SparkFilters.unquote(childInFilter.attribute()), (Iterable)Stream.of(childInFilter.values()).map(SparkFilters::convertLiteral).collect(Collectors.toList()));
                        return Expressions.and((Expression)Expressions.notNull((String)childInFilter.attribute()), (Expression)notIn);
                    }
                    if (SparkFilters.hasNoInFilter(childFilter) && (child = SparkFilters.convert(childFilter)) != null) {
                        return Expressions.not((Expression)child);
                    }
                    return null;
                }
                case AND: {
                    And andFilter = (And)filter;
                    Expression left = SparkFilters.convert(andFilter.left());
                    Expression right = SparkFilters.convert(andFilter.right());
                    if (left != null && right != null) {
                        return Expressions.and((Expression)left, (Expression)right);
                    }
                    return null;
                }
                case OR: {
                    Or orFilter = (Or)filter;
                    Expression left = SparkFilters.convert(orFilter.left());
                    Expression right = SparkFilters.convert(orFilter.right());
                    if (left != null && right != null) {
                        return Expressions.or((Expression)left, (Expression)right);
                    }
                    return null;
                }
                case STARTS_WITH: {
                    StringStartsWith stringStartsWith = (StringStartsWith)filter;
                    return Expressions.startsWith((String)SparkFilters.unquote(stringStartsWith.attribute()), (String)stringStartsWith.value());
                }
            }
        }
        return null;
    }

    private static Object convertLiteral(Object value) {
        if (value instanceof Timestamp) {
            return DateTimeUtils.fromJavaTimestamp((Timestamp)((Timestamp)value));
        }
        if (value instanceof Date) {
            return DateTimeUtils.fromJavaDate((Date)((Date)value));
        }
        if (value instanceof Instant) {
            return DateTimeUtils.instantToMicros((Instant)((Instant)value));
        }
        if (value instanceof LocalDate) {
            return DateTimeUtils.localDateToDays((LocalDate)((LocalDate)value));
        }
        return value;
    }

    private static Expression handleEqual(String attribute, Object value) {
        if (NaNUtil.isNaN((Object)value)) {
            return Expressions.isNaN((String)attribute);
        }
        return Expressions.equal((String)attribute, (Object)SparkFilters.convertLiteral(value));
    }

    private static String unquote(String attributeName) {
        Matcher matcher = BACKTICKS_PATTERN.matcher(attributeName);
        return matcher.replaceAll("$2");
    }

    private static boolean hasNoInFilter(Filter filter) {
        Expression.Operation op = FILTERS.get(filter.getClass());
        if (op != null) {
            switch (op) {
                case AND: {
                    And andFilter = (And)filter;
                    return SparkFilters.hasNoInFilter(andFilter.left()) && SparkFilters.hasNoInFilter(andFilter.right());
                }
                case OR: {
                    Or orFilter = (Or)filter;
                    return SparkFilters.hasNoInFilter(orFilter.left()) && SparkFilters.hasNoInFilter(orFilter.right());
                }
                case NOT: {
                    Not notFilter = (Not)filter;
                    return SparkFilters.hasNoInFilter(notFilter.child());
                }
                case IN: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

