/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.BaseCatalog;
import org.apache.iceberg.spark.RollbackStagedTable;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.source.HasIcebergCatalog;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.StagedTable;
import org.apache.spark.sql.connector.catalog.StagingTableCatalog;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkSessionCatalog<T extends TableCatalog & SupportsNamespaces>
extends BaseCatalog
implements CatalogExtension {
    private static final String[] DEFAULT_NAMESPACE = new String[]{"default"};
    private String catalogName = null;
    private TableCatalog icebergCatalog = null;
    private StagingTableCatalog asStagingCatalog = null;
    private T sessionCatalog = null;
    private boolean createParquetAsIceberg = false;
    private boolean createAvroAsIceberg = false;
    private boolean createOrcAsIceberg = false;

    protected TableCatalog buildSparkCatalog(String name, CaseInsensitiveStringMap options) {
        SparkCatalog newCatalog = new SparkCatalog();
        newCatalog.initialize(name, options);
        return newCatalog;
    }

    public String[] defaultNamespace() {
        return DEFAULT_NAMESPACE;
    }

    public String[][] listNamespaces() throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.getSessionCatalog()).listNamespaces();
    }

    public String[][] listNamespaces(String[] namespace) throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.getSessionCatalog()).listNamespaces(namespace);
    }

    public boolean namespaceExists(String[] namespace) {
        return ((SupportsNamespaces)this.getSessionCatalog()).namespaceExists(namespace);
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.getSessionCatalog()).loadNamespaceMetadata(namespace);
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        ((SupportsNamespaces)this.getSessionCatalog()).createNamespace(namespace, metadata);
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) throws NoSuchNamespaceException {
        ((SupportsNamespaces)this.getSessionCatalog()).alterNamespace(namespace, changes);
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException, NonEmptyNamespaceException {
        return ((SupportsNamespaces)this.getSessionCatalog()).dropNamespace(namespace, cascade);
    }

    public Identifier[] listTables(String[] namespace) throws NoSuchNamespaceException {
        return this.getSessionCatalog().listTables(namespace);
    }

    public Table loadTable(Identifier ident) throws NoSuchTableException {
        try {
            return this.icebergCatalog.loadTable(ident);
        }
        catch (NoSuchTableException e) {
            return this.getSessionCatalog().loadTable(ident);
        }
    }

    public Table loadTable(Identifier ident, String version) throws NoSuchTableException {
        try {
            return this.icebergCatalog.loadTable(ident, version);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            return this.getSessionCatalog().loadTable(ident, version);
        }
    }

    public Table loadTable(Identifier ident, long timestamp) throws NoSuchTableException {
        try {
            return this.icebergCatalog.loadTable(ident, timestamp);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            return this.getSessionCatalog().loadTable(ident, timestamp);
        }
    }

    public void invalidateTable(Identifier ident) {
        this.icebergCatalog.invalidateTable(ident);
        this.getSessionCatalog().invalidateTable(ident);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        String provider = properties.get("provider");
        if (this.useIceberg(provider)) {
            return this.icebergCatalog.createTable(ident, schema, partitions, properties);
        }
        return this.getSessionCatalog().createTable(ident, schema, partitions, properties);
    }

    public StagedTable stageCreate(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        Object catalog;
        String provider = properties.get("provider");
        if (this.useIceberg(provider)) {
            if (this.asStagingCatalog != null) {
                return this.asStagingCatalog.stageCreate(ident, schema, partitions, properties);
            }
            catalog = this.icebergCatalog;
        } else {
            catalog = this.getSessionCatalog();
        }
        Table table = catalog.createTable(ident, schema, partitions, properties);
        return new RollbackStagedTable((TableCatalog)catalog, ident, table);
    }

    public StagedTable stageReplace(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws NoSuchNamespaceException, NoSuchTableException {
        Object catalog;
        String provider = properties.get("provider");
        if (this.useIceberg(provider)) {
            if (this.asStagingCatalog != null) {
                return this.asStagingCatalog.stageReplace(ident, schema, partitions, properties);
            }
            catalog = this.icebergCatalog;
        } else {
            catalog = this.getSessionCatalog();
        }
        if (!catalog.dropTable(ident)) {
            throw new NoSuchTableException(ident);
        }
        try {
            Table table = catalog.createTable(ident, schema, partitions, properties);
            return new RollbackStagedTable((TableCatalog)catalog, ident, table);
        }
        catch (TableAlreadyExistsException e) {
            return this.stageReplace(ident, schema, partitions, properties);
        }
    }

    public StagedTable stageCreateOrReplace(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws NoSuchNamespaceException {
        Object catalog;
        String provider = properties.get("provider");
        if (this.useIceberg(provider)) {
            if (this.asStagingCatalog != null) {
                return this.asStagingCatalog.stageCreateOrReplace(ident, schema, partitions, properties);
            }
            catalog = this.icebergCatalog;
        } else {
            catalog = this.getSessionCatalog();
        }
        catalog.dropTable(ident);
        try {
            Table sessionCatalogTable = catalog.createTable(ident, schema, partitions, properties);
            return new RollbackStagedTable((TableCatalog)catalog, ident, sessionCatalogTable);
        }
        catch (TableAlreadyExistsException e) {
            return this.stageCreateOrReplace(ident, schema, partitions, properties);
        }
    }

    public Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        if (this.icebergCatalog.tableExists(ident)) {
            return this.icebergCatalog.alterTable(ident, changes);
        }
        return this.getSessionCatalog().alterTable(ident, changes);
    }

    public boolean dropTable(Identifier ident) {
        return this.icebergCatalog.dropTable(ident) || this.getSessionCatalog().dropTable(ident);
    }

    public boolean purgeTable(Identifier ident) {
        return this.icebergCatalog.purgeTable(ident) || this.getSessionCatalog().purgeTable(ident);
    }

    public void renameTable(Identifier from, Identifier to) throws NoSuchTableException, TableAlreadyExistsException {
        if (this.icebergCatalog.tableExists(from)) {
            this.icebergCatalog.renameTable(from, to);
        } else {
            this.getSessionCatalog().renameTable(from, to);
        }
    }

    public final void initialize(String name, CaseInsensitiveStringMap options) {
        if (options.containsKey((Object)"type") && options.get((Object)"type").equalsIgnoreCase("hive")) {
            this.validateHmsUri(options.get((Object)"uri"));
        }
        this.catalogName = name;
        this.icebergCatalog = this.buildSparkCatalog(name, options);
        if (this.icebergCatalog instanceof StagingTableCatalog) {
            this.asStagingCatalog = (StagingTableCatalog)this.icebergCatalog;
        }
        this.createParquetAsIceberg = options.getBoolean("parquet-enabled", this.createParquetAsIceberg);
        this.createAvroAsIceberg = options.getBoolean("avro-enabled", this.createAvroAsIceberg);
        this.createOrcAsIceberg = options.getBoolean("orc-enabled", this.createOrcAsIceberg);
    }

    private void validateHmsUri(String catalogHmsUri) {
        if (catalogHmsUri == null) {
            return;
        }
        Configuration conf = SparkSession.active().sessionState().newHadoopConf();
        String envHmsUri = conf.get(HiveConf.ConfVars.METASTOREURIS.varname, null);
        if (envHmsUri == null) {
            return;
        }
        Preconditions.checkArgument((boolean)catalogHmsUri.equals(envHmsUri), (String)"Inconsistent Hive metastore URIs: %s (Spark session) != %s (spark_catalog)", (Object)envHmsUri, (Object)catalogHmsUri);
    }

    public void setDelegateCatalog(CatalogPlugin sparkSessionCatalog) {
        if (!(sparkSessionCatalog instanceof TableCatalog) || !(sparkSessionCatalog instanceof SupportsNamespaces)) {
            throw new IllegalArgumentException("Invalid session catalog: " + sparkSessionCatalog);
        }
        this.sessionCatalog = (TableCatalog)sparkSessionCatalog;
    }

    public String name() {
        return this.catalogName;
    }

    private boolean useIceberg(String provider) {
        if (provider == null || "iceberg".equalsIgnoreCase(provider)) {
            return true;
        }
        if (this.createParquetAsIceberg && "parquet".equalsIgnoreCase(provider)) {
            return true;
        }
        if (this.createAvroAsIceberg && "avro".equalsIgnoreCase(provider)) {
            return true;
        }
        return this.createOrcAsIceberg && "orc".equalsIgnoreCase(provider);
    }

    private T getSessionCatalog() {
        Preconditions.checkNotNull(this.sessionCatalog, (Object)"Delegated SessionCatalog is missing. Please make sure your are replacing Spark's default catalog, named 'spark_catalog'.");
        return this.sessionCatalog;
    }

    @Override
    public Catalog icebergCatalog() {
        Preconditions.checkArgument((boolean)(this.icebergCatalog instanceof HasIcebergCatalog), (Object)"Cannot return underlying Iceberg Catalog, wrapped catalog does not contain an Iceberg Catalog");
        return ((HasIcebergCatalog)this.icebergCatalog).icebergCatalog();
    }

    public Identifier[] listFunctions(String[] namespace) {
        return new Identifier[0];
    }

    public UnboundFunction loadFunction(Identifier ident) throws NoSuchFunctionException {
        throw new NoSuchFunctionException(ident);
    }
}

