/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.StaticTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.ClosingIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.JobGroupInfo;
import org.apache.iceberg.spark.JobGroupUtils;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.spark.actions.ManifestFileBean;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import scala.Tuple2;

abstract class BaseSparkAction<ThisT> {
    protected static final String CONTENT_FILE = "Content File";
    protected static final String MANIFEST = "Manifest";
    protected static final String MANIFEST_LIST = "Manifest List";
    protected static final String OTHERS = "Others";
    protected static final String FILE_PATH = "file_path";
    protected static final String FILE_TYPE = "file_type";
    protected static final String LAST_MODIFIED = "last_modified";
    private static final AtomicInteger JOB_COUNTER = new AtomicInteger();
    private final SparkSession spark;
    private final JavaSparkContext sparkContext;
    private final Map<String, String> options = Maps.newHashMap();

    protected BaseSparkAction(SparkSession spark) {
        this.spark = spark;
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
    }

    protected SparkSession spark() {
        return this.spark;
    }

    protected JavaSparkContext sparkContext() {
        return this.sparkContext;
    }

    protected abstract ThisT self();

    public ThisT option(String name, String value) {
        this.options.put(name, value);
        return this.self();
    }

    public ThisT options(Map<String, String> newOptions) {
        this.options.putAll(newOptions);
        return this.self();
    }

    protected Map<String, String> options() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T withJobGroupInfo(JobGroupInfo info, Supplier<T> supplier) {
        SparkContext context = this.spark().sparkContext();
        JobGroupInfo previousInfo = JobGroupUtils.getJobGroupInfo(context);
        try {
            JobGroupUtils.setJobGroupInfo(context, info);
            T t = supplier.get();
            return t;
        }
        finally {
            JobGroupUtils.setJobGroupInfo(context, previousInfo);
        }
    }

    protected JobGroupInfo newJobGroupInfo(String groupId, String desc) {
        return new JobGroupInfo(groupId + "-" + JOB_COUNTER.incrementAndGet(), desc, false);
    }

    protected Table newStaticTable(TableMetadata metadata, FileIO io) {
        String metadataFileLocation = metadata.metadataFileLocation();
        StaticTableOperations ops = new StaticTableOperations(metadataFileLocation, io);
        return new BaseTable((TableOperations)ops, metadataFileLocation);
    }

    protected Dataset<Row> buildValidContentFileWithTypeDF(Table table) {
        Broadcast tableBroadcast = this.sparkContext.broadcast((Object)SerializableTableWithSize.copyOf(table));
        Dataset allManifests = this.loadMetadataTable(table, MetadataTableType.ALL_MANIFESTS).selectExpr(new String[]{"content", "path", "length", "partition_spec_id as partitionSpecId", "added_snapshot_id as addedSnapshotId"}).dropDuplicates("path", new String[0]).repartition(this.spark.sessionState().conf().numShufflePartitions()).as(Encoders.bean(ManifestFileBean.class));
        return allManifests.flatMap((FlatMapFunction)new ReadManifest((Broadcast<Table>)tableBroadcast), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING())).toDF(new String[]{FILE_PATH, FILE_TYPE});
    }

    protected Dataset<Row> buildValidContentFileDF(Table table) {
        return this.buildValidContentFileWithTypeDF(table).select(FILE_PATH, new String[0]);
    }

    protected Dataset<Row> buildManifestFileDF(Table table) {
        return this.loadMetadataTable(table, MetadataTableType.ALL_MANIFESTS).select(new Column[]{functions.col((String)"path").as(FILE_PATH)});
    }

    protected Dataset<Row> buildManifestListDF(Table table) {
        List manifestLists = ReachableFileUtil.manifestListLocations((Table)table);
        return this.spark.createDataset(manifestLists, Encoders.STRING()).toDF(new String[]{FILE_PATH});
    }

    protected Dataset<Row> buildOtherMetadataFileDF(Table table) {
        return this.buildOtherMetadataFileDF(table, false);
    }

    protected Dataset<Row> buildAllReachableOtherMetadataFileDF(Table table) {
        return this.buildOtherMetadataFileDF(table, true);
    }

    private Dataset<Row> buildOtherMetadataFileDF(Table table, boolean includePreviousMetadataLocations) {
        ArrayList otherMetadataFiles = Lists.newArrayList();
        otherMetadataFiles.addAll(ReachableFileUtil.metadataFileLocations((Table)table, (boolean)includePreviousMetadataLocations));
        otherMetadataFiles.add(ReachableFileUtil.versionHintLocation((Table)table));
        return this.spark.createDataset((List)otherMetadataFiles, Encoders.STRING()).toDF(new String[]{FILE_PATH});
    }

    protected Dataset<Row> buildValidMetadataFileDF(Table table) {
        Dataset<Row> manifestDF = this.buildManifestFileDF(table);
        Dataset<Row> manifestListDF = this.buildManifestListDF(table);
        Dataset<Row> otherMetadataFileDF = this.buildOtherMetadataFileDF(table);
        return manifestDF.union(otherMetadataFileDF).union(manifestListDF);
    }

    protected Dataset<Row> withFileType(Dataset<Row> ds, String type) {
        return ds.withColumn(FILE_TYPE, functions.lit((Object)type));
    }

    protected Dataset<Row> loadMetadataTable(Table table, MetadataTableType type) {
        return SparkTableUtil.loadMetadataTable(this.spark, table, type);
    }

    private static class ReadManifest
    implements FlatMapFunction<ManifestFileBean, Tuple2<String, String>> {
        private final Broadcast<Table> table;

        ReadManifest(Broadcast<Table> table) {
            this.table = table;
        }

        public Iterator<Tuple2<String, String>> call(ManifestFileBean manifest) {
            return new ClosingIterator(this.entries(manifest));
        }

        public CloseableIterator<Tuple2<String, String>> entries(ManifestFileBean manifest) {
            FileIO io = ((Table)this.table.getValue()).io();
            Map specs = ((Table)this.table.getValue()).specs();
            ImmutableList projection = ImmutableList.of((Object)DataFile.FILE_PATH.name(), (Object)DataFile.CONTENT.name());
            switch (manifest.content()) {
                case DATA: {
                    return CloseableIterator.transform((CloseableIterator)ManifestFiles.read((ManifestFile)manifest, (FileIO)io, (Map)specs).select((Collection)projection).iterator(), ReadManifest::contentFileWithType);
                }
                case DELETES: {
                    return CloseableIterator.transform((CloseableIterator)ManifestFiles.readDeleteManifest((ManifestFile)manifest, (FileIO)io, (Map)specs).select((Collection)projection).iterator(), ReadManifest::contentFileWithType);
                }
            }
            throw new IllegalArgumentException("Unsupported manifest content type:" + manifest.content());
        }

        static Tuple2<String, String> contentFileWithType(ContentFile<?> file) {
            return new Tuple2((Object)file.path().toString(), (Object)file.content().toString());
        }
    }
}

