/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.actions.BaseDeleteReachableFilesActionResult;
import org.apache.iceberg.actions.DeleteReachableFiles;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.JobGroupInfo;
import org.apache.iceberg.spark.actions.BaseSparkAction;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteReachableFilesSparkAction
extends BaseSparkAction<DeleteReachableFilesSparkAction>
implements DeleteReachableFiles {
    public static final String STREAM_RESULTS = "stream-results";
    public static final boolean STREAM_RESULTS_DEFAULT = false;
    private static final Logger LOG = LoggerFactory.getLogger(DeleteReachableFilesSparkAction.class);
    private final String metadataFileLocation;
    private final Consumer<String> defaultDelete = new Consumer<String>(){

        @Override
        public void accept(String file) {
            DeleteReachableFilesSparkAction.this.io.deleteFile(file);
        }
    };
    private Consumer<String> deleteFunc = this.defaultDelete;
    private ExecutorService deleteExecutorService = null;
    private FileIO io = new HadoopFileIO(this.spark().sessionState().newHadoopConf());

    DeleteReachableFilesSparkAction(SparkSession spark, String metadataFileLocation) {
        super(spark);
        this.metadataFileLocation = metadataFileLocation;
    }

    @Override
    protected DeleteReachableFilesSparkAction self() {
        return this;
    }

    public DeleteReachableFilesSparkAction io(FileIO fileIO) {
        this.io = fileIO;
        return this;
    }

    public DeleteReachableFilesSparkAction deleteWith(Consumer<String> newDeleteFunc) {
        this.deleteFunc = newDeleteFunc;
        return this;
    }

    public DeleteReachableFilesSparkAction executeDeleteWith(ExecutorService executorService) {
        this.deleteExecutorService = executorService;
        return this;
    }

    public DeleteReachableFiles.Result execute() {
        Preconditions.checkArgument((this.io != null ? 1 : 0) != 0, (Object)"File IO cannot be null");
        String jobDesc = String.format("Deleting files reachable from %s", this.metadataFileLocation);
        JobGroupInfo info = this.newJobGroupInfo("DELETE-REACHABLE-FILES", jobDesc);
        return this.withJobGroupInfo(info, this::doExecute);
    }

    private DeleteReachableFiles.Result doExecute() {
        TableMetadata metadata = TableMetadataParser.read((FileIO)this.io, (String)this.metadataFileLocation);
        ValidationException.check((boolean)PropertyUtil.propertyAsBoolean((Map)metadata.properties(), (String)"gc.enabled", (boolean)true), (String)"Cannot delete files: GC is disabled (deleting files may corrupt other tables)", (Object[])new Object[0]);
        Dataset reachableFileDF = this.buildReachableFileDF(metadata).distinct();
        boolean streamResults = PropertyUtil.propertyAsBoolean(this.options(), (String)STREAM_RESULTS, (boolean)false);
        if (streamResults) {
            return this.deleteFiles(reachableFileDF.toLocalIterator());
        }
        return this.deleteFiles(reachableFileDF.collectAsList().iterator());
    }

    private Dataset<Row> buildReachableFileDF(TableMetadata metadata) {
        Table staticTable = this.newStaticTable(metadata, this.io);
        return this.withFileType(this.buildValidContentFileDF(staticTable), "Content File").union(this.withFileType(this.buildManifestFileDF(staticTable), "Manifest")).union(this.withFileType(this.buildManifestListDF(staticTable), "Manifest List")).union(this.withFileType(this.buildAllReachableOtherMetadataFileDF(staticTable), "Others"));
    }

    private BaseDeleteReachableFilesActionResult deleteFiles(Iterator<Row> deleted) {
        AtomicLong dataFileCount = new AtomicLong(0L);
        AtomicLong manifestCount = new AtomicLong(0L);
        AtomicLong manifestListCount = new AtomicLong(0L);
        AtomicLong otherFilesCount = new AtomicLong(0L);
        Tasks.foreach(deleted).retry(3).stopRetryOn(new Class[]{NotFoundException.class}).suppressFailureWhenFinished().executeWith(this.deleteExecutorService).onFailure((fileInfo, exc) -> {
            String file = fileInfo.getString(0);
            String type = fileInfo.getString(1);
            LOG.warn("Delete failed for {}: {}", new Object[]{type, file, exc});
        }).run(fileInfo -> {
            String file = fileInfo.getString(0);
            String type = fileInfo.getString(1);
            this.deleteFunc.accept(file);
            switch (type) {
                case "Content File": {
                    dataFileCount.incrementAndGet();
                    LOG.trace("Deleted Content File: {}", (Object)file);
                    break;
                }
                case "Manifest": {
                    manifestCount.incrementAndGet();
                    LOG.debug("Deleted Manifest: {}", (Object)file);
                    break;
                }
                case "Manifest List": {
                    manifestListCount.incrementAndGet();
                    LOG.debug("Deleted Manifest List: {}", (Object)file);
                    break;
                }
                case "Others": {
                    otherFilesCount.incrementAndGet();
                    LOG.debug("Others: {}", (Object)file);
                }
            }
        });
        long filesCount = dataFileCount.get() + manifestCount.get() + manifestListCount.get() + otherFilesCount.get();
        LOG.info("Total files removed: {}", (Object)filesCount);
        return new BaseDeleteReachableFilesActionResult(dataFileCount.get(), manifestCount.get(), manifestListCount.get(), otherFilesCount.get());
    }
}

