/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.actions.BaseExpireSnapshotsActionResult;
import org.apache.iceberg.actions.ExpireSnapshots;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.JobGroupInfo;
import org.apache.iceberg.spark.actions.BaseSparkAction;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireSnapshotsSparkAction
extends BaseSparkAction<ExpireSnapshotsSparkAction>
implements org.apache.iceberg.actions.ExpireSnapshots {
    public static final String STREAM_RESULTS = "stream-results";
    public static final boolean STREAM_RESULTS_DEFAULT = false;
    private static final Logger LOG = LoggerFactory.getLogger(ExpireSnapshotsSparkAction.class);
    private final Table table;
    private final TableOperations ops;
    private final Consumer<String> defaultDelete = new Consumer<String>(){

        @Override
        public void accept(String file) {
            ExpireSnapshotsSparkAction.this.ops.io().deleteFile(file);
        }
    };
    private final Set<Long> expiredSnapshotIds = Sets.newHashSet();
    private Long expireOlderThanValue = null;
    private Integer retainLastValue = null;
    private Consumer<String> deleteFunc = this.defaultDelete;
    private ExecutorService deleteExecutorService = null;
    private Dataset<Row> expiredFiles = null;

    ExpireSnapshotsSparkAction(SparkSession spark, Table table) {
        super(spark);
        this.table = table;
        this.ops = ((HasTableOperations)table).operations();
        ValidationException.check((boolean)PropertyUtil.propertyAsBoolean((Map)table.properties(), (String)"gc.enabled", (boolean)true), (String)"Cannot expire snapshots: GC is disabled (deleting files may corrupt other tables)", (Object[])new Object[0]);
    }

    @Override
    protected ExpireSnapshotsSparkAction self() {
        return this;
    }

    public ExpireSnapshotsSparkAction executeDeleteWith(ExecutorService executorService) {
        this.deleteExecutorService = executorService;
        return this;
    }

    public ExpireSnapshotsSparkAction expireSnapshotId(long snapshotId) {
        this.expiredSnapshotIds.add(snapshotId);
        return this;
    }

    public ExpireSnapshotsSparkAction expireOlderThan(long timestampMillis) {
        this.expireOlderThanValue = timestampMillis;
        return this;
    }

    public ExpireSnapshotsSparkAction retainLast(int numSnapshots) {
        Preconditions.checkArgument((1 <= numSnapshots ? 1 : 0) != 0, (String)"Number of snapshots to retain must be at least 1, cannot be: %s", (int)numSnapshots);
        this.retainLastValue = numSnapshots;
        return this;
    }

    public ExpireSnapshotsSparkAction deleteWith(Consumer<String> newDeleteFunc) {
        this.deleteFunc = newDeleteFunc;
        return this;
    }

    public Dataset<Row> expire() {
        if (this.expiredFiles == null) {
            Dataset<Row> originalFiles = this.buildValidFileDF(this.ops.current());
            ExpireSnapshots expireSnapshots = this.table.expireSnapshots().cleanExpiredFiles(false);
            for (long id : this.expiredSnapshotIds) {
                expireSnapshots = expireSnapshots.expireSnapshotId(id);
            }
            if (this.expireOlderThanValue != null) {
                expireSnapshots = expireSnapshots.expireOlderThan(this.expireOlderThanValue.longValue());
            }
            if (this.retainLastValue != null) {
                expireSnapshots = expireSnapshots.retainLast(this.retainLastValue.intValue());
            }
            expireSnapshots.commit();
            Dataset<Row> validFiles = this.buildValidFileDF(this.ops.refresh());
            this.expiredFiles = originalFiles.except(validFiles);
        }
        return this.expiredFiles;
    }

    public ExpireSnapshots.Result execute() {
        JobGroupInfo info = this.newJobGroupInfo("EXPIRE-SNAPSHOTS", this.jobDesc());
        return this.withJobGroupInfo(info, this::doExecute);
    }

    private String jobDesc() {
        ArrayList options = Lists.newArrayList();
        if (this.expireOlderThanValue != null) {
            options.add("older_than=" + this.expireOlderThanValue);
        }
        if (this.retainLastValue != null) {
            options.add("retain_last=" + this.retainLastValue);
        }
        if (!this.expiredSnapshotIds.isEmpty()) {
            Long first = (Long)this.expiredSnapshotIds.stream().findFirst().get();
            if (this.expiredSnapshotIds.size() > 1) {
                options.add(String.format("snapshot_ids: %s (%s more...)", first, this.expiredSnapshotIds.size() - 1));
            } else {
                options.add(String.format("snapshot_id: %s", first));
            }
        }
        return String.format("Expiring snapshots (%s) in %s", Joiner.on((char)',').join((Iterable)options), this.table.name());
    }

    private ExpireSnapshots.Result doExecute() {
        boolean streamResults = PropertyUtil.propertyAsBoolean(this.options(), (String)STREAM_RESULTS, (boolean)false);
        if (streamResults) {
            return this.deleteFiles(this.expire().toLocalIterator());
        }
        return this.deleteFiles(this.expire().collectAsList().iterator());
    }

    private Dataset<Row> buildValidFileDF(TableMetadata metadata) {
        Table staticTable = this.newStaticTable(metadata, this.table.io());
        return this.buildValidContentFileWithTypeDF(staticTable).union(this.withFileType(this.buildManifestFileDF(staticTable), "Manifest")).union(this.withFileType(this.buildManifestListDF(staticTable), "Manifest List"));
    }

    private BaseExpireSnapshotsActionResult deleteFiles(Iterator<Row> expired) {
        AtomicLong dataFileCount = new AtomicLong(0L);
        AtomicLong posDeleteFileCount = new AtomicLong(0L);
        AtomicLong eqDeleteFileCount = new AtomicLong(0L);
        AtomicLong manifestCount = new AtomicLong(0L);
        AtomicLong manifestListCount = new AtomicLong(0L);
        Tasks.foreach(expired).retry(3).stopRetryOn(new Class[]{NotFoundException.class}).suppressFailureWhenFinished().executeWith(this.deleteExecutorService).onFailure((fileInfo, exc) -> {
            String file = fileInfo.getString(0);
            String type = fileInfo.getString(1);
            LOG.warn("Delete failed for {}: {}", new Object[]{type, file, exc});
        }).run(fileInfo -> {
            String file = fileInfo.getString(0);
            String type = fileInfo.getString(1);
            this.deleteFunc.accept(file);
            if (FileContent.DATA.name().equalsIgnoreCase(type)) {
                dataFileCount.incrementAndGet();
                LOG.trace("Deleted Data File: {}", (Object)file);
            } else if (FileContent.POSITION_DELETES.name().equalsIgnoreCase(type)) {
                posDeleteFileCount.incrementAndGet();
                LOG.trace("Deleted Positional Delete File: {}", (Object)file);
            } else if (FileContent.EQUALITY_DELETES.name().equalsIgnoreCase(type)) {
                eqDeleteFileCount.incrementAndGet();
                LOG.trace("Deleted Equality Delete File: {}", (Object)file);
            } else if ("Manifest".equals(type)) {
                manifestCount.incrementAndGet();
                LOG.debug("Deleted Manifest: {}", (Object)file);
            } else if ("Manifest List".equalsIgnoreCase(type)) {
                manifestListCount.incrementAndGet();
                LOG.debug("Deleted Manifest List: {}", (Object)file);
            } else {
                throw new ValidationException("Illegal file type: %s", new Object[]{type});
            }
        });
        long contentFileCount = dataFileCount.get() + posDeleteFileCount.get() + eqDeleteFileCount.get();
        LOG.info("Deleted {} total files", (Object)(contentFileCount + manifestCount.get() + manifestListCount.get()));
        return new BaseExpireSnapshotsActionResult(dataFileCount.get(), posDeleteFileCount.get(), eqDeleteFileCount.get(), manifestCount.get(), manifestListCount.get());
    }
}

