/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.HashMap;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.BaseMigrateTableActionResult;
import org.apache.iceberg.actions.MigrateTable;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.JobGroupInfo;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.spark.actions.BaseTableCreationSparkAction;
import org.apache.iceberg.spark.source.StagedSparkTable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.StagingTableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters;
import scala.collection.Map;

public class MigrateTableSparkAction
extends BaseTableCreationSparkAction<MigrateTableSparkAction>
implements MigrateTable {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateTableSparkAction.class);
    private static final String BACKUP_SUFFIX = "_BACKUP_";
    private final StagingTableCatalog destCatalog;
    private final Identifier destTableIdent;
    private final Identifier backupIdent;

    MigrateTableSparkAction(SparkSession spark, CatalogPlugin sourceCatalog, Identifier sourceTableIdent) {
        super(spark, sourceCatalog, sourceTableIdent);
        this.destCatalog = this.checkDestinationCatalog(sourceCatalog);
        this.destTableIdent = sourceTableIdent;
        String backupName = sourceTableIdent.name() + BACKUP_SUFFIX;
        this.backupIdent = Identifier.of((String[])sourceTableIdent.namespace(), (String)backupName);
    }

    @Override
    protected MigrateTableSparkAction self() {
        return this;
    }

    @Override
    protected StagingTableCatalog destCatalog() {
        return this.destCatalog;
    }

    @Override
    protected Identifier destTableIdent() {
        return this.destTableIdent;
    }

    public MigrateTableSparkAction tableProperties(java.util.Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public MigrateTableSparkAction tableProperty(String property, String value) {
        this.setProperty(property, value);
        return this;
    }

    public MigrateTable.Result execute() {
        String desc = String.format("Migrating table %s", this.destTableIdent().toString());
        JobGroupInfo info = this.newJobGroupInfo("MIGRATE-TABLE", desc);
        return this.withJobGroupInfo(info, this::doExecute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MigrateTable.Result doExecute() {
        Table icebergTable;
        LOG.info("Starting the migration of {} to Iceberg", (Object)this.sourceTableIdent());
        this.renameAndBackupSourceTable();
        StagedSparkTable stagedTable = null;
        boolean threw = true;
        try {
            LOG.info("Staging a new Iceberg table {}", (Object)this.destTableIdent());
            stagedTable = this.stageDestTable();
            icebergTable = stagedTable.table();
            LOG.info("Ensuring {} has a valid name mapping", (Object)this.destTableIdent());
            this.ensureNameMappingPresent(icebergTable);
            Some backupNamespace = Some.apply((Object)this.backupIdent.namespace()[0]);
            TableIdentifier v1BackupIdent = new TableIdentifier(this.backupIdent.name(), (Option)backupNamespace);
            String stagingLocation = this.getMetadataLocation(icebergTable);
            LOG.info("Generating Iceberg metadata for {} in {}", (Object)this.destTableIdent(), (Object)stagingLocation);
            SparkTableUtil.importSparkTable(this.spark(), v1BackupIdent, icebergTable, stagingLocation);
            LOG.info("Committing staged changes to {}", (Object)this.destTableIdent());
            stagedTable.commitStagedChanges();
            threw = false;
        }
        finally {
            if (threw) {
                LOG.error("Failed to perform the migration, aborting table creation and restoring the original table");
                this.restoreSourceTable();
                if (stagedTable != null) {
                    try {
                        stagedTable.abortStagedChanges();
                    }
                    catch (Exception abortException) {
                        LOG.error("Cannot abort staged changes", (Throwable)abortException);
                    }
                }
            }
        }
        Snapshot snapshot = icebergTable.currentSnapshot();
        long migratedDataFilesCount = Long.parseLong((String)snapshot.summary().get("total-data-files"));
        LOG.info("Successfully loaded Iceberg metadata for {} files to {}", (Object)migratedDataFilesCount, (Object)this.destTableIdent());
        return new BaseMigrateTableActionResult(migratedDataFilesCount);
    }

    @Override
    protected java.util.Map<String, String> destTableProps() {
        HashMap properties = Maps.newHashMap();
        properties.putAll((java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)this.v1SourceTable().properties()).asJava());
        EXCLUDED_PROPERTIES.forEach(properties::remove);
        properties.put("provider", "iceberg");
        properties.putAll(this.additionalProperties());
        properties.put("migrated", "true");
        properties.putIfAbsent("location", this.sourceTableLocation());
        return properties;
    }

    @Override
    protected TableCatalog checkSourceCatalog(CatalogPlugin catalog) {
        Preconditions.checkArgument((boolean)(catalog instanceof SparkSessionCatalog), (String)"Cannot migrate a table from a non-Iceberg Spark Session Catalog. Found %s of class %s as the source catalog.", (Object)catalog.name(), (Object)catalog.getClass().getName());
        return (TableCatalog)catalog;
    }

    private void renameAndBackupSourceTable() {
        try {
            LOG.info("Renaming {} as {} for backup", (Object)this.sourceTableIdent(), (Object)this.backupIdent);
            this.destCatalog().renameTable(this.sourceTableIdent(), this.backupIdent);
        }
        catch (NoSuchTableException e) {
            throw new org.apache.iceberg.exceptions.NoSuchTableException("Cannot find source table %s", new Object[]{this.sourceTableIdent()});
        }
        catch (TableAlreadyExistsException e) {
            throw new AlreadyExistsException("Cannot rename %s as %s for backup. The backup table already exists.", new Object[]{this.sourceTableIdent(), this.backupIdent});
        }
    }

    private void restoreSourceTable() {
        try {
            LOG.info("Restoring {} from {}", (Object)this.sourceTableIdent(), (Object)this.backupIdent);
            this.destCatalog().renameTable(this.backupIdent, this.sourceTableIdent());
        }
        catch (NoSuchTableException e) {
            LOG.error("Cannot restore the original table, the backup table {} cannot be found", (Object)this.backupIdent, (Object)e);
        }
        catch (TableAlreadyExistsException e) {
            LOG.error("Cannot restore the original table, a table with the original name exists. Use the backup table {} to restore the original table manually.", (Object)this.backupIdent, (Object)e);
        }
    }
}

