/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.orc.OrcRowReader;
import org.apache.iceberg.orc.OrcSchemaWithTypeVisitor;
import org.apache.iceberg.orc.OrcValueReader;
import org.apache.iceberg.orc.OrcValueReaders;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.data.SparkOrcValueReaders;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.apache.spark.sql.catalyst.InternalRow;

public class SparkOrcReader
implements OrcRowReader<InternalRow> {
    private final OrcValueReader<?> reader;

    public SparkOrcReader(Schema expectedSchema, TypeDescription readSchema) {
        this(expectedSchema, readSchema, (Map<Integer, ?>)ImmutableMap.of());
    }

    public SparkOrcReader(Schema expectedSchema, TypeDescription readOrcSchema, Map<Integer, ?> idToConstant) {
        this.reader = (OrcValueReader)OrcSchemaWithTypeVisitor.visit((Schema)expectedSchema, (TypeDescription)readOrcSchema, (OrcSchemaWithTypeVisitor)new ReadBuilder(idToConstant));
    }

    public InternalRow read(VectorizedRowBatch batch, int row) {
        return (InternalRow)this.reader.read((ColumnVector)new StructColumnVector(batch.size, batch.cols), row);
    }

    public void setBatchContext(long batchOffsetInFile) {
        this.reader.setBatchContext(batchOffsetInFile);
    }

    private static class ReadBuilder
    extends OrcSchemaWithTypeVisitor<OrcValueReader<?>> {
        private final Map<Integer, ?> idToConstant;

        private ReadBuilder(Map<Integer, ?> idToConstant) {
            this.idToConstant = idToConstant;
        }

        public OrcValueReader<?> record(Types.StructType expected, TypeDescription record, List<String> names, List<OrcValueReader<?>> fields) {
            return SparkOrcValueReaders.struct(fields, expected, this.idToConstant);
        }

        public OrcValueReader<?> list(Types.ListType iList, TypeDescription array, OrcValueReader<?> elementReader) {
            return SparkOrcValueReaders.array(elementReader);
        }

        public OrcValueReader<?> map(Types.MapType iMap, TypeDescription map, OrcValueReader<?> keyReader, OrcValueReader<?> valueReader) {
            return SparkOrcValueReaders.map(keyReader, valueReader);
        }

        public OrcValueReader<?> primitive(Type.PrimitiveType iPrimitive, TypeDescription primitive) {
            switch (primitive.getCategory()) {
                case BOOLEAN: {
                    return OrcValueReaders.booleans();
                }
                case BYTE: 
                case SHORT: 
                case DATE: 
                case INT: {
                    return OrcValueReaders.ints();
                }
                case LONG: {
                    return OrcValueReaders.longs();
                }
                case FLOAT: {
                    return OrcValueReaders.floats();
                }
                case DOUBLE: {
                    return OrcValueReaders.doubles();
                }
                case TIMESTAMP_INSTANT: 
                case TIMESTAMP: {
                    return SparkOrcValueReaders.timestampTzs();
                }
                case DECIMAL: {
                    return SparkOrcValueReaders.decimals(primitive.getPrecision(), primitive.getScale());
                }
                case CHAR: 
                case VARCHAR: 
                case STRING: {
                    return SparkOrcValueReaders.utf8String();
                }
                case BINARY: {
                    return OrcValueReaders.bytes();
                }
            }
            throw new IllegalArgumentException("Unhandled type " + primitive);
        }
    }
}

