/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.orc.GenericOrcWriters;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.orc.OrcRowWriter;
import org.apache.iceberg.orc.OrcSchemaWithTypeVisitor;
import org.apache.iceberg.orc.OrcValueWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.data.SparkOrcValueWriters;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;

public class SparkOrcWriter
implements OrcRowWriter<InternalRow> {
    private final InternalRowWriter writer;

    public SparkOrcWriter(Schema iSchema, TypeDescription orcSchema) {
        Preconditions.checkArgument((orcSchema.getCategory() == TypeDescription.Category.STRUCT ? 1 : 0) != 0, (Object)("Top level must be a struct " + orcSchema));
        this.writer = (InternalRowWriter)((Object)OrcSchemaWithTypeVisitor.visit((Schema)iSchema, (TypeDescription)orcSchema, (OrcSchemaWithTypeVisitor)new WriteBuilder()));
    }

    public void write(InternalRow value, VectorizedRowBatch output) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value must not be null");
        this.writer.writeRow(value, output);
    }

    public List<OrcValueWriter<?>> writers() {
        return this.writer.writers();
    }

    public Stream<FieldMetrics<?>> metrics() {
        return this.writer.metrics();
    }

    static FieldGetter<?> createFieldGetter(TypeDescription fieldType) {
        FieldGetter<Object> fieldGetter;
        switch (fieldType.getCategory()) {
            case BOOLEAN: {
                fieldGetter = SpecializedGetters::getBoolean;
                break;
            }
            case BYTE: {
                fieldGetter = SpecializedGetters::getByte;
                break;
            }
            case SHORT: {
                fieldGetter = SpecializedGetters::getShort;
                break;
            }
            case DATE: 
            case INT: {
                fieldGetter = SpecializedGetters::getInt;
                break;
            }
            case LONG: 
            case TIMESTAMP_INSTANT: 
            case TIMESTAMP: {
                fieldGetter = SpecializedGetters::getLong;
                break;
            }
            case FLOAT: {
                fieldGetter = SpecializedGetters::getFloat;
                break;
            }
            case DOUBLE: {
                fieldGetter = SpecializedGetters::getDouble;
                break;
            }
            case BINARY: {
                fieldGetter = SpecializedGetters::getBinary;
                break;
            }
            case DECIMAL: {
                fieldGetter = (row, ordinal) -> row.getDecimal(ordinal, fieldType.getPrecision(), fieldType.getScale());
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                fieldGetter = SpecializedGetters::getUTF8String;
                break;
            }
            case STRUCT: {
                fieldGetter = (row, ordinal) -> row.getStruct(ordinal, fieldType.getChildren().size());
                break;
            }
            case LIST: {
                fieldGetter = SpecializedGetters::getArray;
                break;
            }
            case MAP: {
                fieldGetter = SpecializedGetters::getMap;
                break;
            }
            default: {
                throw new IllegalArgumentException("Encountered an unsupported ORC type during a write from Spark.");
            }
        }
        return (row, ordinal) -> {
            if (row.isNullAt(ordinal)) {
                return null;
            }
            return fieldGetter.getFieldOrNull(row, ordinal);
        };
    }

    static interface FieldGetter<T>
    extends Serializable {
        @Nullable
        public T getFieldOrNull(SpecializedGetters var1, int var2);
    }

    private static class InternalRowWriter
    extends GenericOrcWriters.StructWriter<InternalRow> {
        private final List<FieldGetter<?>> fieldGetters;

        InternalRowWriter(List<OrcValueWriter<?>> writers, List<TypeDescription> orcTypes) {
            super(writers);
            this.fieldGetters = Lists.newArrayListWithExpectedSize((int)orcTypes.size());
            for (int i = 0; i < orcTypes.size(); ++i) {
                this.fieldGetters.add(SparkOrcWriter.createFieldGetter(orcTypes.get(i)));
            }
        }

        protected Object get(InternalRow struct, int index) {
            return this.fieldGetters.get(index).getFieldOrNull((SpecializedGetters)struct, index);
        }
    }

    private static class WriteBuilder
    extends OrcSchemaWithTypeVisitor<OrcValueWriter<?>> {
        private WriteBuilder() {
        }

        public OrcValueWriter<?> record(Types.StructType iStruct, TypeDescription record, List<String> names, List<OrcValueWriter<?>> fields) {
            return new InternalRowWriter(fields, record.getChildren());
        }

        public OrcValueWriter<?> list(Types.ListType iList, TypeDescription array, OrcValueWriter<?> element) {
            return SparkOrcValueWriters.list(element, array.getChildren());
        }

        public OrcValueWriter<?> map(Types.MapType iMap, TypeDescription map, OrcValueWriter<?> key, OrcValueWriter<?> value) {
            return SparkOrcValueWriters.map(key, value, map.getChildren());
        }

        public OrcValueWriter<?> primitive(Type.PrimitiveType iPrimitive, TypeDescription primitive) {
            switch (primitive.getCategory()) {
                case BOOLEAN: {
                    return GenericOrcWriters.booleans();
                }
                case BYTE: {
                    return GenericOrcWriters.bytes();
                }
                case SHORT: {
                    return GenericOrcWriters.shorts();
                }
                case DATE: 
                case INT: {
                    return GenericOrcWriters.ints();
                }
                case LONG: {
                    return GenericOrcWriters.longs();
                }
                case FLOAT: {
                    return GenericOrcWriters.floats((int)ORCSchemaUtil.fieldId((TypeDescription)primitive));
                }
                case DOUBLE: {
                    return GenericOrcWriters.doubles((int)ORCSchemaUtil.fieldId((TypeDescription)primitive));
                }
                case BINARY: {
                    return GenericOrcWriters.byteArrays();
                }
                case STRING: 
                case CHAR: 
                case VARCHAR: {
                    return SparkOrcValueWriters.strings();
                }
                case DECIMAL: {
                    return SparkOrcValueWriters.decimal(primitive.getPrecision(), primitive.getScale());
                }
                case TIMESTAMP_INSTANT: 
                case TIMESTAMP: {
                    return SparkOrcValueWriters.timestampTz();
                }
            }
            throw new IllegalArgumentException("Unhandled type " + primitive);
        }
    }
}

