/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.vectorized;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.arrow.vectorized.BaseBatchReader;
import org.apache.iceberg.data.DeleteFilter;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.data.vectorized.ColumnVectorWithFilter;
import org.apache.iceberg.spark.data.vectorized.IcebergArrowColumnVector;
import org.apache.iceberg.util.Pair;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class ColumnarBatchReader
extends BaseBatchReader<ColumnarBatch> {
    private DeleteFilter<InternalRow> deletes = null;
    private long rowStartPosInBatch = 0L;

    public ColumnarBatchReader(List<VectorizedReader<?>> readers) {
        super(readers);
    }

    public void setRowGroupInfo(PageReadStore pageStore, Map<ColumnPath, ColumnChunkMetaData> metaData, long rowPosition) {
        super.setRowGroupInfo(pageStore, metaData, rowPosition);
        this.rowStartPosInBatch = rowPosition;
    }

    public void setDeleteFilter(DeleteFilter<InternalRow> deleteFilter) {
        this.deletes = deleteFilter;
    }

    public final ColumnarBatch read(ColumnarBatch reuse, int numRowsToRead) {
        if (reuse == null) {
            this.closeVectors();
        }
        ColumnBatchLoader batchLoader = new ColumnBatchLoader(numRowsToRead);
        this.rowStartPosInBatch += (long)numRowsToRead;
        return batchLoader.columnarBatch;
    }

    private class ColumnBatchLoader {
        private int[] rowIdMapping;
        private int numRows;
        private ColumnarBatch columnarBatch;

        ColumnBatchLoader(int numRowsToRead) {
            this.initRowIdMapping(numRowsToRead);
            this.loadDataToColumnBatch(numRowsToRead);
        }

        ColumnarBatch loadDataToColumnBatch(int numRowsToRead) {
            Preconditions.checkArgument((numRowsToRead > 0 ? 1 : 0) != 0, (String)"Invalid number of rows to read: %s", (int)numRowsToRead);
            ColumnVector[] arrowColumnVectors = this.readDataToColumnVectors(numRowsToRead);
            this.columnarBatch = new ColumnarBatch(arrowColumnVectors);
            this.columnarBatch.setNumRows(this.numRows);
            if (this.hasEqDeletes()) {
                this.applyEqDelete();
            }
            return this.columnarBatch;
        }

        ColumnVector[] readDataToColumnVectors(int numRowsToRead) {
            ColumnVector[] arrowColumnVectors = new ColumnVector[ColumnarBatchReader.this.readers.length];
            for (int i = 0; i < ColumnarBatchReader.this.readers.length; ++i) {
                ((ColumnarBatchReader)ColumnarBatchReader.this).vectorHolders[i] = ColumnarBatchReader.this.readers[i].read(ColumnarBatchReader.this.vectorHolders[i], numRowsToRead);
                int numRowsInVector = ColumnarBatchReader.this.vectorHolders[i].numValues();
                Preconditions.checkState((numRowsInVector == numRowsToRead ? 1 : 0) != 0, (String)"Number of rows in the vector %s didn't match expected %s ", (int)numRowsInVector, (int)numRowsToRead);
                arrowColumnVectors[i] = this.hasDeletes() ? ColumnVectorWithFilter.forHolder(ColumnarBatchReader.this.vectorHolders[i], this.rowIdMapping, this.numRows) : IcebergArrowColumnVector.forHolder(ColumnarBatchReader.this.vectorHolders[i], numRowsInVector);
            }
            return arrowColumnVectors;
        }

        boolean hasDeletes() {
            return this.rowIdMapping != null;
        }

        boolean hasEqDeletes() {
            return ColumnarBatchReader.this.deletes != null && ColumnarBatchReader.this.deletes.hasEqDeletes();
        }

        void initRowIdMapping(int numRowsToRead) {
            Pair<int[], Integer> posDeleteRowIdMapping = this.posDelRowIdMapping(numRowsToRead);
            if (posDeleteRowIdMapping != null) {
                this.rowIdMapping = (int[])posDeleteRowIdMapping.first();
                this.numRows = (Integer)posDeleteRowIdMapping.second();
            } else {
                this.numRows = numRowsToRead;
                this.rowIdMapping = this.initEqDeleteRowIdMapping(numRowsToRead);
            }
        }

        Pair<int[], Integer> posDelRowIdMapping(int numRowsToRead) {
            if (ColumnarBatchReader.this.deletes != null && ColumnarBatchReader.this.deletes.hasPosDeletes()) {
                return this.buildPosDelRowIdMapping(ColumnarBatchReader.this.deletes.deletedRowPositions(), numRowsToRead);
            }
            return null;
        }

        Pair<int[], Integer> buildPosDelRowIdMapping(PositionDeleteIndex deletedRowPositions, int numRowsToRead) {
            if (deletedRowPositions == null) {
                return null;
            }
            int[] posDelRowIdMapping = new int[numRowsToRead];
            int currentRowId = 0;
            for (int originalRowId = 0; originalRowId < numRowsToRead; ++originalRowId) {
                if (deletedRowPositions.isDeleted((long)originalRowId + ColumnarBatchReader.this.rowStartPosInBatch)) continue;
                posDelRowIdMapping[currentRowId] = originalRowId;
                ++currentRowId;
            }
            if (currentRowId == numRowsToRead) {
                return null;
            }
            return Pair.of((Object)posDelRowIdMapping, (Object)currentRowId);
        }

        int[] initEqDeleteRowIdMapping(int numRowsToRead) {
            int[] eqDeleteRowIdMapping = null;
            if (this.hasEqDeletes()) {
                eqDeleteRowIdMapping = new int[numRowsToRead];
                for (int i = 0; i < numRowsToRead; ++i) {
                    eqDeleteRowIdMapping[i] = i;
                }
            }
            return eqDeleteRowIdMapping;
        }

        void applyEqDelete() {
            Iterator it = this.columnarBatch.rowIterator();
            int rowId = 0;
            int currentRowId = 0;
            while (it.hasNext()) {
                InternalRow row = (InternalRow)it.next();
                if (ColumnarBatchReader.this.deletes.eqDeletedRowFilter().test(row)) {
                    this.rowIdMapping[currentRowId] = this.rowIdMapping[rowId];
                    ++currentRowId;
                }
                ++rowId;
            }
            this.columnarBatch.setNumRows(currentRowId);
        }
    }
}

