/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.vectorized;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.orc.OrcBatchReader;
import org.apache.iceberg.orc.OrcSchemaWithTypeVisitor;
import org.apache.iceberg.orc.OrcValueReader;
import org.apache.iceberg.orc.OrcValueReaders;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.SparkOrcValueReaders;
import org.apache.iceberg.spark.data.vectorized.ConstantColumnVector;
import org.apache.iceberg.spark.data.vectorized.RowPositionColumnVector;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public class VectorizedSparkOrcReaders {
    private VectorizedSparkOrcReaders() {
    }

    public static OrcBatchReader<ColumnarBatch> buildReader(final Schema expectedSchema, TypeDescription fileSchema, Map<Integer, ?> idToConstant) {
        final Converter converter = (Converter)OrcSchemaWithTypeVisitor.visit((Schema)expectedSchema, (TypeDescription)fileSchema, (OrcSchemaWithTypeVisitor)new ReadBuilder(idToConstant));
        return new OrcBatchReader<ColumnarBatch>(){
            private long batchOffsetInFile;

            public ColumnarBatch read(VectorizedRowBatch batch) {
                BaseOrcColumnVector cv = (BaseOrcColumnVector)converter.convert((org.apache.orc.storage.ql.exec.vector.ColumnVector)new StructColumnVector(batch.size, batch.cols), batch.size, this.batchOffsetInFile);
                ColumnarBatch columnarBatch = new ColumnarBatch((ColumnVector[])IntStream.range(0, expectedSchema.columns().size()).mapToObj(cv::getChild).toArray(ColumnVector[]::new));
                columnarBatch.setNumRows(batch.size);
                return columnarBatch;
            }

            public void setBatchContext(long batchOffsetInFile) {
                this.batchOffsetInFile = batchOffsetInFile;
            }
        };
    }

    private static class StructConverter
    implements Converter {
        private final Types.StructType structType;
        private final List<Converter> fieldConverters;
        private final Map<Integer, ?> idToConstant;

        private StructConverter(Types.StructType structType, List<Converter> fieldConverters, Map<Integer, ?> idToConstant) {
            this.structType = structType;
            this.fieldConverters = fieldConverters;
            this.idToConstant = idToConstant;
        }

        @Override
        public ColumnVector convert(org.apache.orc.storage.ql.exec.vector.ColumnVector vector, int batchSize, long batchOffsetInFile) {
            StructColumnVector structVector = (StructColumnVector)vector;
            List fields = this.structType.fields();
            final ArrayList fieldVectors = Lists.newArrayListWithExpectedSize((int)fields.size());
            int vectorIndex = 0;
            for (int pos = 0; pos < fields.size(); ++pos) {
                Types.NestedField field = (Types.NestedField)fields.get(pos);
                if (this.idToConstant.containsKey(field.fieldId())) {
                    fieldVectors.add(new ConstantColumnVector(field.type(), batchSize, this.idToConstant.get(field.fieldId())));
                    continue;
                }
                if (field.equals((Object)MetadataColumns.ROW_POSITION)) {
                    fieldVectors.add(new RowPositionColumnVector(batchOffsetInFile));
                    continue;
                }
                if (field.equals((Object)MetadataColumns.IS_DELETED)) {
                    fieldVectors.add(new ConstantColumnVector(field.type(), batchSize, false));
                    continue;
                }
                fieldVectors.add(this.fieldConverters.get(vectorIndex).convert(structVector.fields[vectorIndex], batchSize, batchOffsetInFile));
                ++vectorIndex;
            }
            return new BaseOrcColumnVector((Type)this.structType, batchSize, vector){

                @Override
                public ColumnVector getChild(int ordinal) {
                    return (ColumnVector)fieldVectors.get(ordinal);
                }
            };
        }
    }

    private static class MapConverter
    implements Converter {
        private final Types.MapType mapType;
        private final Converter keyConverter;
        private final Converter valueConverter;

        private MapConverter(Types.MapType mapType, Converter keyConverter, Converter valueConverter) {
            this.mapType = mapType;
            this.keyConverter = keyConverter;
            this.valueConverter = valueConverter;
        }

        @Override
        public ColumnVector convert(org.apache.orc.storage.ql.exec.vector.ColumnVector vector, int batchSize, long batchOffsetInFile) {
            final MapColumnVector mapVector = (MapColumnVector)vector;
            final ColumnVector keyVector = this.keyConverter.convert(mapVector.keys, batchSize, batchOffsetInFile);
            final ColumnVector valueVector = this.valueConverter.convert(mapVector.values, batchSize, batchOffsetInFile);
            return new BaseOrcColumnVector((Type)this.mapType, batchSize, vector){

                @Override
                public ColumnarMap getMap(int rowId) {
                    int index = this.getRowIndex(rowId);
                    return new ColumnarMap(keyVector, valueVector, (int)mapVector.offsets[index], (int)mapVector.lengths[index]);
                }
            };
        }
    }

    private static class ArrayConverter
    implements Converter {
        private final Types.ListType listType;
        private final Converter elementConverter;

        private ArrayConverter(Types.ListType listType, Converter elementConverter) {
            this.listType = listType;
            this.elementConverter = elementConverter;
        }

        @Override
        public ColumnVector convert(org.apache.orc.storage.ql.exec.vector.ColumnVector vector, int batchSize, long batchOffsetInFile) {
            final ListColumnVector listVector = (ListColumnVector)vector;
            final ColumnVector elementVector = this.elementConverter.convert(listVector.child, batchSize, batchOffsetInFile);
            return new BaseOrcColumnVector((Type)this.listType, batchSize, vector){

                @Override
                public ColumnarArray getArray(int rowId) {
                    int index = this.getRowIndex(rowId);
                    return new ColumnarArray(elementVector, (int)listVector.offsets[index], (int)listVector.lengths[index]);
                }
            };
        }
    }

    private static class PrimitiveOrcColumnVector
    extends BaseOrcColumnVector {
        private final org.apache.orc.storage.ql.exec.vector.ColumnVector vector;
        private final OrcValueReader<?> primitiveValueReader;
        private final long batchOffsetInFile;

        PrimitiveOrcColumnVector(Type type, int batchSize, org.apache.orc.storage.ql.exec.vector.ColumnVector vector, OrcValueReader<?> primitiveValueReader, long batchOffsetInFile) {
            super(type, batchSize, vector);
            this.vector = vector;
            this.primitiveValueReader = primitiveValueReader;
            this.batchOffsetInFile = batchOffsetInFile;
        }

        @Override
        public boolean getBoolean(int rowId) {
            return (Boolean)this.primitiveValueReader.read(this.vector, rowId);
        }

        @Override
        public int getInt(int rowId) {
            return (Integer)this.primitiveValueReader.read(this.vector, rowId);
        }

        @Override
        public long getLong(int rowId) {
            return (Long)this.primitiveValueReader.read(this.vector, rowId);
        }

        @Override
        public float getFloat(int rowId) {
            return ((Float)this.primitiveValueReader.read(this.vector, rowId)).floatValue();
        }

        @Override
        public double getDouble(int rowId) {
            return (Double)this.primitiveValueReader.read(this.vector, rowId);
        }

        @Override
        public Decimal getDecimal(int rowId, int precision, int scale) {
            return (Decimal)this.primitiveValueReader.read(this.vector, rowId);
        }

        @Override
        public UTF8String getUTF8String(int rowId) {
            return (UTF8String)this.primitiveValueReader.read(this.vector, rowId);
        }

        @Override
        public byte[] getBinary(int rowId) {
            return (byte[])this.primitiveValueReader.read(this.vector, rowId);
        }
    }

    private static abstract class BaseOrcColumnVector
    extends ColumnVector {
        private final org.apache.orc.storage.ql.exec.vector.ColumnVector vector;
        private final int batchSize;
        private Integer numNulls;

        BaseOrcColumnVector(Type type, int batchSize, org.apache.orc.storage.ql.exec.vector.ColumnVector vector) {
            super(SparkSchemaUtil.convert(type));
            this.vector = vector;
            this.batchSize = batchSize;
        }

        public void close() {
        }

        public boolean hasNull() {
            return !this.vector.noNulls;
        }

        public int numNulls() {
            if (this.numNulls == null) {
                this.numNulls = this.numNullsHelper();
            }
            return this.numNulls;
        }

        private int numNullsHelper() {
            if (this.vector.isRepeating) {
                if (this.vector.isNull[0]) {
                    return this.batchSize;
                }
                return 0;
            }
            if (this.vector.noNulls) {
                return 0;
            }
            int count = 0;
            for (int i = 0; i < this.batchSize; ++i) {
                if (!this.vector.isNull[i]) continue;
                ++count;
            }
            return count;
        }

        protected int getRowIndex(int rowId) {
            return this.vector.isRepeating ? 0 : rowId;
        }

        public boolean isNullAt(int rowId) {
            return this.vector.isNull[this.getRowIndex(rowId)];
        }

        public boolean getBoolean(int rowId) {
            throw new UnsupportedOperationException();
        }

        public byte getByte(int rowId) {
            throw new UnsupportedOperationException();
        }

        public short getShort(int rowId) {
            throw new UnsupportedOperationException();
        }

        public int getInt(int rowId) {
            throw new UnsupportedOperationException();
        }

        public long getLong(int rowId) {
            throw new UnsupportedOperationException();
        }

        public float getFloat(int rowId) {
            throw new UnsupportedOperationException();
        }

        public double getDouble(int rowId) {
            throw new UnsupportedOperationException();
        }

        public Decimal getDecimal(int rowId, int precision, int scale) {
            throw new UnsupportedOperationException();
        }

        public UTF8String getUTF8String(int rowId) {
            throw new UnsupportedOperationException();
        }

        public byte[] getBinary(int rowId) {
            throw new UnsupportedOperationException();
        }

        public ColumnarArray getArray(int rowId) {
            throw new UnsupportedOperationException();
        }

        public ColumnarMap getMap(int rowId) {
            throw new UnsupportedOperationException();
        }

        public ColumnVector getChild(int ordinal) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReadBuilder
    extends OrcSchemaWithTypeVisitor<Converter> {
        private final Map<Integer, ?> idToConstant;

        private ReadBuilder(Map<Integer, ?> idToConstant) {
            this.idToConstant = idToConstant;
        }

        public Converter record(Types.StructType iStruct, TypeDescription record, List<String> names, List<Converter> fields) {
            return new StructConverter(iStruct, fields, this.idToConstant);
        }

        public Converter list(Types.ListType iList, TypeDescription array, Converter element) {
            return new ArrayConverter(iList, element);
        }

        public Converter map(Types.MapType iMap, TypeDescription map, Converter key, Converter value) {
            return new MapConverter(iMap, key, value);
        }

        public Converter primitive(Type.PrimitiveType iPrimitive, TypeDescription primitive) {
            OrcValueReader<Decimal> primitiveValueReader;
            switch (primitive.getCategory()) {
                case BOOLEAN: {
                    primitiveValueReader = OrcValueReaders.booleans();
                    break;
                }
                case BYTE: 
                case SHORT: 
                case DATE: 
                case INT: {
                    primitiveValueReader = OrcValueReaders.ints();
                    break;
                }
                case LONG: {
                    primitiveValueReader = OrcValueReaders.longs();
                    break;
                }
                case FLOAT: {
                    primitiveValueReader = OrcValueReaders.floats();
                    break;
                }
                case DOUBLE: {
                    primitiveValueReader = OrcValueReaders.doubles();
                    break;
                }
                case TIMESTAMP_INSTANT: 
                case TIMESTAMP: {
                    primitiveValueReader = SparkOrcValueReaders.timestampTzs();
                    break;
                }
                case DECIMAL: {
                    primitiveValueReader = SparkOrcValueReaders.decimals(primitive.getPrecision(), primitive.getScale());
                    break;
                }
                case CHAR: 
                case VARCHAR: 
                case STRING: {
                    primitiveValueReader = SparkOrcValueReaders.utf8String();
                    break;
                }
                case BINARY: {
                    primitiveValueReader = OrcValueReaders.bytes();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled type " + primitive);
                }
            }
            return (arg_0, arg_1, arg_2) -> ReadBuilder.lambda$primitive$0(iPrimitive, (OrcValueReader)primitiveValueReader, arg_0, arg_1, arg_2);
        }

        private static /* synthetic */ ColumnVector lambda$primitive$0(Type.PrimitiveType iPrimitive, OrcValueReader primitiveValueReader, org.apache.orc.storage.ql.exec.vector.ColumnVector columnVector, int batchSize, long batchOffsetInFile) {
            return new PrimitiveOrcColumnVector((Type)iPrimitive, batchSize, columnVector, primitiveValueReader, batchOffsetInFile);
        }
    }

    private static interface Converter {
        public ColumnVector convert(org.apache.orc.storage.ql.exec.vector.ColumnVector var1, int var2, long var3);
    }
}

