/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.Procedure;
import org.apache.spark.sql.execution.CacheManager;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import scala.Option;

abstract class BaseProcedure
implements Procedure {
    protected static final DataType STRING_MAP = DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType);
    private final SparkSession spark = SparkSession.active();
    private final TableCatalog tableCatalog;
    private SparkActions actions;
    private ExecutorService executorService = null;

    protected BaseProcedure(TableCatalog tableCatalog) {
        this.tableCatalog = tableCatalog;
    }

    protected SparkSession spark() {
        return this.spark;
    }

    protected SparkActions actions() {
        if (this.actions == null) {
            this.actions = SparkActions.get(this.spark);
        }
        return this.actions;
    }

    protected TableCatalog tableCatalog() {
        return this.tableCatalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T modifyIcebergTable(Identifier ident, Function<Table, T> func) {
        try {
            T t = this.execute(ident, true, func);
            return t;
        }
        finally {
            this.closeService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T withIcebergTable(Identifier ident, Function<Table, T> func) {
        try {
            T t = this.execute(ident, false, func);
            return t;
        }
        finally {
            this.closeService();
        }
    }

    private <T> T execute(Identifier ident, boolean refreshSparkCache, Function<Table, T> func) {
        SparkTable sparkTable = this.loadSparkTable(ident);
        Table icebergTable = sparkTable.table();
        T result = func.apply(icebergTable);
        if (refreshSparkCache) {
            this.refreshSparkCache(ident, sparkTable);
        }
        return result;
    }

    protected Identifier toIdentifier(String identifierAsString, String argName) {
        Spark3Util.CatalogAndIdentifier catalogAndIdentifier = this.toCatalogAndIdentifier(identifierAsString, argName, (CatalogPlugin)this.tableCatalog);
        Preconditions.checkArgument((boolean)catalogAndIdentifier.catalog().equals(this.tableCatalog), (String)"Cannot run procedure in catalog '%s': '%s' is a table in catalog '%s'", (Object)this.tableCatalog.name(), (Object)identifierAsString, (Object)catalogAndIdentifier.catalog().name());
        return catalogAndIdentifier.identifier();
    }

    protected Spark3Util.CatalogAndIdentifier toCatalogAndIdentifier(String identifierAsString, String argName, CatalogPlugin catalog) {
        Preconditions.checkArgument((identifierAsString != null && !identifierAsString.isEmpty() ? 1 : 0) != 0, (String)"Cannot handle an empty identifier for argument %s", (Object)argName);
        return Spark3Util.catalogAndIdentifier("identifier for arg " + argName, this.spark, identifierAsString, catalog);
    }

    protected SparkTable loadSparkTable(Identifier ident) {
        try {
            org.apache.spark.sql.connector.catalog.Table table = this.tableCatalog.loadTable(ident);
            ValidationException.check((boolean)(table instanceof SparkTable), (String)"%s is not %s", (Object[])new Object[]{ident, SparkTable.class.getName()});
            return (SparkTable)table;
        }
        catch (NoSuchTableException e) {
            String errMsg = String.format("Couldn't load table '%s' in catalog '%s'", ident, this.tableCatalog.name());
            throw new RuntimeException(errMsg, e);
        }
    }

    protected void refreshSparkCache(Identifier ident, org.apache.spark.sql.connector.catalog.Table table) {
        CacheManager cacheManager = this.spark.sharedState().cacheManager();
        DataSourceV2Relation relation = DataSourceV2Relation.create((org.apache.spark.sql.connector.catalog.Table)table, (Option)Option.apply((Object)this.tableCatalog), (Option)Option.apply((Object)ident));
        cacheManager.recacheByPlan(this.spark, (LogicalPlan)relation);
    }

    protected InternalRow newInternalRow(Object ... values) {
        return new GenericInternalRow(values);
    }

    protected void closeService() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    protected ExecutorService executorService(int threadPoolSize, String nameFormat) {
        Preconditions.checkArgument((this.executorService == null ? 1 : 0) != 0, (Object)"Cannot create a new executor service, one already exists.");
        Preconditions.checkArgument((nameFormat != null ? 1 : 0) != 0, (Object)"Cannot create a service with null nameFormat arg");
        this.executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(threadPoolSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(nameFormat + "-%d").build())));
        return this.executorService;
    }

    protected static abstract class Builder<T extends BaseProcedure>
    implements SparkProcedures.ProcedureBuilder {
        private TableCatalog tableCatalog;

        protected Builder() {
        }

        @Override
        public Builder<T> withTableCatalog(TableCatalog newTableCatalog) {
            this.tableCatalog = newTableCatalog;
            return this;
        }

        public T build() {
            return this.doBuild();
        }

        protected abstract T doBuild();

        TableCatalog tableCatalog() {
            return this.tableCatalog;
        }
    }
}

