/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.actions.MigrateTable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.runtime.BoxedUnit;

class MigrateTableProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("properties", STRING_MAP)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("migrated_files_count", DataTypes.LongType, false, Metadata.empty())});

    private MigrateTableProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<MigrateTableProcedure>(){

            @Override
            protected MigrateTableProcedure doBuild() {
                return new MigrateTableProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        String tableName = args.getString(0);
        Preconditions.checkArgument((tableName != null && !tableName.isEmpty() ? 1 : 0) != 0, (Object)"Cannot handle an empty identifier for argument table");
        HashMap properties = Maps.newHashMap();
        if (!args.isNullAt(1)) {
            args.getMap(1).foreach(DataTypes.StringType, DataTypes.StringType, (k, v) -> {
                properties.put(k.toString(), v.toString());
                return BoxedUnit.UNIT;
            });
        }
        MigrateTable.Result result = SparkActions.get().migrateTable(tableName).tableProperties((Map)properties).execute();
        return new InternalRow[]{this.newInternalRow(result.migratedDataFilesCount())};
    }

    @Override
    public String description() {
        return "MigrateTableProcedure";
    }
}

