/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import java.util.Set;
import org.apache.arrow.vector.NullCheckingForGet;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.DeleteFilter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.vectorized.VectorizedSparkOrcReaders;
import org.apache.iceberg.spark.data.vectorized.VectorizedSparkParquetReaders;
import org.apache.iceberg.spark.source.BaseDataReader;
import org.apache.iceberg.spark.source.InternalRowWrapper;
import org.apache.iceberg.types.TypeUtil;
import org.apache.spark.rdd.InputFileBlockHolder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.vectorized.ColumnarBatch;

class BatchDataReader
extends BaseDataReader<ColumnarBatch> {
    private final Schema expectedSchema;
    private final String nameMapping;
    private final boolean caseSensitive;
    private final int batchSize;

    BatchDataReader(CombinedScanTask task, Table table, Schema expectedSchema, boolean caseSensitive, int size) {
        super(table, task);
        this.expectedSchema = expectedSchema;
        this.nameMapping = (String)table.properties().get("schema.name-mapping.default");
        this.caseSensitive = caseSensitive;
        this.batchSize = size;
    }

    @Override
    CloseableIterator<ColumnarBatch> open(FileScanTask task) {
        CloseableIterable iter;
        DataFile file = (DataFile)task.file();
        InputFileBlockHolder.set((String)file.path().toString(), (long)task.start(), (long)task.length());
        Map<Integer, ?> idToConstant = this.constantsMap(task, this.expectedSchema);
        InputFile location = this.getInputFile(task);
        Preconditions.checkNotNull((Object)location, (Object)"Could not find InputFile associated with FileScanTask");
        if (((DataFile)task.file()).format() == FileFormat.PARQUET) {
            SparkDeleteFilter deleteFilter = this.deleteFilter(task);
            Schema requiredSchema = this.requiredSchema(deleteFilter);
            Parquet.ReadBuilder builder = Parquet.read((InputFile)location).project(requiredSchema).split(task.start(), task.length()).createBatchedReaderFunc(fileSchema -> VectorizedSparkParquetReaders.buildReader(requiredSchema, fileSchema, NullCheckingForGet.NULL_CHECKING_ENABLED, idToConstant, deleteFilter)).recordsPerBatch(this.batchSize).filter(task.residual()).caseSensitive(this.caseSensitive).reuseContainers();
            if (this.nameMapping != null) {
                builder.withNameMapping(NameMappingParser.fromJson((String)this.nameMapping));
            }
            iter = builder.build();
        } else if (((DataFile)task.file()).format() == FileFormat.ORC) {
            Set<Integer> constantFieldIds = idToConstant.keySet();
            Set metadataFieldIds = MetadataColumns.metadataFieldIds();
            Sets.SetView constantAndMetadataFieldIds = Sets.union(constantFieldIds, (Set)metadataFieldIds);
            Schema schemaWithoutConstantAndMetadataFields = TypeUtil.selectNot((Schema)this.expectedSchema, (Set)constantAndMetadataFieldIds);
            ORC.ReadBuilder builder = ORC.read((InputFile)location).project(schemaWithoutConstantAndMetadataFields).split(task.start(), task.length()).createBatchedReaderFunc(fileSchema -> VectorizedSparkOrcReaders.buildReader(this.expectedSchema, fileSchema, idToConstant)).recordsPerBatch(this.batchSize).filter(task.residual()).caseSensitive(this.caseSensitive);
            if (this.nameMapping != null) {
                builder.withNameMapping(NameMappingParser.fromJson((String)this.nameMapping));
            }
            iter = builder.build();
        } else {
            throw new UnsupportedOperationException("Format: " + ((DataFile)task.file()).format() + " not supported for batched reads");
        }
        return iter.iterator();
    }

    private SparkDeleteFilter deleteFilter(FileScanTask task) {
        return task.deletes().isEmpty() ? null : new SparkDeleteFilter(task, this.table().schema(), this.expectedSchema);
    }

    private Schema requiredSchema(DeleteFilter deleteFilter) {
        if (deleteFilter != null && deleteFilter.hasEqDeletes()) {
            return deleteFilter.requiredSchema();
        }
        return this.expectedSchema;
    }

    private class SparkDeleteFilter
    extends DeleteFilter<InternalRow> {
        private final InternalRowWrapper asStructLike;

        SparkDeleteFilter(FileScanTask task, Schema tableSchema, Schema requestedSchema) {
            super(((DataFile)task.file()).path().toString(), task.deletes(), tableSchema, requestedSchema);
            this.asStructLike = new InternalRowWrapper(SparkSchemaUtil.convert(this.requiredSchema()));
        }

        protected StructLike asStructLike(InternalRow row) {
            return this.asStructLike.wrap(row);
        }

        protected InputFile getInputFile(String location) {
            return BatchDataReader.this.getInputFile(location);
        }
    }
}

