/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.spark.source.RowDataReader;
import org.apache.spark.rdd.InputFileBlockHolder;
import org.apache.spark.sql.catalyst.InternalRow;

public class EqualityDeleteRowReader
extends RowDataReader {
    private final Schema expectedSchema;

    public EqualityDeleteRowReader(CombinedScanTask task, Table table, Schema expectedSchema, boolean caseSensitive) {
        super(task, table, table.schema(), caseSensitive);
        this.expectedSchema = expectedSchema;
    }

    @Override
    CloseableIterator<InternalRow> open(FileScanTask task) {
        RowDataReader.SparkDeleteFilter matches = new RowDataReader.SparkDeleteFilter(this, task, this.tableSchema(), this.expectedSchema);
        Schema requiredSchema = matches.requiredSchema();
        Map<Integer, ?> idToConstant = this.constantsMap(task, this.expectedSchema);
        DataFile file = (DataFile)task.file();
        InputFileBlockHolder.set((String)file.path().toString(), (long)task.start(), (long)task.length());
        return matches.findEqualityDeleteRows(this.open(task, requiredSchema, idToConstant)).iterator();
    }
}

