/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.spark.source.SparkScan;
import org.apache.iceberg.util.TableScanUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;

abstract class SparkBatch
implements Batch {
    private final JavaSparkContext sparkContext;
    private final Table table;
    private final SparkReadConf readConf;
    private final Schema expectedSchema;
    private final boolean caseSensitive;
    private final boolean localityEnabled;

    SparkBatch(SparkSession spark, Table table, SparkReadConf readConf, Schema expectedSchema) {
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        this.table = table;
        this.readConf = readConf;
        this.expectedSchema = expectedSchema;
        this.caseSensitive = readConf.caseSensitive();
        this.localityEnabled = readConf.localityEnabled();
    }

    public InputPartition[] planInputPartitions() {
        Broadcast tableBroadcast = this.sparkContext.broadcast((Object)SerializableTableWithSize.copyOf(this.table));
        String expectedSchemaString = SchemaParser.toJson((Schema)this.expectedSchema);
        InputPartition[] readTasks = new InputPartition[this.tasks().size()];
        Tasks.range((int)readTasks.length).stopOnFailure().executeWith(this.localityEnabled ? ThreadPools.getWorkerPool() : null).run(index -> {
            readTasks[index.intValue()] = new SparkScan.ReadTask(this.tasks().get((int)index), (Broadcast<Table>)tableBroadcast, expectedSchemaString, this.caseSensitive, this.localityEnabled);
        });
        return readTasks;
    }

    protected abstract List<CombinedScanTask> tasks();

    protected JavaSparkContext sparkContext() {
        return this.sparkContext;
    }

    public PartitionReaderFactory createReaderFactory() {
        return new SparkScan.ReaderFactory(this.batchSize());
    }

    private int batchSize() {
        if (this.parquetOnly() && this.parquetBatchReadsEnabled()) {
            return this.readConf.parquetBatchSize();
        }
        if (this.orcOnly() && this.orcBatchReadsEnabled()) {
            return this.readConf.orcBatchSize();
        }
        return 0;
    }

    private boolean parquetOnly() {
        return this.tasks().stream().allMatch(task -> !task.isDataTask() && this.onlyFileFormat((CombinedScanTask)task, FileFormat.PARQUET));
    }

    private boolean parquetBatchReadsEnabled() {
        return this.readConf.parquetVectorizationEnabled() && this.expectedSchema.columns().size() > 0 && this.expectedSchema.columns().stream().allMatch(c -> c.type().isPrimitiveType());
    }

    private boolean orcOnly() {
        return this.tasks().stream().allMatch(task -> !task.isDataTask() && this.onlyFileFormat((CombinedScanTask)task, FileFormat.ORC));
    }

    private boolean orcBatchReadsEnabled() {
        return this.readConf.orcVectorizationEnabled() && this.tasks().stream().noneMatch(TableScanUtil::hasDeletes);
    }

    private boolean onlyFileFormat(CombinedScanTask task, FileFormat fileFormat) {
        return task.files().stream().allMatch(fileScanTask -> ((DataFile)fileScanTask.file()).format().equals((Object)fileFormat));
    }
}

