/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import java.util.Objects;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.FileScanTaskSetManager;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.source.SparkScan;
import org.apache.iceberg.util.TableScanUtil;
import org.apache.spark.sql.SparkSession;

class SparkFilesScan
extends SparkScan {
    private final String taskSetID;
    private final long splitSize;
    private final int splitLookback;
    private final long splitOpenFileCost;
    private List<CombinedScanTask> tasks = null;

    SparkFilesScan(SparkSession spark, Table table, SparkReadConf readConf) {
        super(spark, table, readConf, table.schema(), (List<Expression>)ImmutableList.of());
        this.taskSetID = readConf.fileScanTaskSetId();
        this.splitSize = readConf.splitSize();
        this.splitLookback = readConf.splitLookback();
        this.splitOpenFileCost = readConf.splitOpenFileCost();
    }

    @Override
    protected List<CombinedScanTask> tasks() {
        if (this.tasks == null) {
            FileScanTaskSetManager taskSetManager = FileScanTaskSetManager.get();
            List<FileScanTask> files = taskSetManager.fetchTasks(this.table(), this.taskSetID);
            ValidationException.check((files != null ? 1 : 0) != 0, (String)"Task set manager has no tasks for table %s with id %s", (Object[])new Object[]{this.table(), this.taskSetID});
            CloseableIterable splitFiles = TableScanUtil.splitFiles((CloseableIterable)CloseableIterable.withNoopClose(files), (long)this.splitSize);
            CloseableIterable scanTasks = TableScanUtil.planTasks((CloseableIterable)splitFiles, (long)this.splitSize, (int)this.splitLookback, (long)this.splitOpenFileCost);
            this.tasks = Lists.newArrayList((Iterable)scanTasks);
        }
        return this.tasks;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SparkFilesScan that = (SparkFilesScan)other;
        return this.table().name().equals(that.table().name()) && Objects.equals(this.taskSetID, that.taskSetID) && Objects.equals(this.splitSize, that.splitSize) && Objects.equals(this.splitLookback, that.splitLookback) && Objects.equals(this.splitOpenFileCost, that.splitOpenFileCost);
    }

    public int hashCode() {
        return Objects.hash(this.table().name(), this.taskSetID, this.splitSize, this.splitSize, this.splitOpenFileCost);
    }

    public String toString() {
        return String.format("IcebergFilesScan(table=%s, type=%s, taskSetID=%s, caseSensitive=%s)", this.table(), this.expectedSchema().asStruct(), this.taskSetID, this.caseSensitive());
    }
}

