/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.source.SparkCopyOnWriteOperation;
import org.apache.iceberg.spark.source.SparkPositionDeltaOperation;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.apache.spark.sql.connector.write.RowLevelOperationBuilder;
import org.apache.spark.sql.connector.write.RowLevelOperationInfo;

class SparkRowLevelOperationBuilder
implements RowLevelOperationBuilder {
    private final SparkSession spark;
    private final Table table;
    private final RowLevelOperationInfo info;
    private final RowLevelOperationMode mode;
    private final IsolationLevel isolationLevel;

    SparkRowLevelOperationBuilder(SparkSession spark, Table table, RowLevelOperationInfo info) {
        this.spark = spark;
        this.table = table;
        this.info = info;
        this.mode = this.mode(table.properties(), info.command());
        this.isolationLevel = this.isolationLevel(table.properties(), info.command());
    }

    public RowLevelOperation build() {
        switch (this.mode) {
            case COPY_ON_WRITE: {
                return new SparkCopyOnWriteOperation(this.spark, this.table, this.info, this.isolationLevel);
            }
            case MERGE_ON_READ: {
                return new SparkPositionDeltaOperation(this.spark, this.table, this.info, this.isolationLevel);
            }
        }
        throw new IllegalArgumentException("Unsupported operation mode: " + this.mode);
    }

    private RowLevelOperationMode mode(Map<String, String> properties, RowLevelOperation.Command command) {
        String modeName;
        switch (command) {
            case DELETE: {
                modeName = properties.getOrDefault("write.delete.mode", "copy-on-write");
                break;
            }
            case UPDATE: {
                modeName = properties.getOrDefault("write.update.mode", "copy-on-write");
                break;
            }
            case MERGE: {
                modeName = properties.getOrDefault("write.merge.mode", "copy-on-write");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported command: " + command);
            }
        }
        return RowLevelOperationMode.fromName((String)modeName);
    }

    private IsolationLevel isolationLevel(Map<String, String> properties, RowLevelOperation.Command command) {
        String levelName;
        switch (command) {
            case DELETE: {
                levelName = properties.getOrDefault("write.delete.isolation-level", "serializable");
                break;
            }
            case UPDATE: {
                levelName = properties.getOrDefault("write.update.isolation-level", "serializable");
                break;
            }
            case MERGE: {
                levelName = properties.getOrDefault("write.merge.isolation-level", "serializable");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported command: " + command);
            }
        }
        return IsolationLevel.fromName((String)levelName);
    }
}

