/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.source.BatchDataReader;
import org.apache.iceberg.spark.source.RowDataReader;
import org.apache.iceberg.spark.source.SparkBatch;
import org.apache.iceberg.spark.source.SparkMicroBatchStream;
import org.apache.iceberg.spark.source.Stats;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsReportStatistics;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SparkScan
extends SparkBatch
implements Scan,
SupportsReportStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(SparkScan.class);
    private final Table table;
    private final SparkReadConf readConf;
    private final boolean caseSensitive;
    private final Schema expectedSchema;
    private final List<Expression> filterExpressions;
    private final boolean readTimestampWithoutZone;
    private StructType readSchema;

    SparkScan(SparkSession spark, Table table, SparkReadConf readConf, Schema expectedSchema, List<Expression> filters) {
        super(spark, table, readConf, expectedSchema);
        SparkSchemaUtil.validateMetadataColumnReferences(table.schema(), expectedSchema);
        this.table = table;
        this.readConf = readConf;
        this.caseSensitive = readConf.caseSensitive();
        this.expectedSchema = expectedSchema;
        this.filterExpressions = filters != null ? filters : Collections.emptyList();
        this.readTimestampWithoutZone = readConf.handleTimestampWithoutZone();
    }

    protected Table table() {
        return this.table;
    }

    protected boolean caseSensitive() {
        return this.caseSensitive;
    }

    protected Schema expectedSchema() {
        return this.expectedSchema;
    }

    protected List<Expression> filterExpressions() {
        return this.filterExpressions;
    }

    public Batch toBatch() {
        return this;
    }

    public MicroBatchStream toMicroBatchStream(String checkpointLocation) {
        return new SparkMicroBatchStream(this.sparkContext(), this.table, this.readConf, this.expectedSchema, checkpointLocation);
    }

    public StructType readSchema() {
        if (this.readSchema == null) {
            Preconditions.checkArgument((this.readTimestampWithoutZone || !SparkUtil.hasTimestampWithoutZone(this.expectedSchema) ? 1 : 0) != 0, (Object)SparkUtil.TIMESTAMP_WITHOUT_TIMEZONE_ERROR);
            this.readSchema = SparkSchemaUtil.convert(this.expectedSchema);
        }
        return this.readSchema;
    }

    public Statistics estimateStatistics() {
        return this.estimateStatistics(this.table.currentSnapshot());
    }

    protected Statistics estimateStatistics(Snapshot snapshot) {
        if (snapshot == null) {
            return new Stats(0L, 0L);
        }
        if (!this.table.spec().isUnpartitioned() && this.filterExpressions.isEmpty()) {
            LOG.debug("using table metadata to estimate table statistics");
            long totalRecords = PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"total-records", (long)Long.MAX_VALUE);
            return new Stats(SparkSchemaUtil.estimateSize(this.readSchema(), totalRecords), totalRecords);
        }
        long numRows = 0L;
        for (CombinedScanTask task : this.tasks()) {
            for (FileScanTask file : task.files()) {
                double fractionOfFileScanned = (double)file.length() / (double)((DataFile)file.file()).fileSizeInBytes();
                numRows = (long)((double)numRows + fractionOfFileScanned * (double)((DataFile)file.file()).recordCount());
            }
        }
        long sizeInBytes = SparkSchemaUtil.estimateSize(this.readSchema(), numRows);
        return new Stats(sizeInBytes, numRows);
    }

    public String description() {
        String filters = this.filterExpressions.stream().map(Spark3Util::describe).collect(Collectors.joining(", "));
        return String.format("%s [filters=%s]", this.table, filters);
    }

    static class ReadTask
    implements InputPartition,
    Serializable {
        private final CombinedScanTask task;
        private final Broadcast<Table> tableBroadcast;
        private final String expectedSchemaString;
        private final boolean caseSensitive;
        private transient Schema expectedSchema = null;
        private transient String[] preferredLocations = null;

        ReadTask(CombinedScanTask task, Broadcast<Table> tableBroadcast, String expectedSchemaString, boolean caseSensitive, boolean localityPreferred) {
            this.task = task;
            this.tableBroadcast = tableBroadcast;
            this.expectedSchemaString = expectedSchemaString;
            this.caseSensitive = caseSensitive;
            if (localityPreferred) {
                Table table = (Table)tableBroadcast.value();
                this.preferredLocations = Util.blockLocations((FileIO)table.io(), (CombinedScanTask)task);
            } else {
                this.preferredLocations = HadoopInputFile.NO_LOCATION_PREFERENCE;
            }
        }

        public String[] preferredLocations() {
            return this.preferredLocations;
        }

        public Collection<FileScanTask> files() {
            return this.task.files();
        }

        public Table table() {
            return (Table)this.tableBroadcast.value();
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        private Schema expectedSchema() {
            if (this.expectedSchema == null) {
                this.expectedSchema = SchemaParser.fromJson((String)this.expectedSchemaString);
            }
            return this.expectedSchema;
        }
    }

    private static class BatchReader
    extends BatchDataReader
    implements PartitionReader<ColumnarBatch> {
        BatchReader(ReadTask task, int batchSize) {
            super(task.task, task.table(), task.expectedSchema(), task.isCaseSensitive(), batchSize);
        }
    }

    private static class RowReader
    extends RowDataReader
    implements PartitionReader<InternalRow> {
        RowReader(ReadTask task) {
            super(task.task, task.table(), task.expectedSchema(), task.isCaseSensitive());
        }
    }

    static class ReaderFactory
    implements PartitionReaderFactory {
        private final int batchSize;

        ReaderFactory(int batchSize) {
            this.batchSize = batchSize;
        }

        public PartitionReader<InternalRow> createReader(InputPartition partition) {
            if (partition instanceof ReadTask) {
                return new RowReader((ReadTask)partition);
            }
            throw new UnsupportedOperationException("Incorrect input partition type: " + partition);
        }

        public PartitionReader<ColumnarBatch> createColumnarReader(InputPartition partition) {
            if (partition instanceof ReadTask) {
                return new BatchReader((ReadTask)partition, this.batchSize);
            }
            throw new UnsupportedOperationException("Incorrect input partition type: " + partition);
        }

        public boolean supportColumnarReads(InputPartition partition) {
            return this.batchSize > 1;
        }
    }
}

