/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.utils;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.IcebergBucketTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergDayTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergHourTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergMonthTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergTruncateTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergYearTransform;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NullOrdering;
import org.apache.spark.sql.catalyst.expressions.NullsFirst$;
import org.apache.spark.sql.catalyst.expressions.NullsLast$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.utils.DistributionAndOrderingUtils$BucketTransform$;
import org.apache.spark.sql.catalyst.utils.DistributionAndOrderingUtils$TruncateTransform$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.distributions.ClusteredDistribution;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.connector.distributions.UnspecifiedDistribution;
import org.apache.spark.sql.connector.expressions.DaysTransform;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.HoursTransform;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.MonthsTransform;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.expressions.YearsTransform;
import org.apache.spark.sql.internal.SQLConf;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;

public final class DistributionAndOrderingUtils$ {
    public static final DistributionAndOrderingUtils$ MODULE$ = new DistributionAndOrderingUtils$();

    public LogicalPlan prepareQuery(Distribution requiredDistribution, org.apache.spark.sql.connector.expressions.SortOrder[] requiredOrdering, LogicalPlan query, SQLConf conf) {
        org.apache.spark.sql.catalyst.expressions.Expression[] expressionArray;
        Function2 resolver = conf.resolver();
        Distribution distribution = requiredDistribution;
        if (distribution instanceof OrderedDistribution) {
            OrderedDistribution orderedDistribution = (OrderedDistribution)distribution;
            expressionArray = (org.apache.spark.sql.catalyst.expressions.Expression[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])orderedDistribution.ordering()), (Function1 & Serializable)e -> MODULE$.toCatalyst((Expression)e, query, (Function2<String, String, Object>)resolver), ClassTag$.MODULE$.apply(org.apache.spark.sql.catalyst.expressions.Expression.class));
        } else if (distribution instanceof ClusteredDistribution) {
            ClusteredDistribution clusteredDistribution = (ClusteredDistribution)distribution;
            expressionArray = (org.apache.spark.sql.catalyst.expressions.Expression[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])clusteredDistribution.clustering()), (Function1 & Serializable)e -> MODULE$.toCatalyst((Expression)e, query, (Function2<String, String, Object>)resolver), ClassTag$.MODULE$.apply(org.apache.spark.sql.catalyst.expressions.Expression.class));
        } else if (distribution instanceof UnspecifiedDistribution) {
            expressionArray = (org.apache.spark.sql.catalyst.expressions.Expression[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(org.apache.spark.sql.catalyst.expressions.Expression.class));
        } else {
            throw new MatchError((Object)distribution);
        }
        org.apache.spark.sql.catalyst.expressions.Expression[] distribution2 = expressionArray;
        LogicalPlan queryWithDistribution = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])distribution2)) ? new RepartitionByExpression(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])distribution2)), query, (Option)None$.MODULE$) : query;
        SortOrder[] ordering = (SortOrder[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])requiredOrdering), (Function1 & Serializable)e -> (SortOrder)MODULE$.toCatalyst((Expression)e, query, (Function2<String, String, Object>)resolver), ClassTag$.MODULE$.apply(SortOrder.class));
        LogicalPlan queryWithDistributionAndOrdering = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])ordering)) ? new Sort((Seq)scala.collection.compat.immutable.package$.MODULE$.ArraySeq().unsafeWrapArray((Object)ordering), false, queryWithDistribution) : queryWithDistribution;
        return queryWithDistributionAndOrdering;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private org.apache.spark.sql.catalyst.expressions.Expression toCatalyst(Expression expr, LogicalPlan query, Function2<String, String, Object> resolver) {
        Option<Tuple2<FieldReference, Object>> option;
        void var4_18;
        boolean bl = false;
        Transform transform = null;
        Expression expression = expr;
        if (expression instanceof org.apache.spark.sql.connector.expressions.SortOrder) {
            org.apache.spark.sql.connector.expressions.SortOrder sortOrder = (org.apache.spark.sql.connector.expressions.SortOrder)expression;
            org.apache.spark.sql.catalyst.expressions.Expression catalystChild = this.toCatalyst(sortOrder.expression(), query, resolver);
            SortOrder sortOrder2 = new SortOrder(catalystChild, this.toCatalyst(sortOrder.direction()), this.toCatalyst(sortOrder.nullOrdering()), (Seq)package$.MODULE$.Seq().empty());
            return var4_18;
        }
        if (expression instanceof IdentityTransform) {
            IdentityTransform identityTransform = (IdentityTransform)expression;
            org.apache.spark.sql.catalyst.expressions.Expression expression2 = (org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)scala.collection.compat.immutable.package$.MODULE$.ArraySeq().unsafeWrapArray((Object)identityTransform.ref().fieldNames()), query, resolver);
            return var4_18;
        }
        if (expression instanceof Transform) {
            bl = true;
            transform = (Transform)expression;
            Option<Tuple2<Object, FieldReference>> option2 = DistributionAndOrderingUtils$BucketTransform$.MODULE$.unapply(transform);
            if (!option2.isEmpty()) {
                int numBuckets = ((Tuple2)option2.get())._1$mcI$sp();
                FieldReference ref = (FieldReference)((Tuple2)option2.get())._2();
                IcebergBucketTransform icebergBucketTransform = new IcebergBucketTransform(numBuckets, (org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)scala.collection.compat.immutable.package$.MODULE$.ArraySeq().unsafeWrapArray((Object)ref.fieldNames()), query, resolver));
                return var4_18;
            }
        }
        if (bl && !(option = DistributionAndOrderingUtils$TruncateTransform$.MODULE$.unapply(transform)).isEmpty()) {
            FieldReference ref = (FieldReference)((Tuple2)option.get())._1();
            int width = ((Tuple2)option.get())._2$mcI$sp();
            IcebergTruncateTransform icebergTruncateTransform = new IcebergTruncateTransform((org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)scala.collection.compat.immutable.package$.MODULE$.ArraySeq().unsafeWrapArray((Object)ref.fieldNames()), query, resolver), width);
            return var4_18;
        }
        if (expression instanceof YearsTransform) {
            YearsTransform yearsTransform = (YearsTransform)expression;
            IcebergYearTransform icebergYearTransform = new IcebergYearTransform((org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)scala.collection.compat.immutable.package$.MODULE$.ArraySeq().unsafeWrapArray((Object)yearsTransform.ref().fieldNames()), query, resolver));
            return var4_18;
        }
        if (expression instanceof MonthsTransform) {
            MonthsTransform monthsTransform = (MonthsTransform)expression;
            IcebergMonthTransform icebergMonthTransform = new IcebergMonthTransform((org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)scala.collection.compat.immutable.package$.MODULE$.ArraySeq().unsafeWrapArray((Object)monthsTransform.ref().fieldNames()), query, resolver));
            return var4_18;
        }
        if (expression instanceof DaysTransform) {
            DaysTransform daysTransform = (DaysTransform)expression;
            IcebergDayTransform icebergDayTransform = new IcebergDayTransform((org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)scala.collection.compat.immutable.package$.MODULE$.ArraySeq().unsafeWrapArray((Object)daysTransform.ref().fieldNames()), query, resolver));
            return var4_18;
        }
        if (expression instanceof HoursTransform) {
            HoursTransform hoursTransform = (HoursTransform)expression;
            IcebergHourTransform icebergHourTransform = new IcebergHourTransform((org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)scala.collection.compat.immutable.package$.MODULE$.ArraySeq().unsafeWrapArray((Object)hoursTransform.ref().fieldNames()), query, resolver));
            return var4_18;
        }
        if (!(expression instanceof FieldReference)) throw new RuntimeException(new StringBuilder(27).append(expr).append(" is not currently supported").toString());
        FieldReference fieldReference = (FieldReference)expression;
        org.apache.spark.sql.catalyst.expressions.Expression expression3 = (org.apache.spark.sql.catalyst.expressions.Expression)DistributionAndOrderingUtils$.resolve$1((Seq)scala.collection.compat.immutable.package$.MODULE$.ArraySeq().unsafeWrapArray((Object)fieldReference.fieldNames()), query, resolver);
        return var4_18;
    }

    private org.apache.spark.sql.catalyst.expressions.SortDirection toCatalyst(SortDirection direction) {
        Ascending$ ascending$;
        SortDirection sortDirection = direction;
        if (SortDirection.ASCENDING.equals(sortDirection)) {
            ascending$ = Ascending$.MODULE$;
        } else if (SortDirection.DESCENDING.equals(sortDirection)) {
            ascending$ = Descending$.MODULE$;
        } else {
            throw new MatchError((Object)sortDirection);
        }
        return ascending$;
    }

    private NullOrdering toCatalyst(org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering) {
        NullsFirst$ nullsFirst$;
        org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering2 = nullOrdering;
        if (org.apache.spark.sql.connector.expressions.NullOrdering.NULLS_FIRST.equals(nullOrdering2)) {
            nullsFirst$ = NullsFirst$.MODULE$;
        } else if (org.apache.spark.sql.connector.expressions.NullOrdering.NULLS_LAST.equals(nullOrdering2)) {
            nullsFirst$ = NullsLast$.MODULE$;
        } else {
            throw new MatchError((Object)nullOrdering2);
        }
        return nullsFirst$;
    }

    private static final NamedExpression resolve$1(Seq parts, LogicalPlan query$2, Function2 resolver$2) {
        NamedExpression attr;
        Option option = query$2.resolve(parts, resolver$2);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                String ref = CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(parts).quoted();
                throw new AnalysisException(new StringBuilder(24).append("Cannot resolve '").append(ref).append("' using ").append(query$2.output()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        NamedExpression namedExpression = attr = (NamedExpression)some.value();
        return namedExpression;
    }

    private DistributionAndOrderingUtils$() {
    }
}

