/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkTestBase;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestSpark3Util
extends SparkTestBase {
    @Test
    public void testDescribeSortOrder() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"time", (Type)Types.TimestampType.withoutZone())});
        Assert.assertEquals((String)"Sort order isn't correct.", (Object)"data DESC NULLS FIRST", (Object)Spark3Util.describe((SortOrder)this.buildSortOrder("Identity", schema, 1)));
        Assert.assertEquals((String)"Sort order isn't correct.", (Object)"bucket(1, data) DESC NULLS FIRST", (Object)Spark3Util.describe((SortOrder)this.buildSortOrder("bucket[1]", schema, 1)));
        Assert.assertEquals((String)"Sort order isn't correct.", (Object)"truncate(data, 3) DESC NULLS FIRST", (Object)Spark3Util.describe((SortOrder)this.buildSortOrder("truncate[3]", schema, 1)));
        Assert.assertEquals((String)"Sort order isn't correct.", (Object)"years(time) DESC NULLS FIRST", (Object)Spark3Util.describe((SortOrder)this.buildSortOrder("year", schema, 2)));
        Assert.assertEquals((String)"Sort order isn't correct.", (Object)"months(time) DESC NULLS FIRST", (Object)Spark3Util.describe((SortOrder)this.buildSortOrder("month", schema, 2)));
        Assert.assertEquals((String)"Sort order isn't correct.", (Object)"days(time) DESC NULLS FIRST", (Object)Spark3Util.describe((SortOrder)this.buildSortOrder("day", schema, 2)));
        Assert.assertEquals((String)"Sort order isn't correct.", (Object)"hours(time) DESC NULLS FIRST", (Object)Spark3Util.describe((SortOrder)this.buildSortOrder("hour", schema, 2)));
        Assert.assertEquals((String)"Sort order isn't correct.", (Object)"unknown(data) DESC NULLS FIRST", (Object)Spark3Util.describe((SortOrder)this.buildSortOrder("unknown", schema, 1)));
        SortOrder multiOrder = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("time", NullOrder.NULLS_FIRST)).asc("data", NullOrder.NULLS_LAST)).build();
        Assert.assertEquals((String)"Sort order isn't correct.", (Object)"time ASC NULLS FIRST, data ASC NULLS LAST", (Object)Spark3Util.describe((SortOrder)multiOrder));
    }

    @Test
    public void testDescribeSchema() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"data", (Type)Types.ListType.ofRequired((int)2, (Type)Types.StringType.get())), Types.NestedField.optional((int)3, (String)"pairs", (Type)Types.MapType.ofOptional((int)4, (int)5, (Type)Types.StringType.get(), (Type)Types.LongType.get())), Types.NestedField.required((int)6, (String)"time", (Type)Types.TimestampType.withoutZone())});
        Assert.assertEquals((String)"Schema description isn't correct.", (Object)"struct<data: list<string> not null,pairs: map<string, bigint>,time: timestamp not null>", (Object)Spark3Util.describe((Schema)schema));
    }

    @Test
    public void testLoadIcebergTable() throws Exception {
        spark.conf().set("spark.sql.catalog.hive", SparkCatalog.class.getName());
        spark.conf().set("spark.sql.catalog.hive.type", "hive");
        spark.conf().set("spark.sql.catalog.hive.default-namespace", "default");
        String tableFullName = "hive.default.tbl";
        this.sql("CREATE TABLE %s (c1 bigint, c2 string, c3 string) USING iceberg", tableFullName);
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)tableFullName);
        Assert.assertTrue((boolean)table.name().equals(tableFullName));
    }

    @Test
    public void testLoadIcebergCatalog() throws Exception {
        spark.conf().set("spark.sql.catalog.test_cat", SparkCatalog.class.getName());
        spark.conf().set("spark.sql.catalog.test_cat.type", "hive");
        Catalog catalog = Spark3Util.loadIcebergCatalog((SparkSession)spark, (String)"test_cat");
        Assert.assertTrue((String)"Should retrieve underlying catalog class", (boolean)(catalog instanceof CachingCatalog));
    }

    @Test
    public void testDescribeExpression() {
        UnboundPredicate refExpression = Expressions.equal((String)"id", (Object)1);
        Assertions.assertThat((String)Spark3Util.describe((Expression)refExpression)).isEqualTo("id = 1");
        UnboundPredicate yearExpression = Expressions.greaterThan((UnboundTerm)Expressions.year((String)"ts"), (Object)10);
        Assertions.assertThat((String)Spark3Util.describe((Expression)yearExpression)).isEqualTo("year(ts) > 10");
        UnboundPredicate monthExpression = Expressions.greaterThanOrEqual((UnboundTerm)Expressions.month((String)"ts"), (Object)10);
        Assertions.assertThat((String)Spark3Util.describe((Expression)monthExpression)).isEqualTo("month(ts) >= 10");
        UnboundPredicate dayExpression = Expressions.lessThan((UnboundTerm)Expressions.day((String)"ts"), (Object)10);
        Assertions.assertThat((String)Spark3Util.describe((Expression)dayExpression)).isEqualTo("day(ts) < 10");
        UnboundPredicate hourExpression = Expressions.lessThanOrEqual((UnboundTerm)Expressions.hour((String)"ts"), (Object)10);
        Assertions.assertThat((String)Spark3Util.describe((Expression)hourExpression)).isEqualTo("hour(ts) <= 10");
        UnboundPredicate bucketExpression = Expressions.in((UnboundTerm)Expressions.bucket((String)"id", (int)5), (Object[])new Integer[]{3});
        Assertions.assertThat((String)Spark3Util.describe((Expression)bucketExpression)).isEqualTo("bucket[5](id) IN (3)");
        UnboundPredicate truncateExpression = Expressions.notIn((UnboundTerm)Expressions.truncate((String)"name", (int)3), (Object[])new String[]{"abc"});
        Assertions.assertThat((String)Spark3Util.describe((Expression)truncateExpression)).isEqualTo("truncate[3](name) NOT IN ('abc')");
        Expression andExpression = Expressions.and((Expression)refExpression, (Expression)yearExpression);
        Assertions.assertThat((String)Spark3Util.describe((Expression)andExpression)).isEqualTo("(id = 1 AND year(ts) > 10)");
    }

    private SortOrder buildSortOrder(String transform, Schema schema, int sourceId) {
        String jsonString = "{\n  \"order-id\" : 10,\n  \"fields\" : [ {\n    \"transform\" : \"" + transform + "\",\n    \"source-id\" : " + sourceId + ",\n    \"direction\" : \"desc\",\n    \"null-order\" : \"nulls-first\"\n  } ]\n}";
        return SortOrderParser.fromJson((Schema)schema, (String)jsonString);
    }
}

