/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkFilters;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.junit.Assert;
import org.junit.Test;

public class TestSparkFilters {
    @Test
    public void testQuotedAttributes() {
        HashMap attrMap = Maps.newHashMap();
        attrMap.put("id", "id");
        attrMap.put("`i.d`", "i.d");
        attrMap.put("`i``d`", "i`d");
        attrMap.put("`d`.b.`dd```", "d.b.dd`");
        attrMap.put("a.`aa```.c", "a.aa`.c");
        attrMap.forEach((quoted, unquoted) -> {
            IsNull isNull = IsNull.apply((String)quoted);
            UnboundPredicate expectedIsNull = Expressions.isNull((String)unquoted);
            Expression actualIsNull = SparkFilters.convert((Filter)isNull);
            Assert.assertEquals((String)"IsNull must match", (Object)expectedIsNull.toString(), (Object)actualIsNull.toString());
            IsNotNull isNotNull = IsNotNull.apply((String)quoted);
            UnboundPredicate expectedIsNotNull = Expressions.notNull((String)unquoted);
            Expression actualIsNotNull = SparkFilters.convert((Filter)isNotNull);
            Assert.assertEquals((String)"IsNotNull must match", (Object)expectedIsNotNull.toString(), (Object)actualIsNotNull.toString());
            LessThan lt = LessThan.apply((String)quoted, (Object)1);
            UnboundPredicate expectedLt = Expressions.lessThan((String)unquoted, (Object)1);
            Expression actualLt = SparkFilters.convert((Filter)lt);
            Assert.assertEquals((String)"LessThan must match", (Object)expectedLt.toString(), (Object)actualLt.toString());
            LessThanOrEqual ltEq = LessThanOrEqual.apply((String)quoted, (Object)1);
            UnboundPredicate expectedLtEq = Expressions.lessThanOrEqual((String)unquoted, (Object)1);
            Expression actualLtEq = SparkFilters.convert((Filter)ltEq);
            Assert.assertEquals((String)"LessThanOrEqual must match", (Object)expectedLtEq.toString(), (Object)actualLtEq.toString());
            GreaterThan gt = GreaterThan.apply((String)quoted, (Object)1);
            UnboundPredicate expectedGt = Expressions.greaterThan((String)unquoted, (Object)1);
            Expression actualGt = SparkFilters.convert((Filter)gt);
            Assert.assertEquals((String)"GreaterThan must match", (Object)expectedGt.toString(), (Object)actualGt.toString());
            GreaterThanOrEqual gtEq = GreaterThanOrEqual.apply((String)quoted, (Object)1);
            UnboundPredicate expectedGtEq = Expressions.greaterThanOrEqual((String)unquoted, (Object)1);
            Expression actualGtEq = SparkFilters.convert((Filter)gtEq);
            Assert.assertEquals((String)"GreaterThanOrEqual must match", (Object)expectedGtEq.toString(), (Object)actualGtEq.toString());
            EqualTo eq = EqualTo.apply((String)quoted, (Object)1);
            UnboundPredicate expectedEq = Expressions.equal((String)unquoted, (Object)1);
            Expression actualEq = SparkFilters.convert((Filter)eq);
            Assert.assertEquals((String)"EqualTo must match", (Object)expectedEq.toString(), (Object)actualEq.toString());
            EqualNullSafe eqNullSafe = EqualNullSafe.apply((String)quoted, (Object)1);
            UnboundPredicate expectedEqNullSafe = Expressions.equal((String)unquoted, (Object)1);
            Expression actualEqNullSafe = SparkFilters.convert((Filter)eqNullSafe);
            Assert.assertEquals((String)"EqualNullSafe must match", (Object)expectedEqNullSafe.toString(), (Object)actualEqNullSafe.toString());
            In in = In.apply((String)quoted, (Object[])new Integer[]{1});
            UnboundPredicate expectedIn = Expressions.in((String)unquoted, (Object[])new Integer[]{1});
            Expression actualIn = SparkFilters.convert((Filter)in);
            Assert.assertEquals((String)"In must match", (Object)expectedIn.toString(), (Object)actualIn.toString());
        });
    }

    @Test
    public void testTimestampFilterConversion() {
        Instant instant = Instant.parse("2018-10-18T00:00:57.907Z");
        Timestamp timestamp = Timestamp.from(instant);
        long epochMicros = ChronoUnit.MICROS.between(Instant.EPOCH, instant);
        Expression instantExpression = SparkFilters.convert((Filter)GreaterThan.apply((String)"x", (Object)instant));
        Expression timestampExpression = SparkFilters.convert((Filter)GreaterThan.apply((String)"x", (Object)timestamp));
        UnboundPredicate rawExpression = Expressions.greaterThan((String)"x", (Object)epochMicros);
        Assert.assertEquals((String)"Generated Timestamp expression should be correct", (Object)rawExpression.toString(), (Object)timestampExpression.toString());
        Assert.assertEquals((String)"Generated Instant expression should be correct", (Object)rawExpression.toString(), (Object)instantExpression.toString());
    }

    @Test
    public void testLocalDateTimeFilterConversion() {
        LocalDateTime ldt = LocalDateTime.parse("2018-10-18T00:00:57");
        long epochMicros = ChronoUnit.MICROS.between(LocalDateTime.ofInstant(Instant.EPOCH, ZoneId.of("UTC")), ldt);
        Expression instantExpression = SparkFilters.convert((Filter)GreaterThan.apply((String)"x", (Object)ldt));
        UnboundPredicate rawExpression = Expressions.greaterThan((String)"x", (Object)epochMicros);
        Assert.assertEquals((String)"Generated Instant expression should be correct", (Object)rawExpression.toString(), (Object)instantExpression.toString());
    }

    @Test
    public void testDateFilterConversion() {
        LocalDate localDate = LocalDate.parse("2018-10-18");
        Date date = Date.valueOf(localDate);
        long epochDay = localDate.toEpochDay();
        Expression localDateExpression = SparkFilters.convert((Filter)GreaterThan.apply((String)"x", (Object)localDate));
        Expression dateExpression = SparkFilters.convert((Filter)GreaterThan.apply((String)"x", (Object)date));
        UnboundPredicate rawExpression = Expressions.greaterThan((String)"x", (Object)epochDay);
        Assert.assertEquals((String)"Generated localdate expression should be correct", (Object)rawExpression.toString(), (Object)localDateExpression.toString());
        Assert.assertEquals((String)"Generated date expression should be correct", (Object)rawExpression.toString(), (Object)dateExpression.toString());
    }

    @Test
    public void testNestedInInsideNot() {
        Not filter = Not.apply((Filter)And.apply((Filter)EqualTo.apply((String)"col1", (Object)1), (Filter)In.apply((String)"col2", (Object[])new Integer[]{1, 2})));
        Expression converted = SparkFilters.convert((Filter)filter);
        Assert.assertNull((String)"Expression should not be converted", (Object)converted);
    }

    @Test
    public void testNotIn() {
        Not filter = Not.apply((Filter)In.apply((String)"col", (Object[])new Integer[]{1, 2}));
        Expression actual = SparkFilters.convert((Filter)filter);
        Expression expected = Expressions.and((Expression)Expressions.notNull((String)"col"), (Expression)Expressions.notIn((String)"col", (Object[])new Integer[]{1, 2}));
        Assert.assertEquals((String)"Expressions should match", (Object)expected.toString(), (Object)actual.toString());
    }
}

