/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkConfParser;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.iceberg.spark.SparkWriteConf;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSparkWriteConf
extends SparkTestBaseWithCatalog {
    @Before
    public void before() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
    }

    @After
    public void after() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testDurationConf() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        String confName = "spark.sql.iceberg.some-duration-conf";
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)confName, (Object)"10s"), () -> {
            SparkConfParser parser = new SparkConfParser(spark, table, (Map)ImmutableMap.of());
            Duration duration = ((SparkConfParser.DurationConfParser)parser.durationConf().sessionConf(confName)).parseOptional();
            Assertions.assertThat((Duration)duration).hasSeconds(10L);
        });
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)confName, (Object)"2m"), () -> {
            SparkConfParser parser = new SparkConfParser(spark, table, (Map)ImmutableMap.of());
            Duration duration = ((SparkConfParser.DurationConfParser)parser.durationConf().sessionConf(confName)).parseOptional();
            Assertions.assertThat((Duration)duration).hasMinutes(2L);
        });
    }

    @Test
    public void testDeleteGranularityDefault() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        DeleteGranularity value = writeConf.deleteGranularity();
        Assertions.assertThat((Comparable)value).isEqualTo((Object)DeleteGranularity.PARTITION);
    }

    @Test
    public void testDeleteGranularityTableProperty() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.granularity", DeleteGranularity.FILE.toString()).commit();
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        DeleteGranularity value = writeConf.deleteGranularity();
        Assertions.assertThat((Comparable)value).isEqualTo((Object)DeleteGranularity.FILE);
    }

    @Test
    public void testDeleteGranularityWriteOption() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.granularity", DeleteGranularity.PARTITION.toString()).commit();
        ImmutableMap options = ImmutableMap.of((Object)"delete-granularity", (Object)DeleteGranularity.FILE.toString());
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)options);
        DeleteGranularity value = writeConf.deleteGranularity();
        Assertions.assertThat((Comparable)value).isEqualTo((Object)DeleteGranularity.FILE);
    }

    @Test
    public void testDeleteGranularityInvalidValue() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.granularity", "invalid").commit();
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SparkWriteConf)writeConf).deleteGranularity()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Unknown delete granularity");
    }

    @Test
    public void testSparkWriteConfDistributionDefault() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        this.checkMode(DistributionMode.HASH, writeConf);
    }

    @Test
    public void testSparkWriteConfDistributionModeWithWriteOption() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ImmutableMap writeOptions = ImmutableMap.of((Object)"distribution-mode", (Object)DistributionMode.NONE.modeName());
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)writeOptions);
        this.checkMode(DistributionMode.NONE, writeConf);
    }

    @Test
    public void testSparkWriteConfDistributionModeWithSessionConfig() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.distribution-mode", (Object)DistributionMode.NONE.modeName()), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
            this.checkMode(DistributionMode.NONE, writeConf);
        });
    }

    @Test
    public void testSparkWriteConfDistributionModeWithTableProperties() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "none").set("write.delete.distribution-mode", "none").set("write.update.distribution-mode", "none").set("write.merge.distribution-mode", "none").commit();
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        this.checkMode(DistributionMode.NONE, writeConf);
    }

    @Test
    public void testSparkWriteConfDistributionModeWithTblPropAndSessionConfig() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.distribution-mode", (Object)DistributionMode.NONE.modeName()), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            table.updateProperties().set("write.distribution-mode", "range").set("write.delete.distribution-mode", "range").set("write.update.distribution-mode", "range").set("write.merge.distribution-mode", "range").commit();
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
            this.checkMode(DistributionMode.NONE, writeConf);
        });
    }

    @Test
    public void testSparkWriteConfDistributionModeWithWriteOptionAndSessionConfig() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.distribution-mode", (Object)DistributionMode.RANGE.modeName()), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            ImmutableMap writeOptions = ImmutableMap.of((Object)"distribution-mode", (Object)DistributionMode.NONE.modeName());
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)writeOptions);
            this.checkMode(DistributionMode.NONE, writeConf);
        });
    }

    @Test
    public void testSparkWriteConfDistributionModeWithEverything() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.distribution-mode", (Object)DistributionMode.RANGE.modeName()), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            ImmutableMap writeOptions = ImmutableMap.of((Object)"distribution-mode", (Object)DistributionMode.NONE.modeName());
            table.updateProperties().set("write.distribution-mode", "hash").set("write.delete.distribution-mode", "hash").set("write.update.distribution-mode", "hash").set("write.merge.distribution-mode", "hash").commit();
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)writeOptions);
            this.checkMode(DistributionMode.NONE, writeConf);
        });
    }

    @Test
    public void testSparkConfOverride() {
        ArrayList propertiesSuites = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Map[]{ImmutableMap.of((Object)"spark.sql.iceberg.compression-codec", (Object)"zstd", (Object)"spark.sql.iceberg.compression-level", (Object)"3"), ImmutableMap.of((Object)"write.format.default", (Object)"parquet", (Object)"write.delete.format.default", (Object)"parquet", (Object)"write.parquet.compression-codec", (Object)"gzip", (Object)"write.delete.parquet.compression-codec", (Object)"snappy"), ImmutableMap.of((Object)"write.delete.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-level", (Object)"3", (Object)"write.delete.parquet.compression-level", (Object)"3")}), Lists.newArrayList((Object[])new Map[]{ImmutableMap.of((Object)"spark.sql.iceberg.compression-codec", (Object)"zstd", (Object)"spark.sql.iceberg.compression-strategy", (Object)"compression"), ImmutableMap.of((Object)"write.format.default", (Object)"orc", (Object)"write.delete.format.default", (Object)"orc", (Object)"write.orc.compression-codec", (Object)"zlib", (Object)"write.delete.orc.compression-codec", (Object)"snappy"), ImmutableMap.of((Object)"write.delete.orc.compression-codec", (Object)"zstd", (Object)"write.orc.compression-codec", (Object)"zstd", (Object)"write.delete.orc.compression-strategy", (Object)"compression", (Object)"write.orc.compression-strategy", (Object)"compression")}), Lists.newArrayList((Object[])new Map[]{ImmutableMap.of((Object)"spark.sql.iceberg.compression-codec", (Object)"zstd", (Object)"spark.sql.iceberg.compression-level", (Object)"9"), ImmutableMap.of((Object)"write.format.default", (Object)"avro", (Object)"write.delete.format.default", (Object)"avro", (Object)"write.avro.compression-codec", (Object)"gzip", (Object)"write.delete.avro.compression-codec", (Object)"snappy"), ImmutableMap.of((Object)"write.delete.avro.compression-codec", (Object)"zstd", (Object)"write.avro.compression-codec", (Object)"zstd", (Object)"write.avro.compression-level", (Object)"9", (Object)"write.delete.avro.compression-level", (Object)"9")})});
        for (List propertiesSuite : propertiesSuites) {
            this.testWriteProperties(propertiesSuite);
        }
    }

    @Test
    public void testDataPropsDefaultsAsDeleteProps() {
        ArrayList propertiesSuites = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Map[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.format.default", (Object)"parquet", (Object)"write.delete.format.default", (Object)"parquet", (Object)"write.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-level", (Object)"5"), ImmutableMap.of((Object)"write.delete.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-level", (Object)"5", (Object)"write.delete.parquet.compression-level", (Object)"5")}), Lists.newArrayList((Object[])new Map[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.format.default", (Object)"orc", (Object)"write.delete.format.default", (Object)"orc", (Object)"write.orc.compression-codec", (Object)"snappy", (Object)"write.orc.compression-strategy", (Object)"speed"), ImmutableMap.of((Object)"write.delete.orc.compression-codec", (Object)"snappy", (Object)"write.orc.compression-codec", (Object)"snappy", (Object)"write.orc.compression-strategy", (Object)"speed", (Object)"write.delete.orc.compression-strategy", (Object)"speed")}), Lists.newArrayList((Object[])new Map[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.format.default", (Object)"avro", (Object)"write.delete.format.default", (Object)"avro", (Object)"write.avro.compression-codec", (Object)"snappy", (Object)"write.avro.compression-level", (Object)"9"), ImmutableMap.of((Object)"write.delete.avro.compression-codec", (Object)"snappy", (Object)"write.avro.compression-codec", (Object)"snappy", (Object)"write.avro.compression-level", (Object)"9", (Object)"write.delete.avro.compression-level", (Object)"9")})});
        for (List propertiesSuite : propertiesSuites) {
            this.testWriteProperties(propertiesSuite);
        }
    }

    @Test
    public void testDeleteFileWriteConf() {
        ArrayList propertiesSuites = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Map[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.format.default", (Object)"parquet", (Object)"write.delete.format.default", (Object)"parquet", (Object)"write.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-level", (Object)"5", (Object)"write.delete.parquet.compression-level", (Object)"6"), ImmutableMap.of((Object)"write.delete.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-level", (Object)"5", (Object)"write.delete.parquet.compression-level", (Object)"6")}), Lists.newArrayList((Object[])new Map[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.format.default", (Object)"orc", (Object)"write.delete.format.default", (Object)"orc", (Object)"write.orc.compression-codec", (Object)"snappy", (Object)"write.orc.compression-strategy", (Object)"speed", (Object)"write.delete.orc.compression-codec", (Object)"zstd", (Object)"write.delete.orc.compression-strategy", (Object)"compression"), ImmutableMap.of((Object)"write.delete.orc.compression-codec", (Object)"zstd", (Object)"write.orc.compression-codec", (Object)"snappy", (Object)"write.orc.compression-strategy", (Object)"speed", (Object)"write.delete.orc.compression-strategy", (Object)"compression")}), Lists.newArrayList((Object[])new Map[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.format.default", (Object)"avro", (Object)"write.delete.format.default", (Object)"avro", (Object)"write.avro.compression-codec", (Object)"snappy", (Object)"write.avro.compression-level", (Object)"9", (Object)"write.delete.avro.compression-codec", (Object)"zstd", (Object)"write.delete.avro.compression-level", (Object)"16"), ImmutableMap.of((Object)"write.delete.avro.compression-codec", (Object)"zstd", (Object)"write.avro.compression-codec", (Object)"snappy", (Object)"write.avro.compression-level", (Object)"9", (Object)"write.delete.avro.compression-level", (Object)"16")})});
        for (List propertiesSuite : propertiesSuites) {
            this.testWriteProperties(propertiesSuite);
        }
    }

    private void testWriteProperties(List<Map<String, String>> propertiesSuite) {
        this.withSQLConf(propertiesSuite.get(0), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            Map tableProperties = (Map)propertiesSuite.get(1);
            UpdateProperties updateProperties = table.updateProperties();
            for (Map.Entry entry : tableProperties.entrySet()) {
                updateProperties.set((String)entry.getKey(), (String)entry.getValue());
            }
            updateProperties.commit();
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
            Map writeProperties = writeConf.writeProperties();
            Map expectedProperties = (Map)propertiesSuite.get(2);
            Assert.assertEquals((long)expectedProperties.size(), (long)writeConf.writeProperties().size());
            for (Map.Entry entry : writeProperties.entrySet()) {
                Assert.assertEquals(entry.getValue(), expectedProperties.get(entry.getKey()));
            }
            table.refresh();
            updateProperties = table.updateProperties();
            for (Map.Entry entry : tableProperties.entrySet()) {
                updateProperties.remove((String)entry.getKey());
            }
            updateProperties.commit();
        });
    }

    private void checkMode(DistributionMode expectedMode, SparkWriteConf writeConf) {
        Assert.assertEquals((Object)expectedMode, (Object)writeConf.distributionMode());
        Assert.assertEquals((Object)expectedMode, (Object)writeConf.copyOnWriteDistributionMode(RowLevelOperation.Command.DELETE));
        Assert.assertEquals((Object)expectedMode, (Object)writeConf.positionDeltaDistributionMode(RowLevelOperation.Command.DELETE));
        Assert.assertEquals((Object)expectedMode, (Object)writeConf.copyOnWriteDistributionMode(RowLevelOperation.Command.UPDATE));
        Assert.assertEquals((Object)expectedMode, (Object)writeConf.positionDeltaDistributionMode(RowLevelOperation.Command.UPDATE));
        Assert.assertEquals((Object)expectedMode, (Object)writeConf.copyOnWriteDistributionMode(RowLevelOperation.Command.MERGE));
        Assert.assertEquals((Object)expectedMode, (Object)writeConf.positionDeltaDistributionMode(RowLevelOperation.Command.MERGE));
    }
}

