/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.BlobMetadata;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.ComputeTableStats;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;

public class TestComputeTableStatsAction
extends SparkCatalogTestBase {
    private static final Types.StructType LEAF_STRUCT_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"leafLongCol", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"leafDoubleCol", (Type)Types.DoubleType.get())});
    private static final Types.StructType NESTED_STRUCT_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"leafStructCol", (Type)LEAF_STRUCT_TYPE)});
    private static final Schema NESTED_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)4, (String)"nestedStructCol", (Type)NESTED_STRUCT_TYPE)});
    private static final Schema SCHEMA_WITH_NESTED_COLUMN = new Schema(new Types.NestedField[]{Types.NestedField.required((int)4, (String)"nestedStructCol", (Type)NESTED_STRUCT_TYPE), Types.NestedField.required((int)5, (String)"stringCol", (Type)Types.StringType.get())});

    public TestComputeTableStatsAction(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Test
    public void testLoadingTableDirectly() {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        this.sql("INSERT into %s values(1, 'abcd')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SparkActions actions = SparkActions.get();
        ComputeTableStats.Result results = (ComputeTableStats.Result)actions.computeTableStats(table).execute();
        StatisticsFile statisticsFile = results.statisticsFile();
        Assertions.assertThat((long)statisticsFile.fileSizeInBytes()).isNotEqualTo(0L);
        Assertions.assertThat((int)statisticsFile.blobMetadata().size()).isEqualTo(2);
    }

    @Test
    public void testComputeTableStatsAction() throws NoSuchTableException, ParseException {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        table.updateProperties().set("read.split.target-size", "100").set("write.parquet.row-group-size-bytes", "100").commit();
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, "a"), new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "c"), new SimpleRecord(4, "d")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).writeTo(this.tableName).append();
        SparkActions actions = SparkActions.get();
        ComputeTableStats.Result results = (ComputeTableStats.Result)actions.computeTableStats(table).columns(new String[]{"id", "data"}).execute();
        Assertions.assertThat((Object)results).isNotNull();
        List statisticsFiles = table.statisticsFiles();
        Assertions.assertThat((int)statisticsFiles.size()).isEqualTo(1);
        StatisticsFile statisticsFile = (StatisticsFile)statisticsFiles.get(0);
        Assertions.assertThat((long)statisticsFile.fileSizeInBytes()).isNotEqualTo(0L);
        Assertions.assertThat((int)statisticsFile.blobMetadata().size()).isEqualTo(2);
        BlobMetadata blobMetadata = (BlobMetadata)statisticsFile.blobMetadata().get(0);
        Assertions.assertThat((String)((String)blobMetadata.properties().get("ndv"))).isEqualTo(String.valueOf(4));
    }

    @Test
    public void testComputeTableStatsActionWithoutExplicitColumns() throws NoSuchTableException, ParseException {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "c"), new SimpleRecord(4, "d")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        SparkActions actions = SparkActions.get();
        ComputeTableStats.Result results = (ComputeTableStats.Result)actions.computeTableStats(table).execute();
        Assertions.assertThat((Object)results).isNotNull();
        Assertions.assertThat((int)table.statisticsFiles().size()).isEqualTo(1);
        StatisticsFile statisticsFile = (StatisticsFile)table.statisticsFiles().get(0);
        Assertions.assertThat((int)statisticsFile.blobMetadata().size()).isEqualTo(2);
        Assertions.assertThat((long)statisticsFile.fileSizeInBytes()).isNotEqualTo(0L);
        Assertions.assertThat((long)Long.parseLong((String)((BlobMetadata)statisticsFile.blobMetadata().get(0)).properties().get("ndv"))).isEqualTo(4L);
        Assertions.assertThat((long)Long.parseLong((String)((BlobMetadata)statisticsFile.blobMetadata().get(1)).properties().get("ndv"))).isEqualTo(4L);
    }

    @Test
    public void testComputeTableStatsForInvalidColumns() throws NoSuchTableException, ParseException {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        this.sql("INSERT into %s values(1, 'abcd')", this.tableName);
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        SparkActions actions = SparkActions.get();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> actions.computeTableStats(table).columns(new String[]{"id1"}).execute()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Can't find column id1 in table");
    }

    @Test
    public void testComputeTableStatsWithNoSnapshots() throws NoSuchTableException, ParseException {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        SparkActions actions = SparkActions.get();
        ComputeTableStats.Result result = (ComputeTableStats.Result)actions.computeTableStats(table).columns(new String[]{"id"}).execute();
        Assertions.assertThat((Object)result.statisticsFile()).isNull();
    }

    @Test
    public void testComputeTableStatsWithNullValues() throws NoSuchTableException, ParseException {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, null), new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "c"), new SimpleRecord(4, "d")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        SparkActions actions = SparkActions.get();
        ComputeTableStats.Result results = (ComputeTableStats.Result)actions.computeTableStats(table).columns(new String[]{"data"}).execute();
        Assertions.assertThat((Object)results).isNotNull();
        List statisticsFiles = table.statisticsFiles();
        Assertions.assertThat((int)statisticsFiles.size()).isEqualTo(1);
        StatisticsFile statisticsFile = (StatisticsFile)statisticsFiles.get(0);
        Assertions.assertThat((long)statisticsFile.fileSizeInBytes()).isNotEqualTo(0L);
        Assertions.assertThat((int)statisticsFile.blobMetadata().size()).isEqualTo(1);
        BlobMetadata blobMetadata = (BlobMetadata)statisticsFile.blobMetadata().get(0);
        Assertions.assertThat((String)((String)blobMetadata.properties().get("ndv"))).isEqualTo(String.valueOf(4));
    }

    @Test
    public void testComputeTableStatsWithSnapshotHavingDifferentSchemas() throws NoSuchTableException, ParseException {
        SparkActions actions = SparkActions.get();
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        this.sql("INSERT into %s values(1, 'abcd')", this.tableName);
        long snapshotId1 = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName).currentSnapshot().snapshotId();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        Assertions.assertThatCode(() -> actions.computeTableStats(table).columns(new String[]{"data"}).execute()).doesNotThrowAnyException();
        this.sql("ALTER TABLE %s DROP COLUMN %s", this.tableName, "data");
        this.sql("INSERT into %s values(1)", this.tableName);
        table.refresh();
        long snapshotId2 = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName).currentSnapshot().snapshotId();
        Assertions.assertThatCode(() -> actions.computeTableStats(table).snapshot(snapshotId1).columns(new String[]{"data"}).execute()).doesNotThrowAnyException();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> actions.computeTableStats(table).snapshot(snapshotId2).columns(new String[]{"data"}).execute()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Can't find column data in table");
    }

    @Test
    public void testComputeTableStatsWhenSnapshotIdNotSpecified() throws NoSuchTableException, ParseException {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", this.tableName);
        this.sql("INSERT into %s values(1, 'abcd')", this.tableName);
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        SparkActions actions = SparkActions.get();
        ComputeTableStats.Result results = (ComputeTableStats.Result)actions.computeTableStats(table).columns(new String[]{"data"}).execute();
        Assertions.assertThat((Object)results).isNotNull();
        List statisticsFiles = table.statisticsFiles();
        Assertions.assertThat((int)statisticsFiles.size()).isEqualTo(1);
        StatisticsFile statisticsFile = (StatisticsFile)statisticsFiles.get(0);
        Assertions.assertThat((long)statisticsFile.fileSizeInBytes()).isNotEqualTo(0L);
        Assertions.assertThat((int)statisticsFile.blobMetadata().size()).isEqualTo(1);
        BlobMetadata blobMetadata = (BlobMetadata)statisticsFile.blobMetadata().get(0);
        Assertions.assertThat((String)((String)blobMetadata.properties().get("ndv"))).isEqualTo(String.valueOf(1));
    }

    @Test
    public void testComputeTableStatsWithNestedSchema() throws NoSuchTableException, ParseException, IOException {
        ArrayList records = Lists.newArrayList((Object[])new Record[]{this.createNestedRecord()});
        Table table = this.validationCatalog.createTable(this.tableIdent, SCHEMA_WITH_NESTED_COLUMN, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of());
        DataFile dataFile = FileHelpers.writeDataFile((Table)table, (OutputFile)Files.localOutput((File)this.temp.newFile()), (List)records);
        table.newAppend().appendFile(dataFile).commit();
        Table tbl = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        SparkActions actions = SparkActions.get();
        actions.computeTableStats(tbl).execute();
        tbl.refresh();
        List statisticsFiles = tbl.statisticsFiles();
        Assertions.assertThat((int)statisticsFiles.size()).isEqualTo(1);
        StatisticsFile statisticsFile = (StatisticsFile)statisticsFiles.get(0);
        Assertions.assertThat((long)statisticsFile.fileSizeInBytes()).isNotEqualTo(0L);
        Assertions.assertThat((int)statisticsFile.blobMetadata().size()).isEqualTo(1);
    }

    @Test
    public void testComputeTableStatsWithNoComputableColumns() throws IOException {
        ArrayList records = Lists.newArrayList((Object[])new Record[]{this.createNestedRecord()});
        Table table = this.validationCatalog.createTable(this.tableIdent, NESTED_SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of());
        DataFile dataFile = FileHelpers.writeDataFile((Table)table, (OutputFile)Files.localOutput((File)this.temp.newFile()), (List)records);
        table.newAppend().appendFile(dataFile).commit();
        table.refresh();
        SparkActions actions = SparkActions.get();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> actions.computeTableStats(table).execute()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No columns found to compute stats");
    }

    @Test
    public void testComputeTableStatsOnByteColumn() throws NoSuchTableException, ParseException {
        this.testComputeTableStats("byte_col", "TINYINT");
    }

    @Test
    public void testComputeTableStatsOnShortColumn() throws NoSuchTableException, ParseException {
        this.testComputeTableStats("short_col", "SMALLINT");
    }

    @Test
    public void testComputeTableStatsOnIntColumn() throws NoSuchTableException, ParseException {
        this.testComputeTableStats("int_col", "INT");
    }

    @Test
    public void testComputeTableStatsOnLongColumn() throws NoSuchTableException, ParseException {
        this.testComputeTableStats("long_col", "BIGINT");
    }

    @Test
    public void testComputeTableStatsOnTimestampColumn() throws NoSuchTableException, ParseException {
        this.testComputeTableStats("timestamp_col", "TIMESTAMP");
    }

    @Test
    public void testComputeTableStatsOnTimestampNtzColumn() throws NoSuchTableException, ParseException {
        this.testComputeTableStats("timestamp_col", "TIMESTAMP_NTZ");
    }

    @Test
    public void testComputeTableStatsOnDateColumn() throws NoSuchTableException, ParseException {
        this.testComputeTableStats("date_col", "DATE");
    }

    @Test
    public void testComputeTableStatsOnDecimalColumn() throws NoSuchTableException, ParseException {
        this.testComputeTableStats("decimal_col", "DECIMAL(20, 2)");
    }

    @Test
    public void testComputeTableStatsOnBinaryColumn() throws NoSuchTableException, ParseException {
        this.testComputeTableStats("binary_col", "BINARY");
    }

    public void testComputeTableStats(String columnName, String type) throws NoSuchTableException, ParseException {
        this.sql("CREATE TABLE %s (id int, %s %s) USING iceberg", this.tableName, columnName, type);
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        Dataset<Row> dataDF = this.randomDataDF(table.schema());
        this.append(this.tableName, dataDF);
        SparkActions actions = SparkActions.get();
        table.refresh();
        ComputeTableStats.Result results = (ComputeTableStats.Result)actions.computeTableStats(table).columns(new String[]{columnName}).execute();
        Assertions.assertThat((Object)results).isNotNull();
        List statisticsFiles = table.statisticsFiles();
        Assertions.assertThat((int)statisticsFiles.size()).isEqualTo(1);
        StatisticsFile statisticsFile = (StatisticsFile)statisticsFiles.get(0);
        Assertions.assertThat((long)statisticsFile.fileSizeInBytes()).isNotEqualTo(0L);
        Assertions.assertThat((int)statisticsFile.blobMetadata().size()).isEqualTo(1);
        BlobMetadata blobMetadata = (BlobMetadata)statisticsFile.blobMetadata().get(0);
        Assertions.assertThat((String)((String)blobMetadata.properties().get("ndv"))).isNotNull();
    }

    private GenericRecord createNestedRecord() {
        GenericRecord record = GenericRecord.create((Schema)SCHEMA_WITH_NESTED_COLUMN);
        GenericRecord nested = GenericRecord.create((Types.StructType)NESTED_STRUCT_TYPE);
        GenericRecord leaf = GenericRecord.create((Types.StructType)LEAF_STRUCT_TYPE);
        leaf.set(0, (Object)0L);
        leaf.set(1, (Object)0.0);
        nested.set(0, (Object)leaf);
        record.set(0, (Object)nested);
        record.set(1, (Object)"data");
        return record;
    }

    private Dataset<Row> randomDataDF(Schema schema) {
        Iterable<InternalRow> rows = RandomData.generateSpark(schema, 10, 0L);
        JavaRDD rowRDD = sparkContext.parallelize((List)Lists.newArrayList(rows));
        StructType rowSparkType = SparkSchemaUtil.convert((Schema)schema);
        return spark.internalCreateDataFrame(JavaRDD.toRDD((JavaRDD)rowRDD), rowSparkType, false);
    }

    private void append(String table, Dataset<Row> df) throws NoSuchTableException {
        df.coalesce(1).writeTo(table).option("fanout-enabled", "true").append();
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }
}

