/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.actions.SparkActions;
import org.assertj.core.api.Assumptions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestMigrateTableAction
extends SparkCatalogTestBase {
    public TestMigrateTableAction(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
        Assumptions.assumeThat((String)catalogName).isEqualToIgnoringCase((CharSequence)"spark_catalog");
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
        this.sql("DROP TABLE IF EXISTS %s_BACKUP_", this.tableName);
    }

    @Test
    public void testMigrateWithParallelTasks() throws IOException {
        String location = this.temp.newFolder().toURI().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", this.tableName, location);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", this.tableName);
        AtomicInteger migrationThreadsIndex = new AtomicInteger(0);
        SparkActions.get().migrateTable(this.tableName).executeWith(Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("table-migration-" + migrationThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        })).execute();
        Assert.assertEquals((long)migrationThreadsIndex.get(), (long)2L);
    }
}

