/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.RemoveDanglingDeleteFiles;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkTestBase;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import scala.Tuple2;

public class TestRemoveDanglingDeleteAction
extends SparkTestBase {
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("c1").build();
    static final DataFile FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=a").withRecordCount(1L).build();
    static final DataFile FILE_A2 = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=a").withRecordCount(1L).build();
    static final DataFile FILE_B = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=b").withRecordCount(1L).build();
    static final DataFile FILE_B2 = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=b").withRecordCount(1L).build();
    static final DataFile FILE_C = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-c.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=c").withRecordCount(1L).build();
    static final DataFile FILE_C2 = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-c.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=c").withRecordCount(1L).build();
    static final DataFile FILE_D = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-d.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=d").withRecordCount(1L).build();
    static final DataFile FILE_D2 = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-d.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=d").withRecordCount(1L).build();
    static final DeleteFile FILE_A_POS_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-a-pos-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=a").withRecordCount(1L).build();
    static final DeleteFile FILE_A2_POS_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-a2-pos-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=a").withRecordCount(1L).build();
    static final DeleteFile FILE_A_EQ_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-a-eq-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=a").withRecordCount(1L).build();
    static final DeleteFile FILE_A2_EQ_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-a2-eq-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=a").withRecordCount(1L).build();
    static final DeleteFile FILE_B_POS_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-b-pos-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=b").withRecordCount(1L).build();
    static final DeleteFile FILE_B2_POS_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-b2-pos-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=b").withRecordCount(1L).build();
    static final DeleteFile FILE_B_EQ_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-b-eq-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=b").withRecordCount(1L).build();
    static final DeleteFile FILE_B2_EQ_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-b2-eq-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=b").withRecordCount(1L).build();
    static final DataFile FILE_UNPARTITIONED = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("/path/to/data-unpartitioned.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    static final DeleteFile FILE_UNPARTITIONED_POS_DELETE = FileMetadata.deleteFileBuilder((PartitionSpec)PartitionSpec.unpartitioned()).ofEqualityDeletes(new int[0]).withPath("/path/to/data-unpartitioned-pos-deletes.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    static final DeleteFile FILE_UNPARTITIONED_EQ_DELETE = FileMetadata.deleteFileBuilder((PartitionSpec)PartitionSpec.unpartitioned()).ofEqualityDeletes(new int[0]).withPath("/path/to/data-unpartitioned-eq-deletes.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private String tableLocation = null;
    private Table table;

    @Before
    public void before() throws Exception {
        File tableDir = this.temp.newFolder();
        this.tableLocation = tableDir.toURI().toString();
    }

    @After
    public void after() {
        TABLES.dropTable(this.tableLocation);
    }

    private void setupPartitionedTable() {
        this.table = TABLES.create(SCHEMA, SPEC, (Map)ImmutableMap.of((Object)"format-version", (Object)"2"), this.tableLocation);
    }

    private void setupUnpartitionedTable() {
        this.table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"format-version", (Object)"2"), this.tableLocation);
    }

    @Test
    public void testPartitionedDeletesWithLesserSeqNo() {
        this.setupPartitionedTable();
        this.table.newAppend().appendFile(FILE_B).appendFile(FILE_C).appendFile(FILE_D).commit();
        this.table.newRowDelta().addDeletes(FILE_A_POS_DELETES).addDeletes(FILE_A2_POS_DELETES).addDeletes(FILE_B_POS_DELETES).addDeletes(FILE_B2_POS_DELETES).addDeletes(FILE_A_EQ_DELETES).addDeletes(FILE_A2_EQ_DELETES).addDeletes(FILE_B_EQ_DELETES).addDeletes(FILE_B2_EQ_DELETES).commit();
        this.table.newAppend().appendFile(FILE_A2).appendFile(FILE_B2).appendFile(FILE_C2).appendFile(FILE_D2).commit();
        List actual = spark.read().format("iceberg").load(this.tableLocation + "#entries").select("sequence_number", new String[]{"data_file.file_path"}).sort("sequence_number", new String[]{"data_file.file_path"}).as(Encoders.tuple((Encoder)Encoders.LONG(), (Encoder)Encoders.STRING())).collectAsList();
        ImmutableList expected = ImmutableList.of((Object)Tuple2.apply((Object)1L, (Object)FILE_B.path().toString()), (Object)Tuple2.apply((Object)1L, (Object)FILE_C.path().toString()), (Object)Tuple2.apply((Object)1L, (Object)FILE_D.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A_EQ_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2_EQ_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B_EQ_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2_EQ_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)3L, (Object)FILE_A2.path().toString()), (Object[])new Tuple2[]{Tuple2.apply((Object)3L, (Object)FILE_B2.path().toString()), Tuple2.apply((Object)3L, (Object)FILE_C2.path().toString()), Tuple2.apply((Object)3L, (Object)FILE_D2.path().toString())});
        Assertions.assertThat((List)actual).isEqualTo((Object)expected);
        RemoveDanglingDeleteFiles.Result result = (RemoveDanglingDeleteFiles.Result)SparkActions.get().removeDanglingDeleteFiles(this.table).execute();
        Set removedDeleteFiles = StreamSupport.stream(result.removedDeleteFiles().spliterator(), false).map(ContentFile::path).collect(Collectors.toSet());
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(removedDeleteFiles).as("Expected 4 delete files removed", new Object[0])).hasSize(4)).containsExactlyInAnyOrder((Object[])new CharSequence[]{FILE_A_POS_DELETES.path(), FILE_A2_POS_DELETES.path(), FILE_A_EQ_DELETES.path(), FILE_A2_EQ_DELETES.path()});
        List actualAfter = spark.read().format("iceberg").load(this.tableLocation + "#entries").filter("status < 2").select("sequence_number", new String[]{"data_file.file_path"}).sort("sequence_number", new String[]{"data_file.file_path"}).as(Encoders.tuple((Encoder)Encoders.LONG(), (Encoder)Encoders.STRING())).collectAsList();
        ImmutableList expectedAfter = ImmutableList.of((Object)Tuple2.apply((Object)1L, (Object)FILE_B.path().toString()), (Object)Tuple2.apply((Object)1L, (Object)FILE_C.path().toString()), (Object)Tuple2.apply((Object)1L, (Object)FILE_D.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B_EQ_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2_EQ_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)3L, (Object)FILE_A2.path().toString()), (Object)Tuple2.apply((Object)3L, (Object)FILE_B2.path().toString()), (Object)Tuple2.apply((Object)3L, (Object)FILE_C2.path().toString()), (Object)Tuple2.apply((Object)3L, (Object)FILE_D2.path().toString()));
        Assertions.assertThat((List)actualAfter).isEqualTo((Object)expectedAfter);
    }

    @Test
    public void testPartitionedDeletesWithEqSeqNo() {
        this.setupPartitionedTable();
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_C).appendFile(FILE_D).commit();
        this.table.newRowDelta().addRows(FILE_A2).addRows(FILE_B2).addRows(FILE_C2).addRows(FILE_D2).addDeletes(FILE_A_POS_DELETES).addDeletes(FILE_A2_POS_DELETES).addDeletes(FILE_A_EQ_DELETES).addDeletes(FILE_A2_EQ_DELETES).addDeletes(FILE_B_POS_DELETES).addDeletes(FILE_B2_POS_DELETES).addDeletes(FILE_B_EQ_DELETES).addDeletes(FILE_B2_EQ_DELETES).commit();
        List actual = spark.read().format("iceberg").load(this.tableLocation + "#entries").select("sequence_number", new String[]{"data_file.file_path"}).sort("sequence_number", new String[]{"data_file.file_path"}).as(Encoders.tuple((Encoder)Encoders.LONG(), (Encoder)Encoders.STRING())).collectAsList();
        ImmutableList expected = ImmutableList.of((Object)Tuple2.apply((Object)1L, (Object)FILE_A.path().toString()), (Object)Tuple2.apply((Object)1L, (Object)FILE_C.path().toString()), (Object)Tuple2.apply((Object)1L, (Object)FILE_D.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A_EQ_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2_EQ_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B_EQ_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2_EQ_DELETES.path().toString()), (Object[])new Tuple2[]{Tuple2.apply((Object)2L, (Object)FILE_B2_POS_DELETES.path().toString()), Tuple2.apply((Object)2L, (Object)FILE_C2.path().toString()), Tuple2.apply((Object)2L, (Object)FILE_D2.path().toString())});
        Assertions.assertThat((List)actual).isEqualTo((Object)expected);
        RemoveDanglingDeleteFiles.Result result = (RemoveDanglingDeleteFiles.Result)SparkActions.get().removeDanglingDeleteFiles(this.table).execute();
        Set removedDeleteFiles = StreamSupport.stream(result.removedDeleteFiles().spliterator(), false).map(ContentFile::path).collect(Collectors.toSet());
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(removedDeleteFiles).as("Expected two delete files removed", new Object[0])).hasSize(2)).containsExactlyInAnyOrder((Object[])new CharSequence[]{FILE_B_EQ_DELETES.path(), FILE_B2_EQ_DELETES.path()});
        List actualAfter = spark.read().format("iceberg").load(this.tableLocation + "#entries").filter("status < 2").select("sequence_number", new String[]{"data_file.file_path"}).sort("sequence_number", new String[]{"data_file.file_path"}).as(Encoders.tuple((Encoder)Encoders.LONG(), (Encoder)Encoders.STRING())).collectAsList();
        ImmutableList expectedAfter = ImmutableList.of((Object)Tuple2.apply((Object)1L, (Object)FILE_A.path().toString()), (Object)Tuple2.apply((Object)1L, (Object)FILE_C.path().toString()), (Object)Tuple2.apply((Object)1L, (Object)FILE_D.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A_EQ_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2_EQ_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_A2_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_B2_POS_DELETES.path().toString()), (Object)Tuple2.apply((Object)2L, (Object)FILE_C2.path().toString()), (Object[])new Tuple2[]{Tuple2.apply((Object)2L, (Object)FILE_D2.path().toString())});
        Assertions.assertThat((List)actualAfter).isEqualTo((Object)expectedAfter);
    }

    @Test
    public void testUnpartitionedTable() {
        this.setupUnpartitionedTable();
        this.table.newRowDelta().addDeletes(FILE_UNPARTITIONED_POS_DELETE).addDeletes(FILE_UNPARTITIONED_EQ_DELETE).commit();
        this.table.newAppend().appendFile(FILE_UNPARTITIONED).commit();
        RemoveDanglingDeleteFiles.Result result = (RemoveDanglingDeleteFiles.Result)SparkActions.get().removeDanglingDeleteFiles(this.table).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.removedDeleteFiles()).as("No-op for unpartitioned tables", new Object[0])).isEmpty();
    }
}

