/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.Files;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.ValidationHelpers;
import org.apache.iceberg.actions.RewriteManifests;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.spark.SparkTestBase;
import org.apache.iceberg.spark.actions.RewriteManifestsSparkAction;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.source.ThreeColumnRecord;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.Pair;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestRewriteManifestsAction
extends SparkTestBase {
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private final String snapshotIdInheritanceEnabled;
    private final String useCaching;
    private final int formatVersion;
    private final boolean shouldStageManifests;
    private String tableLocation = null;

    @Parameterized.Parameters(name="snapshotIdInheritanceEnabled = {0}, useCaching = {1}, formatVersion = {2}")
    public static Object[] parameters() {
        return new Object[][]{{"true", "true", 1}, {"false", "true", 1}, {"true", "false", 2}, {"false", "false", 2}};
    }

    public TestRewriteManifestsAction(String snapshotIdInheritanceEnabled, String useCaching, int formatVersion) {
        this.snapshotIdInheritanceEnabled = snapshotIdInheritanceEnabled;
        this.useCaching = useCaching;
        this.formatVersion = formatVersion;
        this.shouldStageManifests = formatVersion == 1 && snapshotIdInheritanceEnabled.equals("false");
    }

    @Before
    public void setupTableLocation() throws Exception {
        File tableDir = this.temp.newFolder();
        this.tableLocation = tableDir.toURI().toString();
    }

    @Test
    public void testRewriteManifestsEmptyTable() throws IOException {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        Assert.assertNull((String)"Table must be empty", (Object)table.currentSnapshot());
        SparkActions actions = SparkActions.get();
        ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> true).option("use-caching", this.useCaching)).stagingLocation(this.temp.newFolder().toString()).execute();
        Assert.assertNull((String)"Table must stay empty", (Object)table.currentSnapshot());
    }

    @Test
    public void testRewriteSmallManifestsNonPartitionedTable() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(1, "BBBBBBBBBB", "BBBB")});
        this.writeRecords(records1);
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "CCCCCCCCCC", "CCCC"), new ThreeColumnRecord(2, "DDDDDDDDDD", "DDDD")});
        this.writeRecords(records2);
        table.refresh();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 2 manifests before rewrite", (long)2L, (long)manifests.size());
        SparkActions actions = SparkActions.get();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> true).option("use-caching", this.useCaching)).execute();
        Assert.assertEquals((String)"Action should rewrite 2 manifests", (long)2L, (long)Iterables.size((Iterable)result.rewrittenManifests()));
        Assert.assertEquals((String)"Action should add 1 manifests", (long)1L, (long)Iterables.size((Iterable)result.addedManifests()));
        this.assertManifestsLocation(result.addedManifests());
        table.refresh();
        List newManifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 1 manifests after rewrite", (long)1L, (long)newManifests.size());
        Assert.assertEquals((long)4L, (long)((ManifestFile)newManifests.get(0)).existingFilesCount().intValue());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(0)).hasAddedFiles());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(0)).hasDeletedFiles());
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.addAll(records1);
        expectedRecords.addAll(records2);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.sort("c1", new String[]{"c2"}).as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        Assert.assertEquals((String)"Rows must match", (Object)expectedRecords, (Object)actualRecords);
    }

    @Test
    public void testRewriteManifestsWithCommitStateUnknownException() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(1, "BBBBBBBBBB", "BBBB")});
        this.writeRecords(records1);
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "CCCCCCCCCC", "CCCC"), new ThreeColumnRecord(2, "DDDDDDDDDD", "DDDD")});
        this.writeRecords(records2);
        table.refresh();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 2 manifests before rewrite", (long)2L, (long)manifests.size());
        SparkActions actions = SparkActions.get();
        RewriteManifests newRewriteManifests = table.rewriteManifests();
        RewriteManifests spyNewRewriteManifests = (RewriteManifests)Mockito.spy((Object)newRewriteManifests);
        ((RewriteManifests)Mockito.doAnswer(invocation -> {
            newRewriteManifests.commit();
            throw new CommitStateUnknownException((Throwable)new RuntimeException("Datacenter on Fire"));
        }).when((Object)spyNewRewriteManifests)).commit();
        Table spyTable = (Table)Mockito.spy((Object)table);
        Mockito.when((Object)spyTable.rewriteManifests()).thenReturn((Object)spyNewRewriteManifests);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> actions.rewriteManifests(spyTable).rewriteIf(manifest -> true).execute()).cause().isInstanceOf(RuntimeException.class)).hasMessage("Datacenter on Fire");
        table.refresh();
        List newManifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 1 manifests after rewrite", (long)1L, (long)newManifests.size());
        Assert.assertEquals((long)4L, (long)((ManifestFile)newManifests.get(0)).existingFilesCount().intValue());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(0)).hasAddedFiles());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(0)).hasDeletedFiles());
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.addAll(records1);
        expectedRecords.addAll(records2);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.sort("c1", new String[]{"c2"}).as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        Assert.assertEquals((String)"Rows must match", (Object)expectedRecords, (Object)actualRecords);
    }

    @Test
    public void testRewriteSmallManifestsPartitionedTable() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c1").truncate("c2", 2).build();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(1, "BBBBBBBBBB", "BBBB")});
        this.writeRecords(records1);
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "CCCCCCCCCC", "CCCC"), new ThreeColumnRecord(2, "DDDDDDDDDD", "DDDD")});
        this.writeRecords(records2);
        ArrayList records3 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(3, "EEEEEEEEEE", "EEEE"), new ThreeColumnRecord(3, "FFFFFFFFFF", "FFFF")});
        this.writeRecords(records3);
        ArrayList records4 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(4, "GGGGGGGGGG", "GGGG"), new ThreeColumnRecord(4, "HHHHHHHHHG", "HHHH")});
        this.writeRecords(records4);
        table.refresh();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 4 manifests before rewrite", (long)4L, (long)manifests.size());
        SparkActions actions = SparkActions.get();
        long manifestEntrySizeBytes = this.computeManifestEntrySizeBytes(manifests);
        long targetManifestSizeBytes = (long)(4.2 * (double)manifestEntrySizeBytes);
        table.updateProperties().set("commit.manifest.target-size-bytes", String.valueOf(targetManifestSizeBytes)).commit();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> true).option("use-caching", this.useCaching)).execute();
        Assert.assertEquals((String)"Action should rewrite 4 manifests", (long)4L, (long)Iterables.size((Iterable)result.rewrittenManifests()));
        Assert.assertEquals((String)"Action should add 2 manifests", (long)2L, (long)Iterables.size((Iterable)result.addedManifests()));
        this.assertManifestsLocation(result.addedManifests());
        table.refresh();
        List newManifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 2 manifests after rewrite", (long)2L, (long)newManifests.size());
        Assert.assertEquals((long)4L, (long)((ManifestFile)newManifests.get(0)).existingFilesCount().intValue());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(0)).hasAddedFiles());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(0)).hasDeletedFiles());
        Assert.assertEquals((long)4L, (long)((ManifestFile)newManifests.get(1)).existingFilesCount().intValue());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(1)).hasAddedFiles());
        Assert.assertFalse((boolean)((ManifestFile)newManifests.get(1)).hasDeletedFiles());
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.addAll(records1);
        expectedRecords.addAll(records2);
        expectedRecords.addAll(records3);
        expectedRecords.addAll(records4);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.sort("c1", new String[]{"c2"}).as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        Assert.assertEquals((String)"Rows must match", (Object)expectedRecords, (Object)actualRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRewriteImportedManifests() throws IOException {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c3").build();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(1, "BBBBBBBBBB", "BBBB")});
        File parquetTableDir = this.temp.newFolder("parquet_table");
        String parquetTableLocation = parquetTableDir.toURI().toString();
        try {
            Dataset inputDF = spark.createDataFrame((List)records, ThreeColumnRecord.class);
            inputDF.select("c1", new String[]{"c2", "c3"}).write().format("parquet").mode("overwrite").option("path", parquetTableLocation).partitionBy(new String[]{"c3"}).saveAsTable("parquet_table");
            File stagingDir = this.temp.newFolder("staging-dir");
            SparkTableUtil.importSparkTable((SparkSession)spark, (TableIdentifier)new TableIdentifier("parquet_table"), (Table)table, (String)stagingDir.toString());
            inputDF.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").mode("append").save(this.tableLocation);
            table.refresh();
            Snapshot snapshot = table.currentSnapshot();
            SparkActions actions = SparkActions.get();
            String rewriteStagingLocation = this.temp.newFolder().toString();
            RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> true).option("use-caching", this.useCaching)).stagingLocation(rewriteStagingLocation).execute();
            Assert.assertEquals((String)"Action should rewrite all manifests", (Object)snapshot.allManifests(table.io()), (Object)result.rewrittenManifests());
            Assert.assertEquals((String)"Action should add 1 manifest", (long)1L, (long)Iterables.size((Iterable)result.addedManifests()));
            this.assertManifestsLocation(result.addedManifests(), rewriteStagingLocation);
        }
        finally {
            spark.sql("DROP TABLE parquet_table");
        }
    }

    @Test
    public void testRewriteLargeManifestsPartitionedTable() throws IOException {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c3").build();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList dataFiles = Lists.newArrayList();
        for (int fileOrdinal = 0; fileOrdinal < 1000; ++fileOrdinal) {
            dataFiles.add(this.newDataFile(table, "c3=" + fileOrdinal));
        }
        ManifestFile appendManifest = this.writeManifest(table, dataFiles);
        table.newFastAppend().appendManifest(appendManifest).commit();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 1 manifests before rewrite", (long)1L, (long)manifests.size());
        table.updateProperties().set("commit.manifest.target-size-bytes", String.valueOf(((ManifestFile)manifests.get(0)).length() / 2L)).commit();
        SparkActions actions = SparkActions.get();
        String stagingLocation = this.temp.newFolder().toString();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> true).option("use-caching", this.useCaching)).stagingLocation(stagingLocation).execute();
        Assertions.assertThat((Iterable)result.rewrittenManifests()).hasSize(1);
        Assertions.assertThat((Iterable)result.addedManifests()).hasSizeGreaterThanOrEqualTo(2);
        this.assertManifestsLocation(result.addedManifests(), stagingLocation);
        table.refresh();
        List newManifests = table.currentSnapshot().allManifests(table.io());
        Assertions.assertThat((List)newManifests).hasSizeGreaterThanOrEqualTo(2);
    }

    @Test
    public void testRewriteManifestsWithPredicate() throws IOException {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c1").truncate("c2", 2).build();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(1, "BBBBBBBBBB", "BBBB")});
        this.writeRecords(records1);
        this.writeRecords(records1);
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "CCCCCCCCCC", "CCCC"), new ThreeColumnRecord(2, "DDDDDDDDDD", "DDDD")});
        this.writeRecords(records2);
        table.refresh();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 3 manifests before rewrite", (long)3L, (long)manifests.size());
        SparkActions actions = SparkActions.get();
        String stagingLocation = this.temp.newFolder().toString();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> manifest.path().equals(((ManifestFile)manifests.get(0)).path()) || manifest.path().equals(((ManifestFile)manifests.get(1)).path())).stagingLocation(stagingLocation).option("use-caching", this.useCaching)).execute();
        Assert.assertEquals((String)"Action should rewrite 2 manifest", (long)2L, (long)Iterables.size((Iterable)result.rewrittenManifests()));
        Assert.assertEquals((String)"Action should add 1 manifests", (long)1L, (long)Iterables.size((Iterable)result.addedManifests()));
        this.assertManifestsLocation(result.addedManifests(), stagingLocation);
        table.refresh();
        List newManifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 2 manifests after rewrite", (long)2L, (long)newManifests.size());
        Assert.assertFalse((String)"First manifest must be rewritten", (boolean)newManifests.contains(manifests.get(0)));
        Assert.assertFalse((String)"Second manifest must be rewritten", (boolean)newManifests.contains(manifests.get(1)));
        Assert.assertTrue((String)"Third manifest must not be rewritten", (boolean)newManifests.contains(manifests.get(2)));
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.add((ThreeColumnRecord)records1.get(0));
        expectedRecords.add((ThreeColumnRecord)records1.get(0));
        expectedRecords.add((ThreeColumnRecord)records1.get(1));
        expectedRecords.add((ThreeColumnRecord)records1.get(1));
        expectedRecords.addAll(records2);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.sort("c1", new String[]{"c2"}).as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        Assert.assertEquals((String)"Rows must match", (Object)expectedRecords, (Object)actualRecords);
    }

    @Test
    public void testRewriteSmallManifestsNonPartitionedV2Table() {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThan(1);
        PartitionSpec spec = PartitionSpec.unpartitioned();
        ImmutableMap properties = ImmutableMap.of((Object)"format-version", (Object)"2");
        Table table = TABLES.create(SCHEMA, spec, (Map)properties, this.tableLocation);
        ArrayList records1 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA")});
        this.writeRecords(records1);
        table.refresh();
        Snapshot snapshot1 = table.currentSnapshot();
        DataFile file1 = (DataFile)Iterables.getOnlyElement((Iterable)snapshot1.addedDataFiles(table.io()));
        ArrayList records2 = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(2, "CCCC", "CCCC")});
        this.writeRecords(records2);
        table.refresh();
        Snapshot snapshot2 = table.currentSnapshot();
        DataFile file2 = (DataFile)Iterables.getOnlyElement((Iterable)snapshot2.addedDataFiles(table.io()));
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 2 manifests before rewrite", (long)2L, (long)manifests.size());
        SparkActions actions = SparkActions.get();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).option("use-caching", this.useCaching)).execute();
        Assert.assertEquals((String)"Action should rewrite 2 manifests", (long)2L, (long)Iterables.size((Iterable)result.rewrittenManifests()));
        Assert.assertEquals((String)"Action should add 1 manifests", (long)1L, (long)Iterables.size((Iterable)result.addedManifests()));
        this.assertManifestsLocation(result.addedManifests());
        table.refresh();
        List newManifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 1 manifests after rewrite", (long)1L, (long)newManifests.size());
        ManifestFile newManifest = (ManifestFile)Iterables.getOnlyElement((Iterable)newManifests);
        Assert.assertEquals((long)2L, (long)newManifest.existingFilesCount().intValue());
        Assert.assertFalse((boolean)newManifest.hasAddedFiles());
        Assert.assertFalse((boolean)newManifest.hasDeletedFiles());
        ValidationHelpers.validateDataManifest(table, newManifest, ValidationHelpers.dataSeqs(1L, 2L), ValidationHelpers.fileSeqs(1L, 2L), ValidationHelpers.snapshotIds(snapshot1.snapshotId(), snapshot2.snapshotId()), ValidationHelpers.files(new ContentFile[]{file1, file2}));
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.addAll(records1);
        expectedRecords.addAll(records2);
        Dataset resultDF = spark.read().format("iceberg").load(this.tableLocation);
        List actualRecords = resultDF.sort("c1", new String[]{"c2"}).as(Encoders.bean(ThreeColumnRecord.class)).collectAsList();
        Assert.assertEquals((String)"Rows must match", (Object)expectedRecords, (Object)actualRecords);
    }

    @Test
    public void testRewriteLargeManifestsEvolvedUnpartitionedV1Table() throws IOException {
        Assumptions.assumeThat((int)this.formatVersion).isEqualTo(1);
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c3").build();
        HashMap options = Maps.newHashMap();
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        options.put("format-version", String.valueOf(this.formatVersion));
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        table.updateSpec().removeField("c3").commit();
        ((ListAssert)Assertions.assertThat((List)table.spec().fields()).hasSize(1)).allMatch(field -> field.transform().isVoid());
        ArrayList dataFiles = Lists.newArrayList();
        for (int fileOrdinal = 0; fileOrdinal < 1000; ++fileOrdinal) {
            dataFiles.add(this.newDataFile(table, (StructLike)TestHelpers.Row.of((Object[])new Object[]{null})));
        }
        ManifestFile appendManifest = this.writeManifest(table, dataFiles);
        table.newFastAppend().appendManifest(appendManifest).commit();
        List originalManifests = table.currentSnapshot().allManifests(table.io());
        ManifestFile originalManifest = (ManifestFile)Iterables.getOnlyElement((Iterable)originalManifests);
        table.updateProperties().set("commit.manifest.target-size-bytes", String.valueOf(originalManifest.length() / 2L)).commit();
        SparkActions actions = SparkActions.get();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> true).option("use-caching", this.useCaching)).execute();
        Assertions.assertThat((Iterable)result.rewrittenManifests()).hasSize(1);
        Assertions.assertThat((Iterable)result.addedManifests()).hasSizeGreaterThanOrEqualTo(2);
        this.assertManifestsLocation(result.addedManifests());
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assertions.assertThat((List)manifests).hasSizeGreaterThanOrEqualTo(2);
    }

    @Test
    public void testRewriteSmallDeleteManifestsNonPartitionedTable() throws IOException {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThan(1);
        PartitionSpec spec = PartitionSpec.unpartitioned();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(2, "BBBBBBBBBB", "BBBB"), new ThreeColumnRecord(3, "CCCCCCCCCC", "CCCC"), new ThreeColumnRecord(4, "DDDDDDDDDD", "DDDD")});
        this.writeRecords(records);
        List<Pair<CharSequence, Long>> posDeletes = this.generatePosDeletes("c1 = 1 OR c1 = 2");
        Pair<DeleteFile, CharSequenceSet> posDeleteWriteResult = this.writePosDeletes(table, posDeletes);
        table.newRowDelta().addDeletes((DeleteFile)posDeleteWriteResult.first()).validateDataFilesExist((Iterable)posDeleteWriteResult.second()).commit();
        DeleteFile eqDeleteFile = this.writeEqDeletes(table, "c1", 3);
        table.newRowDelta().addDeletes(eqDeleteFile).commit();
        List originalManifests = table.currentSnapshot().allManifests(table.io());
        Assertions.assertThat((List)originalManifests).hasSize(3);
        SparkActions actions = SparkActions.get();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).option("use-caching", this.useCaching)).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.rewrittenManifests()).hasSize(2)).allMatch(m -> m.content() == ManifestContent.DELETES);
        ((IterableAssert)Assertions.assertThat((Iterable)result.addedManifests()).hasSize(1)).allMatch(m -> m.content() == ManifestContent.DELETES);
        this.assertManifestsLocation(result.addedManifests());
        ManifestFile deleteManifest = (ManifestFile)Iterables.getOnlyElement((Iterable)table.currentSnapshot().deleteManifests(table.io()));
        Assertions.assertThat((Integer)deleteManifest.existingFilesCount()).isEqualTo(2);
        Assertions.assertThat((boolean)deleteManifest.hasAddedFiles()).isFalse();
        Assertions.assertThat((boolean)deleteManifest.hasDeletedFiles()).isFalse();
        ManifestFile dataManifest = (ManifestFile)Iterables.getOnlyElement((Iterable)table.currentSnapshot().dataManifests(table.io()));
        Assertions.assertThat((boolean)dataManifest.hasExistingFiles()).isFalse();
        Assertions.assertThat((boolean)dataManifest.hasAddedFiles()).isTrue();
        Assertions.assertThat((boolean)dataManifest.hasDeletedFiles()).isFalse();
        ArrayList expectedRecords = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(4, "DDDDDDDDDD", "DDDD")});
        Assertions.assertThat(this.actualRecords()).isEqualTo((Object)expectedRecords);
    }

    @Test
    public void testRewriteSmallDeleteManifestsPartitionedTable() throws IOException {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThan(1);
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c3").build();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        options.put("commit.manifest-merge.enabled", "false");
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList records = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(1, null, "AAAA"), new ThreeColumnRecord(2, "BBBBBBBBBB", "BBBB"), new ThreeColumnRecord(3, "CCCCCCCCCC", "CCCC"), new ThreeColumnRecord(4, "DDDDDDDDDD", "DDDD"), new ThreeColumnRecord(5, "EEEEEEEEEE", "EEEE")});
        this.writeRecords(records);
        List<Pair<CharSequence, Long>> posDeletes1 = this.generatePosDeletes("c1 = 1");
        Pair<DeleteFile, CharSequenceSet> posDeleteWriteResult1 = this.writePosDeletes(table, (StructLike)TestHelpers.Row.of((Object[])new Object[]{"AAAA"}), posDeletes1);
        table.newRowDelta().addDeletes((DeleteFile)posDeleteWriteResult1.first()).validateDataFilesExist((Iterable)posDeleteWriteResult1.second()).commit();
        List<Pair<CharSequence, Long>> posDeletes2 = this.generatePosDeletes("c1 = 2");
        Pair<DeleteFile, CharSequenceSet> positionDeleteWriteResult2 = this.writePosDeletes(table, (StructLike)TestHelpers.Row.of((Object[])new Object[]{"BBBB"}), posDeletes2);
        table.newRowDelta().addDeletes((DeleteFile)positionDeleteWriteResult2.first()).validateDataFilesExist((Iterable)positionDeleteWriteResult2.second()).commit();
        DeleteFile eqDeleteFile1 = this.writeEqDeletes(table, (StructLike)TestHelpers.Row.of((Object[])new Object[]{"CCCC"}), "c1", 3);
        table.newRowDelta().addDeletes(eqDeleteFile1).commit();
        DeleteFile eqDeleteFile2 = this.writeEqDeletes(table, (StructLike)TestHelpers.Row.of((Object[])new Object[]{"DDDD"}), "c1", 4);
        table.newRowDelta().addDeletes(eqDeleteFile2).commit();
        List originalManifests = table.currentSnapshot().allManifests(table.io());
        Assertions.assertThat((List)originalManifests).hasSize(5);
        List originalDeleteManifests = table.currentSnapshot().deleteManifests(table.io());
        long manifestEntrySizeBytes = this.computeManifestEntrySizeBytes(originalDeleteManifests);
        long targetManifestSizeBytes = (long)(2.1 * (double)manifestEntrySizeBytes);
        table.updateProperties().set("commit.manifest.target-size-bytes", String.valueOf(targetManifestSizeBytes)).commit();
        SparkActions actions = SparkActions.get();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> manifest.content() == ManifestContent.DELETES).option("use-caching", this.useCaching)).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.rewrittenManifests()).hasSize(4)).allMatch(m -> m.content() == ManifestContent.DELETES);
        ((IterableAssert)Assertions.assertThat((Iterable)result.addedManifests()).hasSize(2)).allMatch(m -> m.content() == ManifestContent.DELETES);
        this.assertManifestsLocation(result.addedManifests());
        List deleteManifests = table.currentSnapshot().deleteManifests(table.io());
        Assertions.assertThat((List)deleteManifests).hasSize(2);
        ManifestFile deleteManifest1 = (ManifestFile)deleteManifests.get(0);
        Assertions.assertThat((Integer)deleteManifest1.existingFilesCount()).isEqualTo(2);
        Assertions.assertThat((boolean)deleteManifest1.hasAddedFiles()).isFalse();
        Assertions.assertThat((boolean)deleteManifest1.hasDeletedFiles()).isFalse();
        ManifestFile deleteManifest2 = (ManifestFile)deleteManifests.get(1);
        Assertions.assertThat((Integer)deleteManifest2.existingFilesCount()).isEqualTo(2);
        Assertions.assertThat((boolean)deleteManifest2.hasAddedFiles()).isFalse();
        Assertions.assertThat((boolean)deleteManifest2.hasDeletedFiles()).isFalse();
        ArrayList expectedRecords = Lists.newArrayList((Object[])new ThreeColumnRecord[]{new ThreeColumnRecord(5, "EEEEEEEEEE", "EEEE")});
        Assertions.assertThat(this.actualRecords()).isEqualTo((Object)expectedRecords);
    }

    @Test
    public void testRewriteLargeDeleteManifestsPartitionedTable() throws IOException {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThan(1);
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("c3").build();
        HashMap options = Maps.newHashMap();
        options.put("format-version", String.valueOf(this.formatVersion));
        options.put("compatibility.snapshot-id-inheritance.enabled", this.snapshotIdInheritanceEnabled);
        Table table = TABLES.create(SCHEMA, spec, (Map)options, this.tableLocation);
        ArrayList deleteFiles = Lists.newArrayList();
        for (int fileOrdinal = 0; fileOrdinal < 1000; ++fileOrdinal) {
            DeleteFile deleteFile = this.newDeleteFile(table, "c3=" + fileOrdinal);
            deleteFiles.add(deleteFile);
        }
        RowDelta rowDelta = table.newRowDelta();
        for (DeleteFile deleteFile : deleteFiles) {
            rowDelta.addDeletes(deleteFile);
        }
        rowDelta.commit();
        List originalDeleteManifests = table.currentSnapshot().deleteManifests(table.io());
        ManifestFile originalDeleteManifest = (ManifestFile)Iterables.getOnlyElement((Iterable)originalDeleteManifests);
        table.updateProperties().set("commit.manifest.target-size-bytes", String.valueOf(originalDeleteManifest.length() / 2L)).commit();
        SparkActions actions = SparkActions.get();
        String stagingLocation = this.temp.newFolder().toString();
        RewriteManifests.Result result = ((RewriteManifestsSparkAction)actions.rewriteManifests(table).rewriteIf(manifest -> true).option("use-caching", this.useCaching)).stagingLocation(stagingLocation).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.rewrittenManifests()).hasSize(1)).allMatch(m -> m.content() == ManifestContent.DELETES);
        ((IterableAssert)Assertions.assertThat((Iterable)result.addedManifests()).hasSizeGreaterThanOrEqualTo(2)).allMatch(m -> m.content() == ManifestContent.DELETES);
        this.assertManifestsLocation(result.addedManifests(), stagingLocation);
        List deleteManifests = table.currentSnapshot().deleteManifests(table.io());
        Assertions.assertThat((List)deleteManifests).hasSizeGreaterThanOrEqualTo(2);
    }

    private List<ThreeColumnRecord> actualRecords() {
        return spark.read().format("iceberg").load(this.tableLocation).as(Encoders.bean(ThreeColumnRecord.class)).sort("c1", new String[]{"c2", "c3"}).collectAsList();
    }

    private void writeRecords(List<ThreeColumnRecord> records) {
        Dataset df = spark.createDataFrame(records, ThreeColumnRecord.class);
        this.writeDF((Dataset<Row>)df);
    }

    private void writeDF(Dataset<Row> df) {
        df.select("c1", new String[]{"c2", "c3"}).write().format("iceberg").option("distribution-mode", "none").mode("append").save(this.tableLocation);
    }

    private long computeManifestEntrySizeBytes(List<ManifestFile> manifests) {
        long totalSize = 0L;
        int numEntries = 0;
        for (ManifestFile manifest : manifests) {
            totalSize += manifest.length();
            numEntries += manifest.addedFilesCount() + manifest.existingFilesCount() + manifest.deletedFilesCount();
        }
        return totalSize / (long)numEntries;
    }

    private void assertManifestsLocation(Iterable<ManifestFile> manifests) {
        this.assertManifestsLocation(manifests, null);
    }

    private void assertManifestsLocation(Iterable<ManifestFile> manifests, String stagingLocation) {
        if (this.shouldStageManifests && stagingLocation != null) {
            Assertions.assertThat(manifests).allMatch(manifest -> manifest.path().startsWith(stagingLocation));
        } else {
            Assertions.assertThat(manifests).allMatch(manifest -> manifest.path().startsWith(this.tableLocation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestFile writeManifest(Table table, List<DataFile> files) throws IOException {
        File manifestFile = this.temp.newFile("generated-manifest.avro");
        Assert.assertTrue((boolean)manifestFile.delete());
        OutputFile outputFile = table.io().newOutputFile(manifestFile.getCanonicalPath());
        try (ManifestWriter writer = ManifestFiles.write((int)this.formatVersion, (PartitionSpec)table.spec(), (OutputFile)outputFile, null);){
            for (DataFile file : files) {
                writer.add((ContentFile)file);
            }
        }
        return writer.toManifestFile();
    }

    private DataFile newDataFile(Table table, String partitionPath) {
        return this.newDataFileBuilder(table).withPartitionPath(partitionPath).build();
    }

    private DataFile newDataFile(Table table, StructLike partition) {
        return this.newDataFileBuilder(table).withPartition(partition).build();
    }

    private DataFiles.Builder newDataFileBuilder(Table table) {
        return DataFiles.builder((PartitionSpec)table.spec()).withPath("/path/to/data-" + UUID.randomUUID() + ".parquet").withFileSizeInBytes(10L).withRecordCount(1L);
    }

    private DeleteFile newDeleteFile(Table table, String partitionPath) {
        return FileMetadata.deleteFileBuilder((PartitionSpec)table.spec()).ofPositionDeletes().withPath("/path/to/pos-deletes-" + UUID.randomUUID() + ".parquet").withFileSizeInBytes(5L).withPartitionPath(partitionPath).withRecordCount(1L).build();
    }

    private List<Pair<CharSequence, Long>> generatePosDeletes(String predicate) {
        List rows = spark.read().format("iceberg").load(this.tableLocation).selectExpr(new String[]{"_file", "_pos"}).where(predicate).collectAsList();
        ArrayList deletes = Lists.newArrayList();
        for (Row row : rows) {
            deletes.add(Pair.of((Object)row.getString(0), (Object)row.getLong(1)));
        }
        return deletes;
    }

    private Pair<DeleteFile, CharSequenceSet> writePosDeletes(Table table, List<Pair<CharSequence, Long>> deletes) throws IOException {
        return this.writePosDeletes(table, null, deletes);
    }

    private Pair<DeleteFile, CharSequenceSet> writePosDeletes(Table table, StructLike partition, List<Pair<CharSequence, Long>> deletes) throws IOException {
        OutputFile outputFile = Files.localOutput((File)this.temp.newFile());
        return FileHelpers.writeDeleteFile((Table)table, (OutputFile)outputFile, (StructLike)partition, deletes);
    }

    private DeleteFile writeEqDeletes(Table table, String key, Object ... values) throws IOException {
        return this.writeEqDeletes(table, null, key, values);
    }

    private DeleteFile writeEqDeletes(Table table, StructLike partition, String key, Object ... values) throws IOException {
        ArrayList deletes = Lists.newArrayList();
        Schema deleteSchema = table.schema().select(new String[]{key});
        GenericRecord delete = GenericRecord.create((Schema)deleteSchema);
        for (Object value : values) {
            deletes.add(delete.copy(key, value));
        }
        OutputFile outputFile = Files.localOutput((File)this.temp.newFile());
        return FileHelpers.writeDeleteFile((Table)table, (OutputFile)outputFile, (StructLike)partition, (List)deletes, (Schema)deleteSchema);
    }
}

