/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.actions.SparkActions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestSnapshotTableAction
extends SparkCatalogTestBase {
    private static final String SOURCE_NAME = "spark_catalog.default.source";

    public TestSnapshotTableAction(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
        this.sql("DROP TABLE IF EXISTS %s PURGE", SOURCE_NAME);
    }

    @Test
    public void testSnapshotWithParallelTasks() throws IOException {
        String location = this.temp.newFolder().toURI().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", SOURCE_NAME, location);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", SOURCE_NAME);
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", SOURCE_NAME);
        AtomicInteger snapshotThreadsIndex = new AtomicInteger(0);
        SparkActions.get().snapshotTable(SOURCE_NAME).as(this.tableName).executeWith(Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("table-snapshot-" + snapshotThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        })).execute();
        Assert.assertEquals((long)snapshotThreadsIndex.get(), (long)2L);
    }
}

