/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.RandomUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;

public class RandomData {
    public static final float DEFAULT_NULL_PERCENTAGE = 0.05f;

    private RandomData() {
    }

    public static List<GenericData.Record> generateList(Schema schema, int numRecords, long seed) {
        RandomDataGenerator generator = new RandomDataGenerator(schema, seed, 0.05f);
        ArrayList records = Lists.newArrayListWithExpectedSize((int)numRecords);
        for (int i = 0; i < numRecords; ++i) {
            records.add((GenericData.Record)TypeUtil.visit((Schema)schema, (TypeUtil.CustomOrderSchemaVisitor)generator));
        }
        return records;
    }

    public static Iterable<InternalRow> generateSpark(final Schema schema, final int numRecords, final long seed) {
        return () -> new Iterator<InternalRow>(){
            private final SparkRandomDataGenerator generator;
            private int count;
            {
                this.generator = new SparkRandomDataGenerator(seed);
                this.count = 0;
            }

            @Override
            public boolean hasNext() {
                return this.count < numRecords;
            }

            @Override
            public InternalRow next() {
                if (this.count >= numRecords) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return (InternalRow)TypeUtil.visit((Schema)schema, (TypeUtil.CustomOrderSchemaVisitor)this.generator);
            }
        };
    }

    public static Iterable<GenericData.Record> generate(Schema schema, int numRecords, long seed) {
        return RandomData.newIterable(() -> new RandomDataGenerator(schema, seed, 0.05f), schema, numRecords);
    }

    public static Iterable<GenericData.Record> generate(Schema schema, int numRecords, long seed, float nullPercentage) {
        return RandomData.newIterable(() -> new RandomDataGenerator(schema, seed, nullPercentage), schema, numRecords);
    }

    public static Iterable<GenericData.Record> generateFallbackData(Schema schema, int numRecords, long seed, long numDictRecords) {
        return RandomData.newIterable(() -> new FallbackDataGenerator(schema, seed, numDictRecords), schema, numRecords);
    }

    public static Iterable<GenericData.Record> generateDictionaryEncodableData(Schema schema, int numRecords, long seed, float nullPercentage) {
        return RandomData.newIterable(() -> new DictionaryEncodedDataGenerator(schema, seed, nullPercentage), schema, numRecords);
    }

    private static Iterable<GenericData.Record> newIterable(final Supplier<RandomDataGenerator> newGenerator, final Schema schema, final int numRecords) {
        return () -> new Iterator<GenericData.Record>(){
            private int count = 0;
            private final RandomDataGenerator generator = (RandomDataGenerator)((Object)newGenerator.get());

            @Override
            public boolean hasNext() {
                return this.count < numRecords;
            }

            @Override
            public GenericData.Record next() {
                if (this.count >= numRecords) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return (GenericData.Record)TypeUtil.visit((Schema)schema, (TypeUtil.CustomOrderSchemaVisitor)this.generator);
            }
        };
    }

    private static class FallbackDataGenerator
    extends RandomDataGenerator {
        private final long dictionaryEncodedRows;
        private long rowCount = 0L;

        private FallbackDataGenerator(Schema schema, long seed, long numDictionaryEncoded) {
            super(schema, seed, 0.05f);
            this.dictionaryEncodedRows = numDictionaryEncoded;
        }

        @Override
        protected Object randomValue(Type.PrimitiveType primitive, Random rand) {
            ++this.rowCount;
            if (this.rowCount > this.dictionaryEncodedRows) {
                return RandomUtil.generatePrimitive((Type.PrimitiveType)primitive, (Random)rand);
            }
            return RandomUtil.generateDictionaryEncodablePrimitive((Type.PrimitiveType)primitive, (Random)rand);
        }
    }

    private static class DictionaryEncodedDataGenerator
    extends RandomDataGenerator {
        private DictionaryEncodedDataGenerator(Schema schema, long seed, float nullPercentage) {
            super(schema, seed, nullPercentage);
        }

        @Override
        protected Object randomValue(Type.PrimitiveType primitive, Random random) {
            return RandomUtil.generateDictionaryEncodablePrimitive((Type.PrimitiveType)primitive, (Random)random);
        }
    }

    private static class SparkRandomDataGenerator
    extends TypeUtil.CustomOrderSchemaVisitor<Object> {
        private final Random random;

        private SparkRandomDataGenerator(long seed) {
            this.random = new Random(seed);
        }

        public InternalRow schema(Schema schema, Supplier<Object> structResult) {
            return (InternalRow)structResult.get();
        }

        public InternalRow struct(Types.StructType struct, Iterable<Object> fieldResults) {
            ArrayList values = Lists.newArrayList(fieldResults);
            GenericInternalRow row = new GenericInternalRow(values.size());
            for (int i = 0; i < values.size(); ++i) {
                row.update(i, values.get(i));
            }
            return row;
        }

        public Object field(Types.NestedField field, Supplier<Object> fieldResult) {
            if (field.isOptional() && this.random.nextInt(20) == 1) {
                return null;
            }
            return fieldResult.get();
        }

        public GenericArrayData list(Types.ListType list, Supplier<Object> elementResult) {
            int numElements = this.random.nextInt(20);
            Object[] arr = new Object[numElements];
            GenericArrayData result = new GenericArrayData(arr);
            for (int i = 0; i < numElements; ++i) {
                arr[i] = list.isElementOptional() && this.random.nextInt(20) == 1 ? null : elementResult.get();
            }
            return result;
        }

        public Object map(Types.MapType map, Supplier<Object> keyResult, Supplier<Object> valueResult) {
            int numEntries = this.random.nextInt(20);
            Object[] keysArr = new Object[numEntries];
            Object[] valuesArr = new Object[numEntries];
            GenericArrayData keys = new GenericArrayData(keysArr);
            GenericArrayData values = new GenericArrayData(valuesArr);
            ArrayBasedMapData result = new ArrayBasedMapData((ArrayData)keys, (ArrayData)values);
            HashSet keySet = Sets.newHashSet();
            for (int i = 0; i < numEntries; ++i) {
                Object key = keyResult.get();
                while (keySet.contains(key)) {
                    key = keyResult.get();
                }
                keySet.add(key);
                keysArr[i] = key;
                valuesArr[i] = map.isValueOptional() && this.random.nextInt(20) == 1 ? null : valueResult.get();
            }
            return result;
        }

        public Object primitive(Type.PrimitiveType primitive) {
            Object obj = RandomUtil.generatePrimitive((Type.PrimitiveType)primitive, (Random)this.random);
            switch (primitive.typeId()) {
                case STRING: {
                    return UTF8String.fromString((String)((String)obj));
                }
                case DECIMAL: {
                    return Decimal.apply((BigDecimal)((BigDecimal)obj));
                }
                case UUID: {
                    return UTF8String.fromString((String)UUID.nameUUIDFromBytes((byte[])obj).toString());
                }
            }
            return obj;
        }
    }

    private static class RandomDataGenerator
    extends TypeUtil.CustomOrderSchemaVisitor<Object> {
        private final Map<Type, org.apache.avro.Schema> typeToSchema;
        private final Random random;
        private final float nullPercentage;

        private RandomDataGenerator(Schema schema, long seed, float nullPercentage) {
            Preconditions.checkArgument((0.0f <= nullPercentage && nullPercentage <= 1.0f ? 1 : 0) != 0, (Object)"Percentage needs to be in the range (0.0, 1.0)");
            this.nullPercentage = nullPercentage;
            this.typeToSchema = AvroSchemaUtil.convertTypes((Types.StructType)schema.asStruct(), (String)"test");
            this.random = new Random(seed);
        }

        public GenericData.Record schema(Schema schema, Supplier<Object> structResult) {
            return (GenericData.Record)structResult.get();
        }

        public GenericData.Record struct(Types.StructType struct, Iterable<Object> fieldResults) {
            GenericData.Record rec = new GenericData.Record(this.typeToSchema.get(struct));
            ArrayList values = Lists.newArrayList(fieldResults);
            for (int i = 0; i < values.size(); ++i) {
                rec.put(i, values.get(i));
            }
            return rec;
        }

        public Object field(Types.NestedField field, Supplier<Object> fieldResult) {
            if (field.isOptional() && this.isNull()) {
                return null;
            }
            return fieldResult.get();
        }

        private boolean isNull() {
            return this.random.nextFloat() < this.nullPercentage;
        }

        public Object list(Types.ListType list, Supplier<Object> elementResult) {
            int numElements = this.random.nextInt(20);
            ArrayList result = Lists.newArrayListWithExpectedSize((int)numElements);
            for (int i = 0; i < numElements; ++i) {
                if (list.isElementOptional() && this.isNull()) {
                    result.add(null);
                    continue;
                }
                result.add(elementResult.get());
            }
            return result;
        }

        public Object map(Types.MapType map, Supplier<Object> keyResult, Supplier<Object> valueResult) {
            int numEntries = this.random.nextInt(20);
            LinkedHashMap result = Maps.newLinkedHashMap();
            HashSet keySet = Sets.newHashSet();
            for (int i = 0; i < numEntries; ++i) {
                Object key = keyResult.get();
                while (keySet.contains(key)) {
                    key = keyResult.get();
                }
                keySet.add(key);
                if (map.isValueOptional() && this.isNull()) {
                    result.put(key, null);
                    continue;
                }
                result.put(key, valueResult.get());
            }
            return result;
        }

        public Object primitive(Type.PrimitiveType primitive) {
            Object result = this.randomValue(primitive, this.random);
            switch (primitive.typeId()) {
                case FIXED: {
                    return new GenericData.Fixed(this.typeToSchema.get(primitive), (byte[])result);
                }
                case BINARY: {
                    return ByteBuffer.wrap((byte[])result);
                }
                case UUID: {
                    return UUID.nameUUIDFromBytes((byte[])result);
                }
            }
            return result;
        }

        protected Object randomValue(Type.PrimitiveType primitive, Random rand) {
            return RandomUtil.generatePrimitive((Type.PrimitiveType)primitive, (Random)this.random);
        }
    }
}

