/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.File;
import java.io.IOException;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.SparkOrcWriter;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.catalyst.InternalRow;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestOrcWrite {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});

    @Test
    public void splitOffsets() throws IOException {
        File testFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)testFile.delete());
        Iterable<InternalRow> rows = RandomData.generateSpark(SCHEMA, 1, 0L);
        FileAppender writer = ORC.write((OutputFile)Files.localOutput((File)testFile)).createWriterFunc(SparkOrcWriter::new).schema(SCHEMA).build();
        writer.addAll(rows);
        writer.close();
        Assert.assertNotNull((String)"Split offsets not present", (Object)writer.splitOffsets());
    }
}

