/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.data.SparkAvroReader;
import org.apache.spark.sql.catalyst.InternalRow;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSparkAvroEnums {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void writeAndValidateEnums() throws IOException {
        ArrayList rows;
        org.apache.avro.Schema avroSchema = (org.apache.avro.Schema)((SchemaBuilder.EnumDefault)SchemaBuilder.record((String)"root").fields().name("enumCol").type().nullable().enumeration("testEnum").symbols(new String[]{"SYMB1", "SYMB2"})).enumDefault("SYMB2").endRecord();
        org.apache.avro.Schema enumSchema = (org.apache.avro.Schema)avroSchema.getField("enumCol").schema().getTypes().get(0);
        GenericData.Record enumRecord1 = new GenericData.Record(avroSchema);
        enumRecord1.put("enumCol", (Object)new GenericData.EnumSymbol(enumSchema, "SYMB1"));
        GenericData.Record enumRecord2 = new GenericData.Record(avroSchema);
        enumRecord2.put("enumCol", (Object)new GenericData.EnumSymbol(enumSchema, "SYMB2"));
        GenericData.Record enumRecord3 = new GenericData.Record(avroSchema);
        ImmutableList expected = ImmutableList.of((Object)enumRecord1, (Object)enumRecord2, (Object)enumRecord3);
        File testFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)testFile.delete());
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
            writer.create(avroSchema, testFile);
            writer.append((Object)enumRecord1);
            writer.append((Object)enumRecord2);
            writer.append((Object)enumRecord3);
        }
        Schema schema = new Schema(AvroSchemaUtil.convert((org.apache.avro.Schema)avroSchema).asStructType().fields());
        try (AvroIterable reader = Avro.read((InputFile)Files.localInput((File)testFile)).createReaderFunc(SparkAvroReader::new).project(schema).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        for (int i = 0; i < expected.size(); ++i) {
            String expectedEnumString = ((GenericData.Record)expected.get(i)).get("enumCol") == null ? null : ((GenericData.Record)expected.get(i)).get("enumCol").toString();
            String sparkString = ((InternalRow)rows.get(i)).getUTF8String(0) == null ? null : ((InternalRow)rows.get(i)).getUTF8String(0).toString();
            Assert.assertEquals((Object)expectedEnumString, sparkString);
        }
    }
}

