/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.data.AvroDataTest;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.SparkAvroReader;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.spark.sql.catalyst.InternalRow;
import org.junit.Assert;

public class TestSparkAvroReader
extends AvroDataTest {
    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        ArrayList rows;
        List<GenericData.Record> expected = RandomData.generateList(schema, 100, 0L);
        File testFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)testFile.delete());
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((File)testFile)).schema(schema).named("test").build();){
            for (GenericData.Record rec : expected) {
                writer.add((Object)rec);
            }
        }
        try (AvroIterable reader = Avro.read((InputFile)Files.localInput((File)testFile)).createReaderFunc(SparkAvroReader::new).project(schema).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        for (int i = 0; i < expected.size(); ++i) {
            TestHelpers.assertEqualsUnsafe(schema.asStruct(), expected.get(i), (InternalRow)rows.get(i));
        }
    }
}

