/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Files;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.data.SparkOrcReader;
import org.apache.iceberg.spark.data.SparkOrcWriter;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.data.vectorized.VectorizedSparkOrcReaders;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSparkOrcReadMetadataColumns {
    private static final Schema DATA_SCHEMA;
    private static final Schema PROJECTION_SCHEMA;
    private static final int NUM_ROWS = 1000;
    private static final List<InternalRow> DATA_ROWS;
    private static final List<InternalRow> EXPECTED_ROWS;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private boolean vectorized;
    private File testFile;

    @Parameterized.Parameters(name="vectorized = {0}")
    public static Object[] parameters() {
        return new Object[]{false, true};
    }

    public TestSparkOrcReadMetadataColumns(boolean vectorized) {
        this.vectorized = vectorized;
    }

    @Before
    public void writeFile() throws IOException {
        this.testFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)this.testFile.delete());
        try (FileAppender writer = ORC.write((OutputFile)Files.localOutput((File)this.testFile)).createWriterFunc(SparkOrcWriter::new).schema(DATA_SCHEMA).set("iceberg.orc.vectorbatch.size", "100").set(OrcConf.ROWS_BETWEEN_CHECKS.getAttribute(), "100").set(OrcConf.STRIPE_SIZE.getAttribute(), "1").build();){
            writer.addAll(DATA_ROWS);
        }
    }

    @Test
    public void testReadRowNumbers() throws IOException {
        this.readAndValidate(null, null, null, EXPECTED_ROWS);
    }

    @Test
    public void testReadRowNumbersWithFilter() throws IOException {
        this.readAndValidate((Expression)Expressions.greaterThanOrEqual((String)"id", (Object)500), null, null, EXPECTED_ROWS.subList(500, 1000));
    }

    @Test
    public void testReadRowNumbersWithSplits() throws IOException {
        Reader reader;
        try {
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)new Configuration()).useUTCTimestamp(true);
            reader = OrcFile.createReader((Path)new Path(this.testFile.toString()), (OrcFile.ReaderOptions)readerOptions);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to open file: %s", new Object[]{this.testFile});
        }
        List splitOffsets = reader.getStripes().stream().map(StripeInformation::getOffset).collect(Collectors.toList());
        List splitLengths = reader.getStripes().stream().map(StripeInformation::getLength).collect(Collectors.toList());
        for (int i = 0; i < 10; ++i) {
            this.readAndValidate(null, (Long)splitOffsets.get(i), (Long)splitLengths.get(i), EXPECTED_ROWS.subList(i * 100, (i + 1) * 100));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndValidate(Expression filter, Long splitStart, Long splitLength, List<InternalRow> expected) throws IOException {
        Schema projectionWithoutMetadataFields = TypeUtil.selectNot((Schema)PROJECTION_SCHEMA, (Set)MetadataColumns.metadataFieldIds());
        try (CloseableIterable<InternalRow> reader = null;){
            ORC.ReadBuilder builder = ORC.read((InputFile)Files.localInput((File)this.testFile)).project(projectionWithoutMetadataFields);
            builder = this.vectorized ? builder.createBatchedReaderFunc(readOrcSchema -> VectorizedSparkOrcReaders.buildReader((Schema)PROJECTION_SCHEMA, (TypeDescription)readOrcSchema, (Map)ImmutableMap.of())) : builder.createReaderFunc(readOrcSchema -> new SparkOrcReader(PROJECTION_SCHEMA, readOrcSchema));
            if (filter != null) {
                builder = builder.filter(filter);
            }
            if (splitStart != null && splitLength != null) {
                builder = builder.split(splitStart.longValue(), splitLength.longValue());
            }
            reader = this.vectorized ? this.batchesToRows((CloseableIterable<ColumnarBatch>)builder.build()) : builder.build();
            CloseableIterator actualRows = reader.iterator();
            Iterator<InternalRow> expectedRows = expected.iterator();
            while (expectedRows.hasNext()) {
                Assert.assertTrue((String)"Should have expected number of rows", (boolean)actualRows.hasNext());
                TestHelpers.assertEquals(PROJECTION_SCHEMA, expectedRows.next(), actualRows.next());
            }
            Assert.assertFalse((String)"Should not have extra rows", (boolean)actualRows.hasNext());
        }
    }

    private CloseableIterable<InternalRow> batchesToRows(CloseableIterable<ColumnarBatch> batches) {
        return CloseableIterable.combine((Iterable)Iterables.concat((Iterable)Iterables.transform(batches, b -> () -> ((ColumnarBatch)b).rowIterator())), batches);
    }

    static {
        GenericInternalRow row;
        long i;
        DATA_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)101, (String)"data", (Type)Types.StringType.get())});
        PROJECTION_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)101, (String)"data", (Type)Types.StringType.get()), MetadataColumns.ROW_POSITION, MetadataColumns.IS_DELETED});
        DATA_ROWS = Lists.newArrayListWithCapacity((int)1000);
        for (i = 0L; i < 1000L; ++i) {
            row = new GenericInternalRow(DATA_SCHEMA.columns().size());
            row.update(0, (Object)i);
            row.update(1, (Object)UTF8String.fromString((String)("str" + i)));
            DATA_ROWS.add((InternalRow)row);
        }
        EXPECTED_ROWS = Lists.newArrayListWithCapacity((int)1000);
        for (i = 0L; i < 1000L; ++i) {
            row = new GenericInternalRow(PROJECTION_SCHEMA.columns().size());
            row.update(0, (Object)i);
            row.update(1, (Object)UTF8String.fromString((String)("str" + i)));
            row.update(2, (Object)i);
            row.update(3, (Object)false);
            EXPECTED_ROWS.add((InternalRow)row);
        }
    }
}

