/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.SparkParquetReaders;
import org.apache.iceberg.spark.data.SparkParquetWriters;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSparkParquetWriter {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static final Schema COMPLEX_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"roots", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"lime", (Type)Types.ListType.ofRequired((int)4, (Type)Types.DoubleType.get())), Types.NestedField.required((int)5, (String)"strict", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)9, (String)"tangerine", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"hopeful", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)7, (String)"steel", (Type)Types.FloatType.get()), Types.NestedField.required((int)8, (String)"lantern", (Type)Types.DateType.get())})), Types.NestedField.optional((int)10, (String)"vehement", (Type)Types.LongType.get())})), Types.NestedField.optional((int)11, (String)"metamorphosis", (Type)Types.MapType.ofRequired((int)12, (int)13, (Type)Types.StringType.get(), (Type)Types.TimestampType.withZone())), Types.NestedField.required((int)14, (String)"winter", (Type)Types.ListType.ofOptional((int)15, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)16, (String)"beet", (Type)Types.DoubleType.get()), Types.NestedField.required((int)17, (String)"stamp", (Type)Types.FloatType.get()), Types.NestedField.optional((int)18, (String)"wheeze", (Type)Types.StringType.get())}))), Types.NestedField.optional((int)19, (String)"renovate", (Type)Types.MapType.ofRequired((int)20, (int)21, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"jumpy", (Type)Types.DoubleType.get()), Types.NestedField.required((int)23, (String)"koala", (Type)Types.UUIDType.get()), Types.NestedField.required((int)24, (String)"couch rope", (Type)Types.IntegerType.get())}))), Types.NestedField.optional((int)2, (String)"slide", (Type)Types.StringType.get())});

    @Test
    public void testCorrectness() throws IOException {
        int numRows = 50000;
        Iterable<InternalRow> records = RandomData.generateSpark(COMPLEX_SCHEMA, numRows, 19981L);
        File testFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)testFile.delete());
        try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)testFile)).schema(COMPLEX_SCHEMA).createWriterFunc(msgType -> SparkParquetWriters.buildWriter((StructType)SparkSchemaUtil.convert((Schema)COMPLEX_SCHEMA), (MessageType)msgType)).build();){
            writer.addAll(records);
        }
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(COMPLEX_SCHEMA).createReaderFunc(type -> SparkParquetReaders.buildReader((Schema)COMPLEX_SCHEMA, (MessageType)type)).build();){
            Iterator<InternalRow> expected = records.iterator();
            CloseableIterator rows = reader.iterator();
            for (int i = 0; i < numRows; ++i) {
                Assert.assertTrue((String)"Should have expected number of rows", (boolean)rows.hasNext());
                TestHelpers.assertEquals(COMPLEX_SCHEMA, expected.next(), rows.next());
            }
            Assert.assertFalse((String)"Should not have extra rows", (boolean)rows.hasNext());
        }
    }
}

