/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.parquet.vectorized;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Function;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.data.AvroDataTest;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.data.vectorized.VectorizedSparkParquetReaders;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class TestParquetVectorizedReads
extends AvroDataTest {
    private static final int NUM_ROWS = 200000;
    static final int BATCH_SIZE = 10000;
    static final Function<GenericData.Record, GenericData.Record> IDENTITY = record -> record;

    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        this.writeAndValidate(schema, this.getNumRows(), 0L, 0.05f, true);
    }

    private void writeAndValidate(Schema schema, int numRecords, long seed, float nullPercentage, boolean reuseContainers) throws IOException {
        this.writeAndValidate(schema, numRecords, seed, nullPercentage, reuseContainers, 10000, IDENTITY);
    }

    private void writeAndValidate(Schema schema, int numRecords, long seed, float nullPercentage, boolean reuseContainers, int batchSize, Function<GenericData.Record, GenericData.Record> transform) throws IOException {
        Assume.assumeTrue((String)"Parquet Avro cannot write non-string map keys", (null == TypeUtil.find((Schema)schema, type -> type.isMapType() && type.asMapType().keyType() != Types.StringType.get()) ? 1 : 0) != 0);
        Iterable<GenericData.Record> expected = this.generateData(schema, numRecords, seed, nullPercentage, transform);
        File testFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)testFile.delete());
        try (FileAppender<GenericData.Record> writer = this.getParquetWriter(schema, testFile);){
            writer.addAll(expected);
        }
        this.assertRecordsMatch(schema, numRecords, expected, testFile, reuseContainers, batchSize);
    }

    protected int getNumRows() {
        return 200000;
    }

    Iterable<GenericData.Record> generateData(Schema schema, int numRecords, long seed, float nullPercentage, Function<GenericData.Record, GenericData.Record> transform) {
        Iterable data = RandomData.generate(schema, numRecords, seed, nullPercentage);
        return transform == IDENTITY ? data : Iterables.transform(data, transform);
    }

    FileAppender<GenericData.Record> getParquetWriter(Schema schema, File testFile) throws IOException {
        return Parquet.write((OutputFile)Files.localOutput((File)testFile)).schema(schema).named("test").build();
    }

    FileAppender<GenericData.Record> getParquetV2Writer(Schema schema, File testFile) throws IOException {
        return Parquet.write((OutputFile)Files.localOutput((File)testFile)).schema(schema).named("test").writerVersion(ParquetProperties.WriterVersion.PARQUET_2_0).build();
    }

    void assertRecordsMatch(Schema schema, int expectedSize, Iterable<GenericData.Record> expected, File testFile, boolean reuseContainers, int batchSize) throws IOException {
        Parquet.ReadBuilder readBuilder = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).recordsPerBatch(batchSize).createBatchedReaderFunc(type -> VectorizedSparkParquetReaders.buildReader((Schema)schema, (MessageType)type, (Map)Maps.newHashMap(), null));
        if (reuseContainers) {
            readBuilder.reuseContainers();
        }
        try (CloseableIterable batchReader = readBuilder.build();){
            Iterator<GenericData.Record> expectedIter = expected.iterator();
            CloseableIterator batches = batchReader.iterator();
            int numRowsRead = 0;
            while (batches.hasNext()) {
                ColumnarBatch batch = (ColumnarBatch)batches.next();
                numRowsRead += batch.numRows();
                TestHelpers.assertEqualsBatch(schema.asStruct(), expectedIter, batch);
            }
            Assert.assertEquals((long)expectedSize, (long)numRowsRead);
        }
    }

    @Override
    @Test
    @Ignore
    public void testArray() {
    }

    @Override
    @Test
    @Ignore
    public void testArrayOfStructs() {
    }

    @Override
    @Test
    @Ignore
    public void testMap() {
    }

    @Override
    @Test
    @Ignore
    public void testNumericMapKey() {
    }

    @Override
    @Test
    @Ignore
    public void testComplexMapKey() {
    }

    @Override
    @Test
    @Ignore
    public void testMapOfStructs() {
    }

    @Override
    @Test
    @Ignore
    public void testMixedTypes() {
    }

    @Override
    @Test
    public void testNestedStruct() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VectorizedSparkParquetReaders.buildReader((Schema)TypeUtil.assignIncreasingFreshIds((Schema)new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"struct", (Type)SUPPORTED_PRIMITIVES)})), (MessageType)new MessageType("struct", new org.apache.parquet.schema.Type[]{new GroupType(Type.Repetition.OPTIONAL, "struct", new org.apache.parquet.schema.Type[0]).withId(1)}), (Map)Maps.newHashMap(), null)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Vectorized reads are not supported yet for struct fields");
    }

    @Test
    public void testMostlyNullsForOptionalFields() throws IOException {
        this.writeAndValidate(TypeUtil.assignIncreasingFreshIds((Schema)new Schema(SUPPORTED_PRIMITIVES.fields())), this.getNumRows(), 0L, 0.99f, true);
    }

    @Test
    public void testSettingArrowValidityVector() throws IOException {
        this.writeAndValidate(new Schema(Lists.transform((List)SUPPORTED_PRIMITIVES.fields(), Types.NestedField::asOptional)), this.getNumRows(), 0L, 0.05f, true);
    }

    @Test
    public void testVectorizedReadsWithNewContainers() throws IOException {
        this.writeAndValidate(TypeUtil.assignIncreasingFreshIds((Schema)new Schema(SUPPORTED_PRIMITIVES.fields())), this.getNumRows(), 0L, 0.05f, false);
    }

    @Test
    public void testVectorizedReadsWithReallocatedArrowBuffers() throws IOException {
        this.writeAndValidate(new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{SUPPORTED_PRIMITIVES.field("id"), SUPPORTED_PRIMITIVES.field("data")})), 10, 0L, 0.05f, true, 2, (Function<GenericData.Record, GenericData.Record>)((Function)record -> {
            if (record.get("data") != null) {
                record.put("data", (Object)Strings.padEnd((String)((String)record.get("data")), (int)512, (char)'a'));
            } else {
                record.put("data", (Object)Strings.padEnd((String)"", (int)512, (char)'a'));
            }
            return record;
        }));
    }

    @Test
    public void testReadsForTypePromotedColumns() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)101, (String)"int_data", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)102, (String)"float_data", (Type)Types.FloatType.get()), Types.NestedField.optional((int)103, (String)"decimal_data", (Type)Types.DecimalType.of((int)10, (int)5))});
        File dataFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)dataFile.delete());
        Iterable<GenericData.Record> data = this.generateData(writeSchema, 30000, 0L, 0.05f, IDENTITY);
        try (FileAppender<GenericData.Record> writer = this.getParquetWriter(writeSchema, dataFile);){
            writer.addAll(data);
        }
        Schema readSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)101, (String)"int_data", (Type)Types.LongType.get()), Types.NestedField.optional((int)102, (String)"float_data", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)103, (String)"decimal_data", (Type)Types.DecimalType.of((int)25, (int)5))});
        this.assertRecordsMatch(readSchema, 30000, data, dataFile, false, 10000);
    }

    @Test
    public void testSupportedReadsForParquetV2() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)102, (String)"float_data", (Type)Types.FloatType.get()), Types.NestedField.optional((int)103, (String)"double_data", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)104, (String)"decimal_data", (Type)Types.DecimalType.of((int)25, (int)5))});
        File dataFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)dataFile.delete());
        Iterable<GenericData.Record> data = this.generateData(schema, 30000, 0L, 0.05f, IDENTITY);
        try (FileAppender<GenericData.Record> writer = this.getParquetV2Writer(schema, dataFile);){
            writer.addAll(data);
        }
        this.assertRecordsMatch(schema, 30000, data, dataFile, false, 10000);
    }

    @Test
    public void testUnsupportedReadsForParquetV2() throws Exception {
        Schema schema = new Schema(SUPPORTED_PRIMITIVES.fields());
        File dataFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)dataFile.delete());
        Iterable<GenericData.Record> data = this.generateData(schema, 30000, 0L, 0.05f, IDENTITY);
        try (FileAppender<GenericData.Record> writer = this.getParquetV2Writer(schema, dataFile);){
            writer.addAll(data);
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertRecordsMatch(schema, 30000, data, dataFile, false, 10000)).isInstanceOf(UnsupportedOperationException.class)).hasMessageStartingWith("Cannot support vectorized reads for column").hasMessageEndingWith("Disable vectorized reads to read this table/file");
    }
}

