/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.functions;

import org.apache.iceberg.spark.functions.BucketFunction;
import org.apache.iceberg.spark.functions.DaysFunction;
import org.apache.iceberg.spark.functions.HoursFunction;
import org.apache.iceberg.spark.functions.MonthsFunction;
import org.apache.iceberg.spark.functions.SparkFunctions;
import org.apache.iceberg.spark.functions.TruncateFunction;
import org.apache.iceberg.spark.functions.YearsFunction;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestSparkFunctions {
    @Test
    public void testBuildYearsFunctionFromClass() {
        YearsFunction expected = new YearsFunction();
        YearsFunction.DateToYearsFunction dateToYearsFunc = new YearsFunction.DateToYearsFunction();
        this.checkBuildFunc((ScalarFunction<?>)dateToYearsFunc, (UnboundFunction)expected);
        YearsFunction.TimestampToYearsFunction tsToYearsFunc = new YearsFunction.TimestampToYearsFunction();
        this.checkBuildFunc((ScalarFunction<?>)tsToYearsFunc, (UnboundFunction)expected);
        YearsFunction.TimestampNtzToYearsFunction tsNtzToYearsFunc = new YearsFunction.TimestampNtzToYearsFunction();
        this.checkBuildFunc((ScalarFunction<?>)tsNtzToYearsFunc, (UnboundFunction)expected);
    }

    @Test
    public void testBuildMonthsFunctionFromClass() {
        MonthsFunction expected = new MonthsFunction();
        MonthsFunction.DateToMonthsFunction dateToMonthsFunc = new MonthsFunction.DateToMonthsFunction();
        this.checkBuildFunc((ScalarFunction<?>)dateToMonthsFunc, (UnboundFunction)expected);
        MonthsFunction.TimestampToMonthsFunction tsToMonthsFunc = new MonthsFunction.TimestampToMonthsFunction();
        this.checkBuildFunc((ScalarFunction<?>)tsToMonthsFunc, (UnboundFunction)expected);
        MonthsFunction.TimestampNtzToMonthsFunction tsNtzToMonthsFunc = new MonthsFunction.TimestampNtzToMonthsFunction();
        this.checkBuildFunc((ScalarFunction<?>)tsNtzToMonthsFunc, (UnboundFunction)expected);
    }

    @Test
    public void testBuildDaysFunctionFromClass() {
        DaysFunction expected = new DaysFunction();
        DaysFunction.DateToDaysFunction dateToDaysFunc = new DaysFunction.DateToDaysFunction();
        this.checkBuildFunc((ScalarFunction<?>)dateToDaysFunc, (UnboundFunction)expected);
        DaysFunction.TimestampToDaysFunction tsToDaysFunc = new DaysFunction.TimestampToDaysFunction();
        this.checkBuildFunc((ScalarFunction<?>)tsToDaysFunc, (UnboundFunction)expected);
        DaysFunction.TimestampNtzToDaysFunction tsNtzToDaysFunc = new DaysFunction.TimestampNtzToDaysFunction();
        this.checkBuildFunc((ScalarFunction<?>)tsNtzToDaysFunc, (UnboundFunction)expected);
    }

    @Test
    public void testBuildHoursFunctionFromClass() {
        HoursFunction expected = new HoursFunction();
        HoursFunction.TimestampToHoursFunction tsToHoursFunc = new HoursFunction.TimestampToHoursFunction();
        this.checkBuildFunc((ScalarFunction<?>)tsToHoursFunc, (UnboundFunction)expected);
        HoursFunction.TimestampNtzToHoursFunction tsNtzToHoursFunc = new HoursFunction.TimestampNtzToHoursFunction();
        this.checkBuildFunc((ScalarFunction<?>)tsNtzToHoursFunc, (UnboundFunction)expected);
    }

    @Test
    public void testBuildBucketFunctionFromClass() {
        BucketFunction expected = new BucketFunction();
        BucketFunction.BucketInt bucketDateFunc = new BucketFunction.BucketInt(DataTypes.DateType);
        this.checkBuildFunc((ScalarFunction<?>)bucketDateFunc, (UnboundFunction)expected);
        BucketFunction.BucketInt bucketIntFunc = new BucketFunction.BucketInt(DataTypes.IntegerType);
        this.checkBuildFunc((ScalarFunction<?>)bucketIntFunc, (UnboundFunction)expected);
        BucketFunction.BucketLong bucketLongFunc = new BucketFunction.BucketLong(DataTypes.LongType);
        this.checkBuildFunc((ScalarFunction<?>)bucketLongFunc, (UnboundFunction)expected);
        BucketFunction.BucketLong bucketTsFunc = new BucketFunction.BucketLong(DataTypes.TimestampType);
        this.checkBuildFunc((ScalarFunction<?>)bucketTsFunc, (UnboundFunction)expected);
        BucketFunction.BucketLong bucketTsNtzFunc = new BucketFunction.BucketLong(DataTypes.TimestampNTZType);
        this.checkBuildFunc((ScalarFunction<?>)bucketTsNtzFunc, (UnboundFunction)expected);
        BucketFunction.BucketDecimal bucketDecimalFunc = new BucketFunction.BucketDecimal((DataType)new DecimalType());
        this.checkBuildFunc((ScalarFunction<?>)bucketDecimalFunc, (UnboundFunction)expected);
        BucketFunction.BucketString bucketStringFunc = new BucketFunction.BucketString();
        this.checkBuildFunc((ScalarFunction<?>)bucketStringFunc, (UnboundFunction)expected);
        BucketFunction.BucketBinary bucketBinary = new BucketFunction.BucketBinary();
        this.checkBuildFunc((ScalarFunction<?>)bucketBinary, (UnboundFunction)expected);
    }

    @Test
    public void testBuildTruncateFunctionFromClass() {
        TruncateFunction expected = new TruncateFunction();
        TruncateFunction.TruncateTinyInt truncateTinyIntFunc = new TruncateFunction.TruncateTinyInt();
        this.checkBuildFunc((ScalarFunction<?>)truncateTinyIntFunc, (UnboundFunction)expected);
        TruncateFunction.TruncateSmallInt truncateSmallIntFunc = new TruncateFunction.TruncateSmallInt();
        this.checkBuildFunc((ScalarFunction<?>)truncateSmallIntFunc, (UnboundFunction)expected);
        TruncateFunction.TruncateInt truncateIntFunc = new TruncateFunction.TruncateInt();
        this.checkBuildFunc((ScalarFunction<?>)truncateIntFunc, (UnboundFunction)expected);
        TruncateFunction.TruncateBigInt truncateBigIntFunc = new TruncateFunction.TruncateBigInt();
        this.checkBuildFunc((ScalarFunction<?>)truncateBigIntFunc, (UnboundFunction)expected);
        TruncateFunction.TruncateDecimal truncateDecimalFunc = new TruncateFunction.TruncateDecimal(10, 9);
        this.checkBuildFunc((ScalarFunction<?>)truncateDecimalFunc, (UnboundFunction)expected);
        TruncateFunction.TruncateString truncateStringFunc = new TruncateFunction.TruncateString();
        this.checkBuildFunc((ScalarFunction<?>)truncateStringFunc, (UnboundFunction)expected);
        TruncateFunction.TruncateBinary truncateBinaryFunc = new TruncateFunction.TruncateBinary();
        this.checkBuildFunc((ScalarFunction<?>)truncateBinaryFunc, (UnboundFunction)expected);
    }

    private void checkBuildFunc(ScalarFunction<?> function, UnboundFunction expected) {
        UnboundFunction actual = SparkFunctions.loadFunctionByClass(function.getClass());
        Assertions.assertThat((Object)actual).isNotNull();
        Assertions.assertThat((String)actual.name()).isEqualTo(expected.name());
        Assertions.assertThat((String)actual.description()).isEqualTo(expected.description());
    }
}

