/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestDataFrameWriterV2Coercion
extends SparkTestBaseWithCatalog {
    private final FileFormat format;
    private final String dataType;

    public TestDataFrameWriterV2Coercion(FileFormat format, String dataType) {
        this.format = format;
        this.dataType = dataType;
    }

    @Parameterized.Parameters(name="format = {0}, dataType = {1}")
    public static Object[][] parameters() {
        return new Object[][]{{FileFormat.AVRO, "byte"}, {FileFormat.ORC, "byte"}, {FileFormat.PARQUET, "byte"}, {FileFormat.AVRO, "short"}, {FileFormat.ORC, "short"}, {FileFormat.PARQUET, "short"}};
    }

    @Test
    public void testByteAndShortCoercion() {
        Dataset<Row> df = this.jsonToDF("id " + this.dataType + ", data string", "{ \"id\": 1, \"data\": \"a\" }", "{ \"id\": 2, \"data\": \"b\" }");
        df.writeTo(this.tableName).option("write-format", this.format.name()).createOrReplace();
        this.assertEquals("Should have initial 2-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1, "a"), (Object)this.row(2, "b")), this.sql("select * from %s order by id", this.tableName));
    }
}

