/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Iterator;
import java.util.List;
import org.apache.iceberg.RecordWrapperTest;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.source.InternalRowWrapper;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;
import org.apache.spark.sql.catalyst.InternalRow;
import org.junit.Assert;
import org.junit.Ignore;

public class TestInternalRowWrapper
extends RecordWrapperTest {
    @Ignore
    public void testTimestampWithoutZone() {
    }

    @Ignore
    public void testTime() {
    }

    protected void generateAndValidate(Schema schema, RecordWrapperTest.AssertMethod assertMethod) {
        int numRecords = 100;
        List recordList = RandomGenericData.generate((Schema)schema, (int)numRecords, (long)101L);
        Iterable<InternalRow> rowList = RandomData.generateSpark(schema, numRecords, 101L);
        InternalRecordWrapper recordWrapper = new InternalRecordWrapper(schema.asStruct());
        InternalRowWrapper rowWrapper = new InternalRowWrapper(SparkSchemaUtil.convert((Schema)schema), schema.asStruct());
        Iterator actual = recordList.iterator();
        Iterator<InternalRow> expected = rowList.iterator();
        StructLikeWrapper actualWrapper = StructLikeWrapper.forType((Types.StructType)schema.asStruct());
        StructLikeWrapper expectedWrapper = StructLikeWrapper.forType((Types.StructType)schema.asStruct());
        for (int i = 0; i < numRecords; ++i) {
            Assert.assertTrue((String)"Should have more records", (boolean)actual.hasNext());
            Assert.assertTrue((String)"Should have more InternalRow", (boolean)expected.hasNext());
            InternalRecordWrapper recordStructLike = recordWrapper.wrap((StructLike)actual.next());
            InternalRowWrapper rowStructLike = rowWrapper.wrap(expected.next());
            assertMethod.assertEquals("Should have expected StructLike values", actualWrapper.set((StructLike)recordStructLike), expectedWrapper.set((StructLike)rowStructLike));
        }
        Assert.assertFalse((String)"Shouldn't have more record", (boolean)actual.hasNext());
        Assert.assertFalse((String)"Shouldn't have more InternalRow", (boolean)expected.hasNext());
    }
}

