/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.spark.data.AvroDataTest;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestParquetScan
extends AvroDataTest {
    private static final Configuration CONF = new Configuration();
    private static SparkSession spark = null;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private final boolean vectorized;

    @BeforeClass
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
    }

    @AfterClass
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        currentSpark.stop();
    }

    @Parameterized.Parameters(name="vectorized = {0}")
    public static Object[] parameters() {
        return new Object[]{false, true};
    }

    public TestParquetScan(boolean vectorized) {
        this.vectorized = vectorized;
    }

    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        Assume.assumeTrue((String)"Cannot handle non-string map keys in parquet-avro", (null == TypeUtil.find((Schema)schema, type -> type.isMapType() && type.asMapType().keyType() != Types.StringType.get()) ? 1 : 0) != 0);
        Table table = this.createTable(schema);
        List<GenericData.Record> expected = RandomData.generateList(table.schema(), 100, 1L);
        this.writeRecords(table, expected);
        this.configureVectorization(table);
        Dataset df = spark.read().format("iceberg").load(table.location());
        List rows = df.collectAsList();
        Assert.assertEquals((String)"Should contain 100 rows", (long)100L, (long)rows.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestHelpers.assertEqualsSafe(table.schema().asStruct(), expected.get(i), (Row)rows.get(i));
        }
    }

    @Test
    public void testEmptyTableProjection() throws IOException {
        Types.StructType structType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)101, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)102, (String)"b", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)103, (String)"i", (Type)Types.IntegerType.get())});
        Table table = this.createTable(new Schema(structType.fields()));
        List<GenericData.Record> expected = RandomData.generateList(table.schema(), 100, 1L);
        this.writeRecords(table, expected);
        this.configureVectorization(table);
        List rows = spark.read().format("iceberg").load(table.location()).select(new Column[]{functions.monotonically_increasing_id()}).collectAsList();
        Assertions.assertThat((List)rows).hasSize(100);
    }

    private Table createTable(Schema schema) throws IOException {
        File parent = this.temp.newFolder("parquet");
        File location = new File(parent, "test");
        HadoopTables tables = new HadoopTables(CONF);
        return tables.create(schema, PartitionSpec.unpartitioned(), location.toString());
    }

    private void writeRecords(Table table, List<GenericData.Record> records) throws IOException {
        File dataFolder = new File(table.location(), "data");
        dataFolder.mkdirs();
        File parquetFile = new File(dataFolder, FileFormat.PARQUET.addExtension(UUID.randomUUID().toString()));
        try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)parquetFile)).schema(table.schema()).build();){
            writer.addAll(records);
        }
        DataFile file = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withFileSizeInBytes(parquetFile.length()).withPath(parquetFile.toString()).withRecordCount(100L).build();
        table.newAppend().appendFile(file).commit();
    }

    private void configureVectorization(Table table) {
        table.updateProperties().set("read.parquet.vectorization.enabled", String.valueOf(this.vectorized)).commit();
    }
}

