/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class TestReadProjection {
    final String format;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    TestReadProjection(String format) {
        this.format = format;
    }

    protected abstract Record writeAndRead(String var1, Schema var2, Schema var3, Record var4) throws IOException;

    @Test
    public void testFullProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRecord record = GenericRecord.create((Schema)schema);
        record.setField("id", (Object)34L);
        record.setField("data", (Object)"test");
        Record projected = this.writeAndRead("full_projection", schema, schema, (Record)record);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.getField("id")));
        int cmp = Comparators.charSequences().compare("test", (CharSequence)projected.getField("data"));
        Assert.assertEquals((String)"Should contain the correct data value", (long)0L, (long)cmp);
    }

    @Test
    public void testReorderedFullProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRecord record = GenericRecord.create((Schema)schema);
        record.setField("id", (Object)34L);
        record.setField("data", (Object)"test");
        Schema reordered = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("reordered_full_projection", schema, reordered, (Record)record);
        Assert.assertEquals((String)"Should contain the correct 0 value", (Object)"test", (Object)projected.get(0).toString());
        Assert.assertEquals((String)"Should contain the correct 1 value", (Object)34L, (Object)projected.get(1));
    }

    @Test
    public void testReorderedProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRecord record = GenericRecord.create((Schema)schema);
        record.setField("id", (Object)34L);
        record.setField("data", (Object)"test");
        Schema reordered = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"missing_1", (Type)Types.StringType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"missing_2", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("reordered_projection", schema, reordered, (Record)record);
        Assert.assertNull((String)"Should contain the correct 0 value", (Object)projected.get(0));
        Assert.assertEquals((String)"Should contain the correct 1 value", (Object)"test", (Object)projected.get(1).toString());
        Assert.assertNull((String)"Should contain the correct 2 value", (Object)projected.get(2));
    }

    @Test
    public void testEmptyProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRecord record = GenericRecord.create((Schema)schema);
        record.setField("id", (Object)34L);
        record.setField("data", (Object)"test");
        Record projected = this.writeAndRead("empty_projection", schema, schema.select(new String[0]), (Record)record);
        Assert.assertNotNull((String)"Should read a non-null record", (Object)projected);
        Assertions.assertThatThrownBy(() -> projected.get(0)).isInstanceOf(ArrayIndexOutOfBoundsException.class);
    }

    @Test
    public void testBasicProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRecord record = GenericRecord.create((Schema)writeSchema);
        record.setField("id", (Object)34L);
        record.setField("data", (Object)"test");
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("basic_projection_id", writeSchema, idOnly, (Record)record);
        Assert.assertNull((String)"Should not project data", (Object)projected.getField("data"));
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.getField("id")));
        Schema dataOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        projected = this.writeAndRead("basic_projection_data", writeSchema, dataOnly, (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        int cmp = Comparators.charSequences().compare("test", (CharSequence)projected.getField("data"));
        Assert.assertEquals((String)"Should contain the correct data value", (long)0L, (long)cmp);
    }

    @Test
    public void testRename() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRecord record = GenericRecord.create((Schema)writeSchema);
        record.setField("id", (Object)34L);
        record.setField("data", (Object)"test");
        Schema readSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"renamed", (Type)Types.StringType.get())});
        Record projected = this.writeAndRead("project_and_rename", writeSchema, readSchema, (Record)record);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.getField("id")));
        int cmp = Comparators.charSequences().compare("test", (CharSequence)projected.getField("renamed"));
        Assert.assertEquals((String)"Should contain the correct data/renamed value", (long)0L, (long)cmp);
    }

    @Test
    public void testNestedStructProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        GenericRecord record = GenericRecord.create((Schema)writeSchema);
        record.setField("id", (Object)34L);
        GenericRecord location = GenericRecord.create((Types.StructType)writeSchema.findType("location").asStructType());
        location.setField("lat", (Object)Float.valueOf(52.995144f));
        location.setField("long", (Object)Float.valueOf(-1.539054f));
        record.setField("location", (Object)location);
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("id_only", writeSchema, idOnly, (Record)record);
        Record projectedLocation = (Record)projected.getField("location");
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.getField("id")));
        Assert.assertNull((String)"Should not project location", (Object)projectedLocation);
        Schema latOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get())}))});
        projected = this.writeAndRead("latitude_only", writeSchema, latOnly, (Record)record);
        projectedLocation = (Record)projected.getField("location");
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertNotNull((String)"Should project location", (Object)projected.getField("location"));
        Assert.assertNull((String)"Should not project longitude", (Object)projectedLocation.getField("long"));
        Assert.assertEquals((String)"Should project latitude", (float)52.995144f, (float)((Float)projectedLocation.getField("lat")).floatValue(), (float)1.0E-6f);
        Schema longOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        projected = this.writeAndRead("longitude_only", writeSchema, longOnly, (Record)record);
        projectedLocation = (Record)projected.getField("location");
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertNotNull((String)"Should project location", (Object)projected.getField("location"));
        Assert.assertNull((String)"Should not project latitutde", (Object)projectedLocation.getField("lat"));
        Assert.assertEquals((String)"Should project longitude", (float)-1.539054f, (float)((Float)projectedLocation.getField("long")).floatValue(), (float)1.0E-6f);
        Schema locationOnly = writeSchema.select(new String[]{"location"});
        projected = this.writeAndRead("location_only", writeSchema, locationOnly, (Record)record);
        projectedLocation = (Record)projected.getField("location");
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertNotNull((String)"Should project location", (Object)projected.getField("location"));
        Assert.assertEquals((String)"Should project latitude", (float)52.995144f, (float)((Float)projectedLocation.getField("lat")).floatValue(), (float)1.0E-6f);
        Assert.assertEquals((String)"Should project longitude", (float)-1.539054f, (float)((Float)projectedLocation.getField("long")).floatValue(), (float)1.0E-6f);
    }

    @Test
    public void testMapProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"properties", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        ImmutableMap properties = ImmutableMap.of((Object)"a", (Object)"A", (Object)"b", (Object)"B");
        GenericRecord record = GenericRecord.create((Schema)writeSchema);
        record.setField("id", (Object)34L);
        record.setField("properties", (Object)properties);
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("id_only", writeSchema, idOnly, (Record)record);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.getField("id")));
        Assert.assertNull((String)"Should not project properties map", (Object)projected.getField("properties"));
        Schema keyOnly = writeSchema.select(new String[]{"properties.key"});
        projected = this.writeAndRead("key_only", writeSchema, keyOnly, (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertEquals((String)"Should project entire map", (Object)properties, this.toStringMap((Map)projected.getField("properties")));
        Schema valueOnly = writeSchema.select(new String[]{"properties.value"});
        projected = this.writeAndRead("value_only", writeSchema, valueOnly, (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertEquals((String)"Should project entire map", (Object)properties, this.toStringMap((Map)projected.getField("properties")));
        Schema mapOnly = writeSchema.select(new String[]{"properties"});
        projected = this.writeAndRead("map_only", writeSchema, mapOnly, (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertEquals((String)"Should project entire map", (Object)properties, this.toStringMap((Map)projected.getField("properties")));
    }

    private Map<String, ?> toStringMap(Map<?, ?> map) {
        HashMap stringMap = Maps.newHashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof CharSequence) {
                stringMap.put(entry.getKey().toString(), entry.getValue().toString());
                continue;
            }
            stringMap.put(entry.getKey().toString(), entry.getValue());
        }
        return stringMap;
    }

    @Test
    public void testMapOfStructsProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())})))});
        GenericRecord record = GenericRecord.create((Schema)writeSchema);
        record.setField("id", (Object)34L);
        GenericRecord l1 = GenericRecord.create((Types.StructType)writeSchema.findType("locations.value").asStructType());
        l1.setField("lat", (Object)Float.valueOf(53.99281f));
        l1.setField("long", (Object)Float.valueOf(-1.542616f));
        GenericRecord l2 = GenericRecord.create((Types.StructType)l1.struct());
        l2.setField("lat", (Object)Float.valueOf(52.995144f));
        l2.setField("long", (Object)Float.valueOf(-1.539054f));
        record.setField("locations", (Object)ImmutableMap.of((Object)"L1", (Object)l1, (Object)"L2", (Object)l2));
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("id_only", writeSchema, idOnly, (Record)record);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.getField("id")));
        Assert.assertNull((String)"Should not project locations map", (Object)projected.getField("locations"));
        projected = this.writeAndRead("all_locations", writeSchema, writeSchema.select(new String[]{"locations"}), (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertEquals((String)"Should project locations map", (Object)record.getField("locations"), this.toStringMap((Map)projected.getField("locations")));
        projected = this.writeAndRead("lat_only", writeSchema, writeSchema.select(new String[]{"locations.lat"}), (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Map<String, ?> locations = this.toStringMap((Map)projected.getField("locations"));
        Assert.assertNotNull((String)"Should project locations map", locations);
        Assert.assertEquals((String)"Should contain L1 and L2", (Object)Sets.newHashSet((Object[])new String[]{"L1", "L2"}), locations.keySet());
        Record projectedL1 = (Record)locations.get("L1");
        Assert.assertNotNull((String)"L1 should not be null", (Object)projectedL1);
        Assert.assertEquals((String)"L1 should contain lat", (double)53.9928092956543, (double)((Float)projectedL1.getField("lat")).floatValue(), (double)1.0E-6);
        Assert.assertNull((String)"L1 should not contain long", (Object)projectedL1.getField("long"));
        Record projectedL2 = (Record)locations.get("L2");
        Assert.assertNotNull((String)"L2 should not be null", (Object)projectedL2);
        Assert.assertEquals((String)"L2 should contain lat", (double)52.99514389038086, (double)((Float)projectedL2.getField("lat")).floatValue(), (double)1.0E-6);
        Assert.assertNull((String)"L2 should not contain long", (Object)projectedL2.getField("long"));
        projected = this.writeAndRead("long_only", writeSchema, writeSchema.select(new String[]{"locations.long"}), (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        locations = this.toStringMap((Map)projected.getField("locations"));
        Assert.assertNotNull((String)"Should project locations map", locations);
        Assert.assertEquals((String)"Should contain L1 and L2", (Object)Sets.newHashSet((Object[])new String[]{"L1", "L2"}), locations.keySet());
        projectedL1 = (Record)locations.get("L1");
        Assert.assertNotNull((String)"L1 should not be null", (Object)projectedL1);
        Assert.assertNull((String)"L1 should not contain lat", (Object)projectedL1.getField("lat"));
        Assert.assertEquals((String)"L1 should contain long", (double)-1.542616f, (double)((Float)projectedL1.getField("long")).floatValue(), (double)1.0E-6);
        projectedL2 = (Record)locations.get("L2");
        Assert.assertNotNull((String)"L2 should not be null", (Object)projectedL2);
        Assert.assertNull((String)"L2 should not contain lat", (Object)projectedL2.getField("lat"));
        Assert.assertEquals((String)"L2 should contain long", (double)-1.539054036140442, (double)((Float)projectedL2.getField("long")).floatValue(), (double)1.0E-6);
        Schema latitiudeRenamed = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"latitude", (Type)Types.FloatType.get())})))});
        projected = this.writeAndRead("latitude_renamed", writeSchema, latitiudeRenamed, (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        locations = this.toStringMap((Map)projected.getField("locations"));
        Assert.assertNotNull((String)"Should project locations map", locations);
        Assert.assertEquals((String)"Should contain L1 and L2", (Object)Sets.newHashSet((Object[])new String[]{"L1", "L2"}), locations.keySet());
        projectedL1 = (Record)locations.get("L1");
        Assert.assertNotNull((String)"L1 should not be null", (Object)projectedL1);
        Assert.assertEquals((String)"L1 should contain latitude", (double)53.9928092956543, (double)((Float)projectedL1.getField("latitude")).floatValue(), (double)1.0E-6);
        Assert.assertNull((String)"L1 should not contain lat", (Object)projectedL1.getField("lat"));
        Assert.assertNull((String)"L1 should not contain long", (Object)projectedL1.getField("long"));
        projectedL2 = (Record)locations.get("L2");
        Assert.assertNotNull((String)"L2 should not be null", (Object)projectedL2);
        Assert.assertEquals((String)"L2 should contain latitude", (double)52.99514389038086, (double)((Float)projectedL2.getField("latitude")).floatValue(), (double)1.0E-6);
        Assert.assertNull((String)"L2 should not contain lat", (Object)projectedL2.getField("lat"));
        Assert.assertNull((String)"L2 should not contain long", (Object)projectedL2.getField("long"));
    }

    @Test
    public void testListProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)10, (String)"values", (Type)Types.ListType.ofOptional((int)11, (Type)Types.LongType.get()))});
        ImmutableList values = ImmutableList.of((Object)56L, (Object)57L, (Object)58L);
        GenericRecord record = GenericRecord.create((Schema)writeSchema);
        record.setField("id", (Object)34L);
        record.setField("values", (Object)values);
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("id_only", writeSchema, idOnly, (Record)record);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.getField("id")));
        Assert.assertNull((String)"Should not project values list", (Object)projected.getField("values"));
        Schema elementOnly = writeSchema.select(new String[]{"values.element"});
        projected = this.writeAndRead("element_only", writeSchema, elementOnly, (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertEquals((String)"Should project entire list", (Object)values, (Object)projected.getField("values"));
        Schema listOnly = writeSchema.select(new String[]{"values"});
        projected = this.writeAndRead("list_only", writeSchema, listOnly, (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertEquals((String)"Should project entire list", (Object)values, (Object)projected.getField("values"));
    }

    @Test
    public void testListOfStructsProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)18, (String)"y", (Type)Types.IntegerType.get())})))});
        GenericRecord record = GenericRecord.create((Schema)writeSchema);
        record.setField("id", (Object)34L);
        GenericRecord p1 = GenericRecord.create((Types.StructType)writeSchema.findType("points.element").asStructType());
        p1.setField("x", (Object)1);
        p1.setField("y", (Object)2);
        GenericRecord p2 = GenericRecord.create((Types.StructType)p1.struct());
        p2.setField("x", (Object)3);
        p2.setField("y", null);
        record.setField("points", (Object)ImmutableList.of((Object)p1, (Object)p2));
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("id_only", writeSchema, idOnly, (Record)record);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)((Long)projected.getField("id")));
        Assert.assertNull((String)"Should not project points list", (Object)projected.getField("points"));
        projected = this.writeAndRead("all_points", writeSchema, writeSchema.select(new String[]{"points"}), (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertEquals((String)"Should project points list", (Object)record.getField("points"), (Object)projected.getField("points"));
        projected = this.writeAndRead("x_only", writeSchema, writeSchema.select(new String[]{"points.x"}), (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertNotNull((String)"Should project points list", (Object)projected.getField("points"));
        List points = (List)projected.getField("points");
        Assert.assertEquals((String)"Should read 2 points", (long)2L, (long)points.size());
        Record projectedP1 = (Record)points.get(0);
        Assert.assertEquals((String)"Should project x", (long)1L, (long)((Integer)projectedP1.getField("x")).intValue());
        Assert.assertNull((String)"Should not project y", (Object)projectedP1.getField("y"));
        Record projectedP2 = (Record)points.get(1);
        Assert.assertEquals((String)"Should project x", (long)3L, (long)((Integer)projectedP2.getField("x")).intValue());
        Assert.assertNull((String)"Should not project y", (Object)projectedP2.getField("y"));
        projected = this.writeAndRead("y_only", writeSchema, writeSchema.select(new String[]{"points.y"}), (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertNotNull((String)"Should project points list", (Object)projected.getField("points"));
        points = (List)projected.getField("points");
        Assert.assertEquals((String)"Should read 2 points", (long)2L, (long)points.size());
        projectedP1 = (Record)points.get(0);
        Assert.assertNull((String)"Should not project x", (Object)projectedP1.getField("x"));
        Assert.assertEquals((String)"Should project y", (long)2L, (long)((Integer)projectedP1.getField("y")).intValue());
        projectedP2 = (Record)points.get(1);
        Assert.assertNull((String)"Should not project x", (Object)projectedP2.getField("x"));
        Assert.assertNull((String)"Should project null y", (Object)projectedP2.getField("y"));
        Schema yRenamed = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)18, (String)"z", (Type)Types.IntegerType.get())})))});
        projected = this.writeAndRead("y_renamed", writeSchema, yRenamed, (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertNotNull((String)"Should project points list", (Object)projected.getField("points"));
        points = (List)projected.getField("points");
        Assert.assertEquals((String)"Should read 2 points", (long)2L, (long)points.size());
        projectedP1 = (Record)points.get(0);
        Assert.assertNull((String)"Should not project x", (Object)projectedP1.getField("x"));
        Assert.assertNull((String)"Should not project y", (Object)projectedP1.getField("y"));
        Assert.assertEquals((String)"Should project z", (long)2L, (long)((Integer)projectedP1.getField("z")).intValue());
        projectedP2 = (Record)points.get(1);
        Assert.assertNull((String)"Should not project x", (Object)projectedP2.getField("x"));
        Assert.assertNull((String)"Should not project y", (Object)projectedP2.getField("y"));
        Assert.assertNull((String)"Should project null z", (Object)projectedP2.getField("z"));
        Schema zAdded = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)18, (String)"y", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)20, (String)"z", (Type)Types.IntegerType.get())})))});
        projected = this.writeAndRead("z_added", writeSchema, zAdded, (Record)record);
        Assert.assertNull((String)"Should not project id", (Object)projected.getField("id"));
        Assert.assertNotNull((String)"Should project points list", (Object)projected.getField("points"));
        points = (List)projected.getField("points");
        Assert.assertEquals((String)"Should read 2 points", (long)2L, (long)points.size());
        projectedP1 = (Record)points.get(0);
        Assert.assertEquals((String)"Should project x", (long)1L, (long)((Integer)projectedP1.getField("x")).intValue());
        Assert.assertEquals((String)"Should project y", (long)2L, (long)((Integer)projectedP1.getField("y")).intValue());
        Assert.assertNull((String)"Should contain null z", (Object)projectedP1.getField("z"));
        projectedP2 = (Record)points.get(1);
        Assert.assertEquals((String)"Should project x", (long)3L, (long)((Integer)projectedP2.getField("x")).intValue());
        Assert.assertNull((String)"Should project null y", (Object)projectedP2.getField("y"));
        Assert.assertNull((String)"Should contain null z", (Object)projectedP2.getField("z"));
    }

    private static org.apache.avro.Schema fromOption(org.apache.avro.Schema schema) {
        Preconditions.checkArgument((schema.getType() == Schema.Type.UNION ? 1 : 0) != 0, (String)"Expected union schema but was passed: %s", (Object)schema);
        Preconditions.checkArgument((schema.getTypes().size() == 2 ? 1 : 0) != 0, (String)"Expected optional schema, but was passed: %s", (Object)schema);
        if (((org.apache.avro.Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
            return (org.apache.avro.Schema)schema.getTypes().get(1);
        }
        return (org.apache.avro.Schema)schema.getTypes().get(0);
    }
}

