/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.HashMap;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundAggregate;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkAggregates;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.junit.Assert;
import org.junit.Test;

public class TestSparkAggregates {
    @Test
    public void testAggregates() {
        HashMap attrMap = Maps.newHashMap();
        attrMap.put("id", "id");
        attrMap.put("`i.d`", "i.d");
        attrMap.put("`i``d`", "i`d");
        attrMap.put("`d`.b.`dd```", "d.b.dd`");
        attrMap.put("a.`aa```.c", "a.aa`.c");
        attrMap.forEach((quoted, unquoted) -> {
            NamedReference namedReference = FieldReference.apply((String)quoted);
            Max max = new Max((Expression)namedReference);
            UnboundAggregate expectedMax = Expressions.max((String)unquoted);
            org.apache.iceberg.expressions.Expression actualMax = SparkAggregates.convert((AggregateFunc)max);
            Assert.assertEquals((String)"Max must match", (Object)expectedMax.toString(), (Object)actualMax.toString());
            Min min = new Min((Expression)namedReference);
            UnboundAggregate expectedMin = Expressions.min((String)unquoted);
            org.apache.iceberg.expressions.Expression actualMin = SparkAggregates.convert((AggregateFunc)min);
            Assert.assertEquals((String)"Min must match", (Object)expectedMin.toString(), (Object)actualMin.toString());
            Count count = new Count((Expression)namedReference, false);
            UnboundAggregate expectedCount = Expressions.count((String)unquoted);
            org.apache.iceberg.expressions.Expression actualCount = SparkAggregates.convert((AggregateFunc)count);
            Assert.assertEquals((String)"Count must match", (Object)expectedCount.toString(), (Object)actualCount.toString());
            Count countDistinct = new Count((Expression)namedReference, true);
            org.apache.iceberg.expressions.Expression convertedCountDistinct = SparkAggregates.convert((AggregateFunc)countDistinct);
            Assert.assertNull((String)"Count Distinct is converted to null", (Object)convertedCountDistinct);
            CountStar countStar = new CountStar();
            UnboundAggregate expectedCountStar = Expressions.countStar();
            org.apache.iceberg.expressions.Expression actualCountStar = SparkAggregates.convert((AggregateFunc)countStar);
            Assert.assertEquals((String)"CountStar must match", (Object)expectedCountStar.toString(), (Object)actualCountStar.toString());
        });
    }
}

