/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSparkCatalogCacheExpiration
extends SparkTestBaseWithCatalog {
    private static final String SESSION_CATALOG_NAME = "spark_catalog";
    private static final String SESSION_CATALOG_IMPL = SparkSessionCatalog.class.getName();
    private static final Map<String, String> SESSION_CATALOG_CONFIG = ImmutableMap.of((Object)"type", (Object)"hadoop", (Object)"default-namespace", (Object)"default", (Object)"cache-enabled", (Object)"true", (Object)"cache.expiration-interval-ms", (Object)"3000");

    private static String asSqlConfCatalogKeyFor(String catalog, String configKey) {
        if (configKey.isEmpty()) {
            return String.format("spark.sql.catalog.%s", catalog);
        }
        return String.format("spark.sql.catalog.%s.%s", catalog, configKey);
    }

    @BeforeClass
    public static void beforeClass() {
        ImmutableMap.of((Object)"", (Object)"org.apache.iceberg.spark.SparkCatalog", (Object)"type", (Object)"hive", (Object)"cache-enabled", (Object)"true", (Object)"cache.expiration-interval-ms", (Object)"-1").forEach((k, v) -> spark.conf().set(TestSparkCatalogCacheExpiration.asSqlConfCatalogKeyFor("expiration_disabled", k), v));
        ImmutableMap.of((Object)"", (Object)"org.apache.iceberg.spark.SparkCatalog", (Object)"type", (Object)"hive", (Object)"cache-enabled", (Object)"true", (Object)"cache.expiration-interval-ms", (Object)"0").forEach((k, v) -> spark.conf().set(TestSparkCatalogCacheExpiration.asSqlConfCatalogKeyFor("cache_disabled_implicitly", k), v));
    }

    public TestSparkCatalogCacheExpiration() {
        super(SESSION_CATALOG_NAME, SESSION_CATALOG_IMPL, SESSION_CATALOG_CONFIG);
    }

    @Test
    public void testSparkSessionCatalogWithExpirationEnabled() {
        SparkSessionCatalog<?> sparkCatalog = this.sparkSessionCatalog();
        Assertions.assertThat(sparkCatalog).extracting("icebergCatalog").extracting("cacheEnabled").isEqualTo((Object)true);
        Assertions.assertThat(sparkCatalog).extracting("icebergCatalog").extracting("icebergCatalog").isInstanceOfSatisfying(Catalog.class, icebergCatalog -> ((ObjectAssert)Assertions.assertThat((Object)icebergCatalog).isExactlyInstanceOf(CachingCatalog.class)).extracting("expirationIntervalMillis").isEqualTo((Object)3000L));
    }

    @Test
    public void testCacheEnabledAndExpirationDisabled() {
        SparkCatalog sparkCatalog = this.getSparkCatalog("expiration_disabled");
        Assertions.assertThat((Object)sparkCatalog).extracting("cacheEnabled").isEqualTo((Object)true);
        Assertions.assertThat((Object)sparkCatalog).extracting("icebergCatalog").isInstanceOfSatisfying(CachingCatalog.class, icebergCatalog -> Assertions.assertThat((Object)icebergCatalog).extracting("expirationIntervalMillis").isEqualTo((Object)-1L));
    }

    @Test
    public void testCacheDisabledImplicitly() {
        SparkCatalog sparkCatalog = this.getSparkCatalog("cache_disabled_implicitly");
        Assertions.assertThat((Object)sparkCatalog).extracting("cacheEnabled").isEqualTo((Object)false);
        Assertions.assertThat((Object)sparkCatalog).extracting("icebergCatalog").isInstanceOfSatisfying(Catalog.class, icebergCatalog -> Assertions.assertThat((Object)icebergCatalog).isNotInstanceOf(CachingCatalog.class));
    }

    private SparkSessionCatalog<?> sparkSessionCatalog() {
        TableCatalog catalog = (TableCatalog)spark.sessionState().catalogManager().catalog(SESSION_CATALOG_NAME);
        return (SparkSessionCatalog)catalog;
    }

    private SparkCatalog getSparkCatalog(String catalog) {
        return (SparkCatalog)spark.sessionState().catalogManager().catalog(catalog);
    }
}

