/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkDataFile;
import org.apache.iceberg.spark.SparkDeleteFile;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.ColumnName;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSparkDataFile {
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)101, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)102, (String)"b", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)103, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.required((int)104, (String)"l", (Type)Types.LongType.get()), Types.NestedField.optional((int)105, (String)"f", (Type)Types.FloatType.get()), Types.NestedField.required((int)106, (String)"d", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)107, (String)"date", (Type)Types.DateType.get()), Types.NestedField.required((int)108, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)109, (String)"tsntz", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)110, (String)"s", (Type)Types.StringType.get()), Types.NestedField.optional((int)113, (String)"bytes", (Type)Types.BinaryType.get()), Types.NestedField.required((int)114, (String)"dec_9_0", (Type)Types.DecimalType.of((int)9, (int)0)), Types.NestedField.required((int)115, (String)"dec_11_2", (Type)Types.DecimalType.of((int)11, (int)2)), Types.NestedField.required((int)116, (String)"dec_38_10", (Type)Types.DecimalType.of((int)38, (int)10))});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("b").bucket("i", 2).identity("l").identity("f").identity("d").identity("date").hour("ts").identity("ts").identity("tsntz").truncate("s", 2).identity("bytes").bucket("dec_9_0", 2).bucket("dec_11_2", 2).bucket("dec_38_10", 2).build();
    private static SparkSession spark;
    private static JavaSparkContext sparkContext;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private String tableLocation = null;

    @BeforeClass
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
        sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
    }

    @AfterClass
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        sparkContext = null;
        currentSpark.stop();
    }

    @Before
    public void setupTableLocation() throws Exception {
        File tableDir = this.temp.newFolder();
        this.tableLocation = tableDir.toURI().toString();
    }

    @Test
    public void testValueConversion() throws IOException {
        Table table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), (Map)Maps.newHashMap(), this.tableLocation);
        this.checkSparkContentFiles(table);
    }

    @Test
    public void testValueConversionPartitionedTable() throws IOException {
        Table table = TABLES.create(SCHEMA, SPEC, (Map)Maps.newHashMap(), this.tableLocation);
        this.checkSparkContentFiles(table);
    }

    @Test
    public void testValueConversionWithEmptyStats() throws IOException {
        HashMap props = Maps.newHashMap();
        props.put("write.metadata.metrics.default", "none");
        Table table = TABLES.create(SCHEMA, SPEC, (Map)props, this.tableLocation);
        this.checkSparkContentFiles(table);
    }

    private void checkSparkContentFiles(Table table) throws IOException {
        Iterable<InternalRow> rows = RandomData.generateSpark(table.schema(), 200, 0L);
        JavaRDD rdd = sparkContext.parallelize((List)Lists.newArrayList(rows));
        Dataset df = spark.internalCreateDataFrame(JavaRDD.toRDD((JavaRDD)rdd), SparkSchemaUtil.convert((Schema)table.schema()), false);
        df.write().format("iceberg").mode("append").save(this.tableLocation);
        table.refresh();
        PartitionSpec dataFilesSpec = table.spec();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assertions.assertThat((List)manifests).hasSize(1);
        ArrayList dataFiles = Lists.newArrayList();
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)((ManifestFile)manifests.get(0)), (FileIO)table.io());){
            for (DataFile dataFile : reader) {
                this.checkDataFile((DataFile)dataFile.copy(), DataFiles.builder((PartitionSpec)dataFilesSpec).copy(dataFile).build());
                dataFiles.add((DataFile)dataFile.copy());
            }
        }
        UpdatePartitionSpec updateSpec = table.updateSpec();
        for (PartitionField field : dataFilesSpec.fields()) {
            updateSpec.removeField(field.name());
        }
        updateSpec.commit();
        ArrayList positionDeleteFiles = Lists.newArrayList();
        ArrayList equalityDeleteFiles = Lists.newArrayList();
        RowDelta rowDelta = table.newRowDelta();
        for (DataFile dataFile : dataFiles) {
            DeleteFile positionDeleteFile = this.createPositionDeleteFile(table, dataFile);
            positionDeleteFiles.add(positionDeleteFile);
            rowDelta.addDeletes(positionDeleteFile);
        }
        DeleteFile equalityDeleteFile1 = this.createEqualityDeleteFile(table);
        equalityDeleteFiles.add(equalityDeleteFile1);
        rowDelta.addDeletes(equalityDeleteFile1);
        DeleteFile equalityDeleteFile2 = this.createEqualityDeleteFile(table);
        equalityDeleteFiles.add(equalityDeleteFile2);
        rowDelta.addDeletes(equalityDeleteFile2);
        rowDelta.commit();
        Dataset dataFileDF = spark.read().format("iceberg").load(this.tableLocation + "#data_files");
        List sparkDataFiles = this.shuffleColumns((Dataset<Row>)dataFileDF).collectAsList();
        Assertions.assertThat((List)sparkDataFiles).hasSameSizeAs((Iterable)dataFiles);
        Types.StructType dataFileType = DataFile.getType((Types.StructType)dataFilesSpec.partitionType());
        StructType sparkDataFileType = ((Row)sparkDataFiles.get(0)).schema();
        SparkDataFile dataFileWrapper = new SparkDataFile(dataFileType, sparkDataFileType);
        for (int i = 0; i < dataFiles.size(); ++i) {
            this.checkDataFile((DataFile)dataFiles.get(i), (DataFile)dataFileWrapper.wrap((Row)sparkDataFiles.get(i)));
        }
        Dataset positionDeleteFileDF = spark.read().format("iceberg").load(this.tableLocation + "#delete_files").where("content = 1");
        List sparkPositionDeleteFiles = this.shuffleColumns((Dataset<Row>)positionDeleteFileDF).collectAsList();
        Assertions.assertThat((List)sparkPositionDeleteFiles).hasSameSizeAs((Iterable)positionDeleteFiles);
        Types.StructType positionDeleteFileType = DataFile.getType((Types.StructType)dataFilesSpec.partitionType());
        StructType sparkPositionDeleteFileType = ((Row)sparkPositionDeleteFiles.get(0)).schema();
        SparkDeleteFile positionDeleteFileWrapper = new SparkDeleteFile(positionDeleteFileType, sparkPositionDeleteFileType);
        for (int i = 0; i < positionDeleteFiles.size(); ++i) {
            this.checkDeleteFile((DeleteFile)positionDeleteFiles.get(i), (DeleteFile)positionDeleteFileWrapper.wrap((Row)sparkPositionDeleteFiles.get(i)));
        }
        Dataset equalityDeleteFileDF = spark.read().format("iceberg").load(this.tableLocation + "#delete_files").where("content = 2");
        List sparkEqualityDeleteFiles = this.shuffleColumns((Dataset<Row>)equalityDeleteFileDF).collectAsList();
        Assertions.assertThat((List)sparkEqualityDeleteFiles).hasSameSizeAs((Iterable)equalityDeleteFiles);
        Types.StructType equalityDeleteFileType = DataFile.getType((Types.StructType)table.spec().partitionType());
        StructType sparkEqualityDeleteFileType = ((Row)sparkEqualityDeleteFiles.get(0)).schema();
        SparkDeleteFile equalityDeleteFileWrapper = new SparkDeleteFile(equalityDeleteFileType, sparkEqualityDeleteFileType);
        for (int i = 0; i < equalityDeleteFiles.size(); ++i) {
            this.checkDeleteFile((DeleteFile)equalityDeleteFiles.get(i), (DeleteFile)equalityDeleteFileWrapper.wrap((Row)sparkEqualityDeleteFiles.get(i)));
        }
    }

    private Dataset<Row> shuffleColumns(Dataset<Row> df) {
        List<Column> columns = Arrays.stream(df.columns()).map(ColumnName::new).collect(Collectors.toList());
        Collections.shuffle(columns);
        return df.select(columns.toArray(new Column[0]));
    }

    private void checkDataFile(DataFile expected, DataFile actual) {
        Assertions.assertThat((List)expected.equalityFieldIds()).isNull();
        Assertions.assertThat((List)actual.equalityFieldIds()).isNull();
        this.checkContentFile((ContentFile<?>)expected, (ContentFile<?>)actual);
        this.checkStructLike(expected.partition(), actual.partition());
    }

    private void checkDeleteFile(DeleteFile expected, DeleteFile actual) {
        Assertions.assertThat((List)expected.equalityFieldIds()).isEqualTo((Object)actual.equalityFieldIds());
        this.checkContentFile((ContentFile<?>)expected, (ContentFile<?>)actual);
        this.checkStructLike(expected.partition(), actual.partition());
    }

    private void checkContentFile(ContentFile<?> expected, ContentFile<?> actual) {
        Assertions.assertThat((Comparable)actual.content()).isEqualTo((Object)expected.content());
        Assertions.assertThat((CharSequence)actual.path()).isEqualTo((Object)expected.path());
        Assertions.assertThat((Comparable)actual.format()).isEqualTo((Object)expected.format());
        Assertions.assertThat((long)actual.recordCount()).isEqualTo(expected.recordCount());
        Assertions.assertThat((long)actual.fileSizeInBytes()).isEqualTo(expected.fileSizeInBytes());
        Assertions.assertThat((Map)actual.valueCounts()).isEqualTo((Object)expected.valueCounts());
        Assertions.assertThat((Map)actual.nullValueCounts()).isEqualTo((Object)expected.nullValueCounts());
        Assertions.assertThat((Map)actual.nanValueCounts()).isEqualTo((Object)expected.nanValueCounts());
        Assertions.assertThat((Map)actual.lowerBounds()).isEqualTo((Object)expected.lowerBounds());
        Assertions.assertThat((Map)actual.upperBounds()).isEqualTo((Object)expected.upperBounds());
        Assertions.assertThat((Comparable)actual.keyMetadata()).isEqualTo((Object)expected.keyMetadata());
        Assertions.assertThat((List)actual.splitOffsets()).isEqualTo((Object)expected.splitOffsets());
        Assertions.assertThat((Integer)actual.sortOrderId()).isEqualTo((Object)expected.sortOrderId());
    }

    private void checkStructLike(StructLike expected, StructLike actual) {
        Assertions.assertThat((int)actual.size()).isEqualTo(expected.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertThat((Object)actual.get(i, Object.class)).isEqualTo(expected.get(i, Object.class));
        }
    }

    private DeleteFile createPositionDeleteFile(Table table, DataFile dataFile) {
        PartitionSpec spec = (PartitionSpec)table.specs().get(dataFile.specId());
        return FileMetadata.deleteFileBuilder((PartitionSpec)spec).ofPositionDeletes().withPath("/path/to/pos-deletes-" + UUID.randomUUID() + ".parquet").withFileSizeInBytes(dataFile.fileSizeInBytes() / 4L).withPartition(dataFile.partition()).withRecordCount(2L).withMetrics(new Metrics(Long.valueOf(2L), null, null, null, null, (Map)ImmutableMap.of((Object)MetadataColumns.DELETE_FILE_PATH.fieldId(), (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)dataFile.path())), (Map)ImmutableMap.of((Object)MetadataColumns.DELETE_FILE_PATH.fieldId(), (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)dataFile.path())))).withEncryptionKeyMetadata(ByteBuffer.allocate(4).putInt(35)).build();
    }

    private DeleteFile createEqualityDeleteFile(Table table) {
        return FileMetadata.deleteFileBuilder((PartitionSpec)table.spec()).ofEqualityDeletes(new int[]{3, 4}).withPath("/path/to/eq-deletes-" + UUID.randomUUID() + ".parquet").withFileSizeInBytes(250L).withRecordCount(1L).withSortOrder(SortOrder.unsorted()).withEncryptionKeyMetadata(ByteBuffer.allocate(4).putInt(35)).build();
    }

    static {
        sparkContext = null;
    }
}

