/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Collection;
import java.util.List;
import org.apache.iceberg.BaseScanTaskGroup;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MockFileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.iceberg.spark.source.SparkPlanningUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSparkPlanningUtil
extends SparkTestBaseWithCatalog {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"category", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC_1 = PartitionSpec.builderFor((Schema)SCHEMA).withSpecId(1).bucket("id", 16).identity("data").build();
    private static final PartitionSpec SPEC_2 = PartitionSpec.builderFor((Schema)SCHEMA).withSpecId(2).identity("data").build();
    private static final List<String> EXECUTOR_LOCATIONS = ImmutableList.of((Object)"host1_exec1", (Object)"host1_exec2", (Object)"host1_exec3", (Object)"host2_exec1", (Object)"host2_exec2");

    @Test
    public void testFileScanTaskWithoutDeletes() {
        ImmutableList tasks = ImmutableList.of((Object)new MockFileScanTask(TestSparkPlanningUtil.mockDataFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{1, "a"})), SCHEMA, SPEC_1), (Object)new MockFileScanTask(TestSparkPlanningUtil.mockDataFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{2, "b"})), SCHEMA, SPEC_1), (Object)new MockFileScanTask(TestSparkPlanningUtil.mockDataFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{3, "c"})), SCHEMA, SPEC_1));
        BaseScanTaskGroup taskGroup = new BaseScanTaskGroup((Collection)tasks);
        ImmutableList taskGroups = ImmutableList.of((Object)taskGroup);
        String[][] locations = SparkPlanningUtil.assignExecutors((List)taskGroups, EXECUTOR_LOCATIONS);
        Assertions.assertThat((int)locations.length).isEqualTo(1);
        Assertions.assertThat((Object[])locations[0]).isEmpty();
    }

    @Test
    public void testFileScanTaskWithDeletes() {
        TestHelpers.Row partition1 = TestHelpers.Row.of((Object[])new Object[]{"k2", null});
        TestHelpers.Row partition2 = TestHelpers.Row.of((Object[])new Object[]{"k1"});
        ImmutableList tasks = ImmutableList.of((Object)new MockFileScanTask(TestSparkPlanningUtil.mockDataFile((StructLike)partition1), TestSparkPlanningUtil.mockDeleteFiles(1, (StructLike)partition1), SCHEMA, SPEC_1), (Object)new MockFileScanTask(TestSparkPlanningUtil.mockDataFile((StructLike)partition2), TestSparkPlanningUtil.mockDeleteFiles(3, (StructLike)partition2), SCHEMA, SPEC_2), (Object)new MockFileScanTask(TestSparkPlanningUtil.mockDataFile((StructLike)partition1), TestSparkPlanningUtil.mockDeleteFiles(2, (StructLike)partition1), SCHEMA, SPEC_1));
        BaseScanTaskGroup taskGroup = new BaseScanTaskGroup((Collection)tasks);
        ImmutableList taskGroups = ImmutableList.of((Object)taskGroup);
        String[][] locations = SparkPlanningUtil.assignExecutors((List)taskGroups, EXECUTOR_LOCATIONS);
        Assertions.assertThat((int)locations.length).isEqualTo(1);
        Assertions.assertThat((int)locations[0].length).isGreaterThanOrEqualTo(1);
    }

    @Test
    public void testFileScanTaskWithUnpartitionedDeletes() {
        ImmutableList tasks1 = ImmutableList.of((Object)new MockFileScanTask(TestSparkPlanningUtil.mockDataFile((StructLike)TestHelpers.Row.of((Object[])new Object[0])), TestSparkPlanningUtil.mockDeleteFiles(2, (StructLike)TestHelpers.Row.of((Object[])new Object[0])), SCHEMA, PartitionSpec.unpartitioned()), (Object)new MockFileScanTask(TestSparkPlanningUtil.mockDataFile((StructLike)TestHelpers.Row.of((Object[])new Object[0])), TestSparkPlanningUtil.mockDeleteFiles(2, (StructLike)TestHelpers.Row.of((Object[])new Object[0])), SCHEMA, PartitionSpec.unpartitioned()), (Object)new MockFileScanTask(TestSparkPlanningUtil.mockDataFile((StructLike)TestHelpers.Row.of((Object[])new Object[0])), TestSparkPlanningUtil.mockDeleteFiles(2, (StructLike)TestHelpers.Row.of((Object[])new Object[0])), SCHEMA, PartitionSpec.unpartitioned()));
        BaseScanTaskGroup taskGroup1 = new BaseScanTaskGroup((Collection)tasks1);
        ImmutableList tasks2 = ImmutableList.of((Object)new MockFileScanTask(TestSparkPlanningUtil.mockDataFile(null), TestSparkPlanningUtil.mockDeleteFiles(2, null), SCHEMA, PartitionSpec.unpartitioned()), (Object)new MockFileScanTask(TestSparkPlanningUtil.mockDataFile(null), TestSparkPlanningUtil.mockDeleteFiles(2, null), SCHEMA, PartitionSpec.unpartitioned()), (Object)new MockFileScanTask(TestSparkPlanningUtil.mockDataFile(null), TestSparkPlanningUtil.mockDeleteFiles(2, null), SCHEMA, PartitionSpec.unpartitioned()));
        BaseScanTaskGroup taskGroup2 = new BaseScanTaskGroup((Collection)tasks2);
        ImmutableList taskGroups = ImmutableList.of((Object)taskGroup1, (Object)taskGroup2);
        String[][] locations = SparkPlanningUtil.assignExecutors((List)taskGroups, EXECUTOR_LOCATIONS);
        Assertions.assertThat((int)locations.length).isEqualTo(2);
        Assertions.assertThat((Object[])locations[0]).isEmpty();
        Assertions.assertThat((Object[])locations[1]).isEmpty();
    }

    @Test
    public void testDataTasks() {
        ImmutableList tasks = ImmutableList.of((Object)((Object)new MockDataTask(TestSparkPlanningUtil.mockDataFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{1, "a"})))), (Object)((Object)new MockDataTask(TestSparkPlanningUtil.mockDataFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{2, "b"})))), (Object)((Object)new MockDataTask(TestSparkPlanningUtil.mockDataFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{3, "c"})))));
        BaseScanTaskGroup taskGroup = new BaseScanTaskGroup((Collection)tasks);
        ImmutableList taskGroups = ImmutableList.of((Object)taskGroup);
        String[][] locations = SparkPlanningUtil.assignExecutors((List)taskGroups, EXECUTOR_LOCATIONS);
        Assertions.assertThat((int)locations.length).isEqualTo(1);
        Assertions.assertThat((Object[])locations[0]).isEmpty();
    }

    @Test
    public void testUnknownTasks() {
        ImmutableList tasks = ImmutableList.of((Object)new UnknownScanTask(), (Object)new UnknownScanTask());
        BaseScanTaskGroup taskGroup = new BaseScanTaskGroup((Collection)tasks);
        ImmutableList taskGroups = ImmutableList.of((Object)taskGroup);
        String[][] locations = SparkPlanningUtil.assignExecutors((List)taskGroups, EXECUTOR_LOCATIONS);
        Assertions.assertThat((int)locations.length).isEqualTo(1);
        Assertions.assertThat((Object[])locations[0]).isEmpty();
    }

    private static DataFile mockDataFile(StructLike partition) {
        DataFile file = (DataFile)Mockito.mock(DataFile.class);
        Mockito.when((Object)file.partition()).thenReturn((Object)partition);
        return file;
    }

    private static DeleteFile[] mockDeleteFiles(int count, StructLike partition) {
        DeleteFile[] files = new DeleteFile[count];
        for (int index = 0; index < count; ++index) {
            files[index] = TestSparkPlanningUtil.mockDeleteFile(partition);
        }
        return files;
    }

    private static DeleteFile mockDeleteFile(StructLike partition) {
        DeleteFile file = (DeleteFile)Mockito.mock(DeleteFile.class);
        Mockito.when((Object)file.partition()).thenReturn((Object)partition);
        return file;
    }

    private static class UnknownScanTask
    implements ScanTask {
        private UnknownScanTask() {
        }
    }

    private static class MockDataTask
    extends MockFileScanTask
    implements DataTask {
        MockDataTask(DataFile file) {
            super(file);
        }

        public PartitionSpec spec() {
            return PartitionSpec.unpartitioned();
        }

        public CloseableIterable<StructLike> rows() {
            throw new UnsupportedOperationException();
        }
    }
}

