/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

public class TestSparkReadMetrics
extends SparkTestBaseWithCatalog {
    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testReadMetricsForV1Table() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id BIGINT) USING iceberg TBLPROPERTIES ('format-version'='1')", this.tableName);
        spark.range(10000L).coalesce(1).writeTo(this.tableName).append();
        spark.range(10001L, 20000L).coalesce(1).writeTo(this.tableName).append();
        Dataset df = spark.sql(String.format("select * from %s where id < 10000", this.tableName));
        df.collect();
        List sparkPlans = (List)JavaConverters.seqAsJavaListConverter((Seq)df.queryExecution().executedPlan().collectLeaves()).asJava();
        java.util.Map metricsMap = (java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)((SparkPlan)sparkPlans.get(0)).metrics()).asJava();
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalPlanningDuration")).value()).isNotEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalDataManifest")).value()).isEqualTo(2L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("scannedDataManifests")).value()).isEqualTo(2L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("skippedDataManifests")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("resultDataFiles")).value()).isEqualTo(1L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("skippedDataFiles")).value()).isEqualTo(1L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalDataFileSize")).value()).isNotEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalDeleteManifests")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("scannedDeleteManifests")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("skippedDeleteManifests")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalDeleteFileSize")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("resultDeleteFiles")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("equalityDeleteFiles")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("indexedDeleteFiles")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("positionalDeleteFiles")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("skippedDeleteFiles")).value()).isEqualTo(0L);
    }

    @Test
    public void testReadMetricsForV2Table() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id BIGINT) USING iceberg TBLPROPERTIES ('format-version'='2')", this.tableName);
        spark.range(10000L).coalesce(1).writeTo(this.tableName).append();
        spark.range(10001L, 20000L).coalesce(1).writeTo(this.tableName).append();
        Dataset df = spark.sql(String.format("select * from %s where id < 10000", this.tableName));
        df.collect();
        List sparkPlans = (List)JavaConverters.seqAsJavaListConverter((Seq)df.queryExecution().executedPlan().collectLeaves()).asJava();
        java.util.Map metricsMap = (java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)((SparkPlan)sparkPlans.get(0)).metrics()).asJava();
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalPlanningDuration")).value()).isNotEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalDataManifest")).value()).isEqualTo(2L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("scannedDataManifests")).value()).isEqualTo(2L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("skippedDataManifests")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("resultDataFiles")).value()).isEqualTo(1L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("skippedDataFiles")).value()).isEqualTo(1L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalDataFileSize")).value()).isNotEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalDeleteManifests")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("scannedDeleteManifests")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("skippedDeleteManifests")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalDeleteFileSize")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("resultDeleteFiles")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("equalityDeleteFiles")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("indexedDeleteFiles")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("positionalDeleteFiles")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("skippedDeleteFiles")).value()).isEqualTo(0L);
    }

    @Test
    public void testDeleteMetrics() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id BIGINT) USING iceberg TBLPROPERTIES (\n    'write.delete.mode'='merge-on-read',\n    'write.update.mode'='merge-on-read',\n    'write.merge.mode'='merge-on-read',\n    'format-version'='2'\n  )", this.tableName);
        spark.range(10000L).coalesce(1).writeTo(this.tableName).append();
        spark.sql(String.format("DELETE FROM %s WHERE id = 1", this.tableName)).collect();
        Dataset df = spark.sql(String.format("SELECT * FROM %s", this.tableName));
        df.collect();
        List sparkPlans = (List)JavaConverters.seqAsJavaListConverter((Seq)df.queryExecution().executedPlan().collectLeaves()).asJava();
        java.util.Map metricsMap = (java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)((SparkPlan)sparkPlans.get(0)).metrics()).asJava();
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalPlanningDuration")).value()).isNotEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalDataManifest")).value()).isEqualTo(1L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("scannedDataManifests")).value()).isEqualTo(1L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("skippedDataManifests")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("resultDataFiles")).value()).isEqualTo(1L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("skippedDataFiles")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalDataFileSize")).value()).isNotEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalDeleteManifests")).value()).isEqualTo(1L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("scannedDeleteManifests")).value()).isEqualTo(1L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("skippedDeleteManifests")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("totalDeleteFileSize")).value()).isNotEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("resultDeleteFiles")).value()).isEqualTo(1L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("equalityDeleteFiles")).value()).isEqualTo(0L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("indexedDeleteFiles")).value()).isEqualTo(1L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("positionalDeleteFiles")).value()).isEqualTo(1L);
        Assertions.assertThat((long)((SQLMetric)metricsMap.get("skippedDeleteFiles")).value()).isEqualTo(0L);
    }
}

