/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkValueConverter;
import org.apache.iceberg.spark.source.TestReadProjection;
import org.apache.iceberg.spark.source.TestTables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSparkReadProjection
extends TestReadProjection {
    private static SparkSession spark = null;
    private final FileFormat format;
    private final boolean vectorized;
    private final PlanningMode planningMode;

    @Parameterized.Parameters(name="format = {0}, vectorized = {1}, planningMode = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"parquet", false, PlanningMode.LOCAL}, {"parquet", true, PlanningMode.DISTRIBUTED}, {"avro", false, PlanningMode.LOCAL}, {"orc", false, PlanningMode.DISTRIBUTED}, {"orc", true, PlanningMode.LOCAL}};
    }

    public TestSparkReadProjection(String format, boolean vectorized, PlanningMode planningMode) {
        super(format);
        this.format = FileFormat.fromString((String)format);
        this.vectorized = vectorized;
        this.planningMode = planningMode;
    }

    @BeforeClass
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
        ImmutableMap config = ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)"parquet-enabled", (Object)"true", (Object)"cache-enabled", (Object)"false");
        spark.conf().set("spark.sql.catalog.spark_catalog", "org.apache.iceberg.spark.source.TestSparkCatalog");
        config.forEach((key, value) -> spark.conf().set("spark.sql.catalog.spark_catalog." + key, value));
    }

    @AfterClass
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        currentSpark.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Record writeAndRead(String desc, Schema writeSchema, Schema readSchema, Record record) throws IOException {
        File parent = this.temp.newFolder(desc);
        File location = new File(parent, "test");
        File dataFolder = new File(location, "data");
        Assert.assertTrue((String)"mkdirs should succeed", (boolean)dataFolder.mkdirs());
        File testFile = new File(dataFolder, this.format.addExtension(UUID.randomUUID().toString()));
        TestTables.TestTable table = TestTables.create(location, desc, writeSchema, PartitionSpec.unpartitioned(), (Map<String, String>)ImmutableMap.of((Object)"read.data-planning-mode", (Object)this.planningMode.modeName(), (Object)"read.delete-planning-mode", (Object)this.planningMode.modeName()));
        try {
            Schema tableSchema = table.schema();
            try (FileAppender writer = new GenericAppenderFactory(tableSchema).newAppender(Files.localOutput((File)testFile), this.format);){
                writer.add((Object)record);
            }
            DataFile file = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withRecordCount(100L).withFileSizeInBytes(testFile.length()).withPath(testFile.toString()).build();
            table.newAppend().appendFile(file).commit();
            HashMap idMapping = Maps.newHashMap();
            for (int id : this.allIds(writeSchema)) {
                String originalName = writeSchema.findColumnName(id);
                idMapping.put(id, tableSchema.findField(originalName).fieldId());
            }
            Schema expectedSchema = this.reassignIds(readSchema, idMapping);
            TestTables.replaceMetadata(desc, TestTables.readMetadata(desc).updateSchema(expectedSchema, 100));
            Dataset df = spark.read().format("org.apache.iceberg.spark.source.TestIcebergSource").option("iceberg.table.name", desc).option("vectorization-enabled", String.valueOf(this.vectorized)).load();
            Record record2 = SparkValueConverter.convert((Schema)readSchema, (Row)((Row)df.collectAsList().get(0)));
            return record2;
        }
        finally {
            TestTables.clearTables();
        }
    }

    private List<Integer> allIds(Schema schema) {
        final ArrayList ids = Lists.newArrayList();
        TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)new TypeUtil.SchemaVisitor<Void>(){

            public Void field(Types.NestedField field, Void fieldResult) {
                ids.add(field.fieldId());
                return null;
            }

            public Void list(Types.ListType list, Void elementResult) {
                ids.add(list.elementId());
                return null;
            }

            public Void map(Types.MapType map, Void keyResult, Void valueResult) {
                ids.add(map.keyId());
                ids.add(map.valueId());
                return null;
            }
        });
        return ids;
    }

    private Schema reassignIds(Schema schema, final Map<Integer, Integer> idMapping) {
        return new Schema(((Type)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)new TypeUtil.SchemaVisitor<Type>(){

            private int mapId(int id) {
                if (idMapping.containsKey(id)) {
                    return (Integer)idMapping.get(id);
                }
                return 1000 + id;
            }

            public Type schema(Schema schema, Type structResult) {
                return structResult;
            }

            public Type struct(Types.StructType struct, List<Type> fieldResults) {
                ArrayList newFields = Lists.newArrayListWithExpectedSize((int)fieldResults.size());
                List fields = struct.fields();
                for (int i = 0; i < fields.size(); ++i) {
                    Types.NestedField field = (Types.NestedField)fields.get(i);
                    if (field.isOptional()) {
                        newFields.add(Types.NestedField.optional((int)this.mapId(field.fieldId()), (String)field.name(), (Type)fieldResults.get(i)));
                        continue;
                    }
                    newFields.add(Types.NestedField.required((int)this.mapId(field.fieldId()), (String)field.name(), (Type)fieldResults.get(i)));
                }
                return Types.StructType.of((List)newFields);
            }

            public Type field(Types.NestedField field, Type fieldResult) {
                return fieldResult;
            }

            public Type list(Types.ListType list, Type elementResult) {
                if (list.isElementOptional()) {
                    return Types.ListType.ofOptional((int)this.mapId(list.elementId()), (Type)elementResult);
                }
                return Types.ListType.ofRequired((int)this.mapId(list.elementId()), (Type)elementResult);
            }

            public Type map(Types.MapType map, Type keyResult, Type valueResult) {
                if (map.isValueOptional()) {
                    return Types.MapType.ofOptional((int)this.mapId(map.keyId()), (int)this.mapId(map.valueId()), (Type)keyResult, (Type)valueResult);
                }
                return Types.MapType.ofRequired((int)this.mapId(map.keyId()), (int)this.mapId(map.valueId()), (Type)keyResult, (Type)valueResult);
            }

            public Type primitive(Type.PrimitiveType primitive) {
                return primitive;
            }
        })).asNestedType().asStructType().fields());
    }
}

