/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.iceberg.spark.SystemFunctionPushDownHelper;
import org.apache.iceberg.spark.functions.BucketFunction;
import org.apache.iceberg.spark.functions.DaysFunction;
import org.apache.iceberg.spark.functions.HoursFunction;
import org.apache.iceberg.spark.functions.MonthsFunction;
import org.apache.iceberg.spark.functions.TruncateFunction;
import org.apache.iceberg.spark.functions.YearsFunction;
import org.apache.iceberg.spark.source.SparkScan;
import org.apache.iceberg.spark.source.SparkScanBuilder;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.UserDefinedScalarFunc;
import org.apache.spark.sql.connector.expressions.filter.And;
import org.apache.spark.sql.connector.expressions.filter.Not;
import org.apache.spark.sql.connector.expressions.filter.Or;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsPushDownV2Filters;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSparkScan
extends SparkTestBaseWithCatalog {
    private final String format;

    @Parameterized.Parameters(name="format = {0}")
    public static Object[] parameters() {
        return new Object[]{"parquet", "avro", "orc"};
    }

    public TestSparkScan(String format) {
        this.format = format;
    }

    @Before
    public void useCatalog() {
        this.sql("USE %s", this.catalogName);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testEstimatedRowCount() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id BIGINT, date DATE) USING iceberg TBLPROPERTIES('%s' = '%s')", this.tableName, "write.format.default", this.format);
        Dataset df = spark.range(10000L).withColumn("date", functions.date_add((Column)functions.expr((String)"DATE '1970-01-01'"), (Column)functions.expr((String)"CAST(id AS INT)"))).select("id", new String[]{"date"});
        df.coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SparkScanBuilder scanBuilder = new SparkScanBuilder(spark, table, CaseInsensitiveStringMap.empty());
        SparkScan scan = (SparkScan)scanBuilder.build();
        Statistics stats = scan.estimateStatistics();
        Assert.assertEquals((long)10000L, (long)stats.numRows().getAsLong());
    }

    @Test
    public void testUnpartitionedYears() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        YearsFunction.TimestampToYearsFunction function = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate("=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(SystemFunctionPushDownHelper.timestampStrToYearOrdinal("2017-11-22T00:00:00.000000+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @Test
    public void testPartitionedYears() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "years(ts)");
        SparkScanBuilder builder = this.scanBuilder();
        YearsFunction.TimestampToYearsFunction function = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate("=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(SystemFunctionPushDownHelper.timestampStrToYearOrdinal("2017-11-22T00:00:00.000000+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
    }

    @Test
    public void testUnpartitionedMonths() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        MonthsFunction.TimestampToMonthsFunction function = new MonthsFunction.TimestampToMonthsFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate(">", this.expressions(new Expression[]{udf, TestSparkScan.intLit(SystemFunctionPushDownHelper.timestampStrToMonthOrdinal("2017-11-22T00:00:00.000000+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @Test
    public void testPartitionedMonths() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "months(ts)");
        SparkScanBuilder builder = this.scanBuilder();
        MonthsFunction.TimestampToMonthsFunction function = new MonthsFunction.TimestampToMonthsFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate(">", this.expressions(new Expression[]{udf, TestSparkScan.intLit(SystemFunctionPushDownHelper.timestampStrToMonthOrdinal("2017-11-22T00:00:00.000000+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
    }

    @Test
    public void testUnpartitionedDays() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        DaysFunction.TimestampToDaysFunction function = new DaysFunction.TimestampToDaysFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate("<", this.expressions(new Expression[]{udf, TestSparkScan.dateLit(SystemFunctionPushDownHelper.timestampStrToDayOrdinal("2018-11-20T00:00:00.000000+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @Test
    public void testPartitionedDays() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "days(ts)");
        SparkScanBuilder builder = this.scanBuilder();
        DaysFunction.TimestampToDaysFunction function = new DaysFunction.TimestampToDaysFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate("<", this.expressions(new Expression[]{udf, TestSparkScan.dateLit(SystemFunctionPushDownHelper.timestampStrToDayOrdinal("2018-11-20T00:00:00.000000+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
    }

    @Test
    public void testUnpartitionedHours() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        HoursFunction.TimestampToHoursFunction function = new HoursFunction.TimestampToHoursFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(SystemFunctionPushDownHelper.timestampStrToHourOrdinal("2017-11-22T06:02:09.243857+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @Test
    public void testPartitionedHours() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "hours(ts)");
        SparkScanBuilder builder = this.scanBuilder();
        HoursFunction.TimestampToHoursFunction function = new HoursFunction.TimestampToHoursFunction();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(SystemFunctionPushDownHelper.timestampStrToHourOrdinal("2017-11-22T06:02:09.243857+00:00"))}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(8);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(2);
    }

    @Test
    public void testUnpartitionedBucketLong() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        BucketFunction.BucketLong function = new BucketFunction.BucketLong(DataTypes.LongType);
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("id")}));
        Predicate predicate = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @Test
    public void testPartitionedBucketLong() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "bucket(5, id)");
        SparkScanBuilder builder = this.scanBuilder();
        BucketFunction.BucketLong function = new BucketFunction.BucketLong(DataTypes.LongType);
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("id")}));
        Predicate predicate = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(6);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(4);
    }

    @Test
    public void testUnpartitionedBucketString() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        BucketFunction.BucketString function = new BucketFunction.BucketString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("<=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @Test
    public void testPartitionedBucketString() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "bucket(5, data)");
        SparkScanBuilder builder = this.scanBuilder();
        BucketFunction.BucketString function = new BucketFunction.BucketString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("<=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(6);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(4);
    }

    @Test
    public void testUnpartitionedTruncateString() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        TruncateFunction.TruncateString function = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(4), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("<>", this.expressions(new Expression[]{udf, TestSparkScan.stringLit("data")}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @Test
    public void testPartitionedTruncateString() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "truncate(4, data)");
        SparkScanBuilder builder = this.scanBuilder();
        TruncateFunction.TruncateString function = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(4), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("<>", this.expressions(new Expression[]{udf, TestSparkScan.stringLit("data")}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(5);
    }

    @Test
    public void testUnpartitionedIsNull() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        TruncateFunction.TruncateString function = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(4), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("IS_NULL", this.expressions(new Expression[]{udf}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @Test
    public void testPartitionedIsNull() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "truncate(4, data)");
        SparkScanBuilder builder = this.scanBuilder();
        TruncateFunction.TruncateString function = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(4), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("IS_NULL", this.expressions(new Expression[]{udf}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(0);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @Test
    public void testUnpartitionedIsNotNull() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        TruncateFunction.TruncateString function = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(4), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("IS_NOT_NULL", this.expressions(new Expression[]{udf}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @Test
    public void testPartitionedIsNotNull() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "truncate(4, data)");
        SparkScanBuilder builder = this.scanBuilder();
        TruncateFunction.TruncateString function = new TruncateFunction.TruncateString();
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)function, this.expressions(new Expression[]{TestSparkScan.intLit(4), TestSparkScan.fieldRef("data")}));
        Predicate predicate = new Predicate("IS_NOT_NULL", this.expressions(new Expression[]{udf}));
        this.pushFilters((ScanBuilder)builder, predicate);
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not(predicate);
        this.pushFilters((ScanBuilder)builder, predicate);
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(0);
    }

    @Test
    public void testUnpartitionedAnd() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        YearsFunction.TimestampToYearsFunction tsToYears = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf1 = TestSparkScan.toUDF((BoundFunction)tsToYears, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate1 = new Predicate("=", this.expressions(new Expression[]{udf1, TestSparkScan.intLit(47)}));
        BucketFunction.BucketLong bucketLong = new BucketFunction.BucketLong(DataTypes.LongType);
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)bucketLong, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("id")}));
        Predicate predicate2 = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        And predicate = new And(predicate1, predicate2);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not((Predicate)predicate);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @Test
    public void testPartitionedAnd() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "years(ts), bucket(5, id)");
        SparkScanBuilder builder = this.scanBuilder();
        YearsFunction.TimestampToYearsFunction tsToYears = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf1 = TestSparkScan.toUDF((BoundFunction)tsToYears, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate1 = new Predicate("=", this.expressions(new Expression[]{udf1, TestSparkScan.intLit(47)}));
        BucketFunction.BucketLong bucketLong = new BucketFunction.BucketLong(DataTypes.LongType);
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)bucketLong, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("id")}));
        Predicate predicate2 = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        And predicate = new And(predicate1, predicate2);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(1);
        builder = this.scanBuilder();
        predicate = new Not((Predicate)predicate);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(9);
    }

    @Test
    public void testUnpartitionedOr() throws Exception {
        SystemFunctionPushDownHelper.createUnpartitionedTable(spark, this.tableName);
        SparkScanBuilder builder = this.scanBuilder();
        YearsFunction.TimestampToYearsFunction tsToYears = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf1 = TestSparkScan.toUDF((BoundFunction)tsToYears, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate1 = new Predicate("=", this.expressions(new Expression[]{udf1, TestSparkScan.intLit(47)}));
        BucketFunction.BucketLong bucketLong = new BucketFunction.BucketLong(DataTypes.LongType);
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)bucketLong, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("id")}));
        Predicate predicate2 = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        Or predicate = new Or(predicate1, predicate2);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
        builder = this.scanBuilder();
        predicate = new Not((Predicate)predicate);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(10);
    }

    @Test
    public void testPartitionedOr() throws Exception {
        SystemFunctionPushDownHelper.createPartitionedTable(spark, this.tableName, "years(ts), bucket(5, id)");
        SparkScanBuilder builder = this.scanBuilder();
        YearsFunction.TimestampToYearsFunction tsToYears = new YearsFunction.TimestampToYearsFunction();
        UserDefinedScalarFunc udf1 = TestSparkScan.toUDF((BoundFunction)tsToYears, this.expressions(new Expression[]{TestSparkScan.fieldRef("ts")}));
        Predicate predicate1 = new Predicate("=", this.expressions(new Expression[]{udf1, TestSparkScan.intLit(48)}));
        BucketFunction.BucketLong bucketLong = new BucketFunction.BucketLong(DataTypes.LongType);
        UserDefinedScalarFunc udf = TestSparkScan.toUDF((BoundFunction)bucketLong, this.expressions(new Expression[]{TestSparkScan.intLit(5), TestSparkScan.fieldRef("id")}));
        Predicate predicate2 = new Predicate(">=", this.expressions(new Expression[]{udf, TestSparkScan.intLit(2)}));
        Or predicate = new Or(predicate1, predicate2);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        Batch scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(6);
        builder = this.scanBuilder();
        predicate = new Not((Predicate)predicate);
        this.pushFilters((ScanBuilder)builder, new Predicate[]{predicate});
        scan = builder.build().toBatch();
        Assertions.assertThat((int)scan.planInputPartitions().length).isEqualTo(4);
    }

    private SparkScanBuilder scanBuilder() throws Exception {
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)ImmutableMap.of((Object)"path", (Object)this.tableName));
        return new SparkScanBuilder(spark, table, options);
    }

    private void pushFilters(ScanBuilder scan, Predicate ... predicates) {
        Assertions.assertThat((Object)scan).isInstanceOf(SupportsPushDownV2Filters.class);
        SupportsPushDownV2Filters filterable = (SupportsPushDownV2Filters)scan;
        filterable.pushPredicates(predicates);
    }

    private Expression[] expressions(Expression ... expressions) {
        return expressions;
    }

    private static LiteralValue<Integer> intLit(int value) {
        return LiteralValue.apply((Object)value, (DataType)DataTypes.IntegerType);
    }

    private static LiteralValue<Integer> dateLit(int value) {
        return LiteralValue.apply((Object)value, (DataType)DataTypes.DateType);
    }

    private static LiteralValue<String> stringLit(String value) {
        return LiteralValue.apply((Object)value, (DataType)DataTypes.StringType);
    }

    private static NamedReference fieldRef(String col) {
        return FieldReference.apply((String)col);
    }

    private static UserDefinedScalarFunc toUDF(BoundFunction function, Expression[] expressions) {
        return new UserDefinedScalarFunc(function.name(), function.canonicalName(), expressions);
    }
}

