/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.TestWriterMetrics;
import org.apache.iceberg.spark.source.SparkFileWriterFactory;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.unsafe.types.UTF8String;

public class TestSparkWriterMetrics
extends TestWriterMetrics<InternalRow> {
    public TestSparkWriterMetrics(FileFormat fileFormat) {
        super(fileFormat);
    }

    protected FileWriterFactory<InternalRow> newWriterFactory(Table sourceTable) {
        return SparkFileWriterFactory.builderFor((Table)sourceTable).dataSchema(sourceTable.schema()).dataFileFormat(this.fileFormat).deleteFileFormat(this.fileFormat).positionDeleteRowSchema(sourceTable.schema()).build();
    }

    protected InternalRow toRow(Integer id, String data, boolean boolValue, Long longValue) {
        GenericInternalRow row = new GenericInternalRow(3);
        row.update(0, (Object)id);
        row.update(1, (Object)UTF8String.fromString((String)data));
        GenericInternalRow nested = new GenericInternalRow(2);
        nested.update(0, (Object)boolValue);
        nested.update(1, (Object)longValue);
        row.update(2, (Object)nested);
        return row;
    }

    protected InternalRow toGenericRow(int value, int repeated) {
        GenericInternalRow row = new GenericInternalRow(repeated);
        for (int i = 0; i < repeated; ++i) {
            row.update(i, (Object)value);
        }
        return row;
    }
}

