/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import org.apache.iceberg.spark.source.StreamingOffset;
import org.apache.iceberg.util.JsonUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamingOffset {
    @Test
    public void testJsonConversion() {
        Object[] expected = new StreamingOffset[]{new StreamingOffset(System.currentTimeMillis(), 1L, false), new StreamingOffset(System.currentTimeMillis(), 2L, false), new StreamingOffset(System.currentTimeMillis(), 3L, false), new StreamingOffset(System.currentTimeMillis(), 4L, true)};
        Assert.assertArrayEquals((String)"StreamingOffsets should match", (Object[])expected, (Object[])Arrays.stream(expected).map(elem -> StreamingOffset.fromJson((String)elem.json())).toArray());
    }

    @Test
    public void testToJson() throws Exception {
        StreamingOffset expected = new StreamingOffset(System.currentTimeMillis(), 1L, false);
        ObjectNode actual = JsonUtil.mapper().createObjectNode();
        actual.put("version", 1);
        actual.put("snapshot_id", expected.snapshotId());
        actual.put("position", 1L);
        actual.put("scan_all_files", false);
        String expectedJson = expected.json();
        String actualJson = JsonUtil.mapper().writeValueAsString((Object)actual);
        Assert.assertEquals((String)"Json should match", (Object)expectedJson, (Object)actualJson);
    }
}

