/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestNamespaceSQL
extends SparkCatalogTestBase {
    private static final Namespace NS = Namespace.of((String[])new String[]{"db"});
    private final String fullNamespace;
    private final boolean isHadoopCatalog;

    public TestNamespaceSQL(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
        this.fullNamespace = (String)("spark_catalog".equals(catalogName) ? "" : catalogName + ".") + NS;
        this.isHadoopCatalog = "testhadoop".equals(catalogName);
    }

    @After
    public void cleanNamespaces() {
        this.sql("DROP TABLE IF EXISTS %s.table", this.fullNamespace);
        this.sql("DROP NAMESPACE IF EXISTS %s", this.fullNamespace);
    }

    @Test
    public void testCreateNamespace() {
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        this.sql("CREATE NAMESPACE %s", this.fullNamespace);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
    }

    @Test
    public void testDefaultNamespace() {
        Assume.assumeFalse((String)"Hadoop has no default namespace configured", (boolean)this.isHadoopCatalog);
        this.sql("USE %s", this.catalogName);
        Object[] current = (Object[])Iterables.getOnlyElement(this.sql("SHOW CURRENT NAMESPACE", new Object[0]));
        Assert.assertEquals((String)"Should use the current catalog", (Object)current[0], (Object)this.catalogName);
        Assert.assertEquals((String)"Should use the configured default namespace", (Object)current[1], (Object)"default");
    }

    @Test
    public void testDropEmptyNamespace() {
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        this.sql("CREATE NAMESPACE %s", this.fullNamespace);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        this.sql("DROP NAMESPACE %s", this.fullNamespace);
        Assert.assertFalse((String)"Namespace should have been dropped", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
    }

    @Test
    public void testDropNonEmptyNamespace() {
        Assume.assumeFalse((String)"Session catalog has flaky behavior", (boolean)"spark_catalog".equals(this.catalogName));
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        this.sql("CREATE NAMESPACE %s", this.fullNamespace);
        this.sql("CREATE TABLE %s.table (id bigint) USING iceberg", this.fullNamespace);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        Assert.assertTrue((String)"Table should exist", (boolean)this.validationCatalog.tableExists(TableIdentifier.of((Namespace)NS, (String)"table")));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("DROP NAMESPACE %s", this.fullNamespace)).isInstanceOf(NamespaceNotEmptyException.class)).hasMessageStartingWith("Namespace db is not empty.");
        this.sql("DROP TABLE %s.table", this.fullNamespace);
    }

    @Test
    public void testListTables() {
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        this.sql("CREATE NAMESPACE %s", this.fullNamespace);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        List<Object[]> rows = this.sql("SHOW TABLES IN %s", this.fullNamespace);
        Assert.assertEquals((String)"Should not list any tables", (long)0L, (long)rows.size());
        this.sql("CREATE TABLE %s.table (id bigint) USING iceberg", this.fullNamespace);
        Object[] row = (Object[])Iterables.getOnlyElement(this.sql("SHOW TABLES IN %s", this.fullNamespace));
        Assert.assertEquals((String)"Namespace should match", (Object)"db", (Object)row[0]);
        Assert.assertEquals((String)"Table name should match", (Object)"table", (Object)row[1]);
    }

    @Test
    public void testListNamespace() {
        Set namespaceNames;
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        this.sql("CREATE NAMESPACE %s", this.fullNamespace);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        List<Object[]> namespaces = this.sql("SHOW NAMESPACES IN %s", this.catalogName);
        if (this.isHadoopCatalog) {
            Assert.assertEquals((String)"Should have 1 namespace", (long)1L, (long)namespaces.size());
            namespaceNames = namespaces.stream().map(arr -> arr[0].toString()).collect(Collectors.toSet());
            Assert.assertEquals((String)"Should have only db namespace", (Object)ImmutableSet.of((Object)"db"), namespaceNames);
        } else {
            Assert.assertEquals((String)"Should have 2 namespaces", (long)2L, (long)namespaces.size());
            namespaceNames = namespaces.stream().map(arr -> arr[0].toString()).collect(Collectors.toSet());
            Assert.assertEquals((String)"Should have default and db namespaces", (Object)ImmutableSet.of((Object)"default", (Object)"db"), namespaceNames);
        }
        List<Object[]> nestedNamespaces = this.sql("SHOW NAMESPACES IN %s", this.fullNamespace);
        Set nestedNames = nestedNamespaces.stream().map(arr -> arr[0].toString()).collect(Collectors.toSet());
        Assert.assertEquals((String)"Should not have nested namespaces", (Object)ImmutableSet.of(), nestedNames);
    }

    @Test
    public void testCreateNamespaceWithMetadata() {
        Assume.assumeFalse((String)"HadoopCatalog does not support namespace metadata", (boolean)this.isHadoopCatalog);
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        this.sql("CREATE NAMESPACE %s WITH PROPERTIES ('prop'='value')", this.fullNamespace);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(NS);
        Assert.assertEquals((String)"Namespace should have expected prop value", (Object)"value", nsMetadata.get("prop"));
    }

    @Test
    public void testCreateNamespaceWithComment() {
        Assume.assumeFalse((String)"HadoopCatalog does not support namespace metadata", (boolean)this.isHadoopCatalog);
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        this.sql("CREATE NAMESPACE %s COMMENT 'namespace doc'", this.fullNamespace);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(NS);
        Assert.assertEquals((String)"Namespace should have expected comment", (Object)"namespace doc", nsMetadata.get("comment"));
    }

    @Test
    public void testCreateNamespaceWithLocation() throws Exception {
        Assume.assumeFalse((String)"HadoopCatalog does not support namespace locations", (boolean)this.isHadoopCatalog);
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        File location = this.temp.newFile();
        Assert.assertTrue((boolean)location.delete());
        this.sql("CREATE NAMESPACE %s LOCATION '%s'", this.fullNamespace, location);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(NS);
        Assert.assertEquals((String)"Namespace should have expected location", (Object)("file:" + location.getPath()), nsMetadata.get("location"));
    }

    @Test
    public void testSetProperties() {
        Assume.assumeFalse((String)"HadoopCatalog does not support namespace metadata", (boolean)this.isHadoopCatalog);
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        this.sql("CREATE NAMESPACE %s", this.fullNamespace);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(NS));
        Map defaultMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(NS);
        Assert.assertFalse((String)"Default metadata should not have custom property", (boolean)defaultMetadata.containsKey("prop"));
        this.sql("ALTER NAMESPACE %s SET PROPERTIES ('prop'='value')", this.fullNamespace);
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(NS);
        Assert.assertEquals((String)"Namespace should have expected prop value", (Object)"value", nsMetadata.get("prop"));
    }
}

